/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.Resource;
import com.android.tools.r8.dex.BaseFile;
import com.android.tools.r8.dex.Constants;
import com.android.tools.r8.errors.CompilationError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class VDexFile
extends BaseFile {
    final String name;
    private final int version;

    public VDexFile(Resource resource) throws IOException {
        super(resource);
        this.name = "resource.vdex";
        this.version = VDexFile.parseMagic(this.buffer);
        if (!VDexFile.supportedVersion(this.version)) {
            throw new CompilationError("Unsupported vdex file version " + this.version);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean couldBeVDexFile(Path file) {
        try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);){
            if (channel.size() < 24L) {
                boolean bl2 = false;
                return bl2;
            }
            ByteBuffer buffer = ByteBuffer.allocate(24);
            channel.read(buffer);
            boolean bl = VDexFile.couldBeVDexFile(buffer);
            return bl;
        }
        catch (CompilationError | IOException e) {
            return false;
        }
    }

    static boolean couldBeVDexFile(ByteBuffer buffer) {
        int versionNumber = VDexFile.parseMagic(buffer);
        return VDexFile.supportedVersion(versionNumber);
    }

    static boolean supportedVersion(int versionNumber) {
        return 10 <= versionNumber && versionNumber <= 11;
    }

    private static int parseMagic(ByteBuffer buffer) {
        int index = 0;
        for (byte prefixByte : Constants.VDEX_FILE_MAGIC_PREFIX) {
            if (buffer.get(index++) == prefixByte) continue;
            throw new CompilationError("VDex file has invalid header");
        }
        byte[] version = new byte[4];
        for (int i = 0; i < 4; ++i) {
            if (!buffer.hasRemaining()) {
                throw new CompilationError("Truncated VDex file - unable to read version");
            }
            version[i] = buffer.get(index++);
        }
        if (version[3] != 0) {
            throw new CompilationError("VDex file has invalid version number");
        }
        int versionNumber = 0;
        for (int i = 0; i < 3; ++i) {
            if (48 > version[i] || version[i] > 57) {
                throw new CompilationError("VDex file has invalid version number");
            }
            versionNumber = versionNumber * 10 + version[i] - 48;
        }
        return versionNumber;
    }

    public static int firstDexOffset(int numberOfDexFiles) {
        return 24 + numberOfDexFiles * 4;
    }

    @Override
    void setByteOrder() {
        int endian;
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        int dexFiles = this.buffer.getInt(8);
        if (dexFiles < 0 || dexFiles > 1000) {
            this.buffer.order(ByteOrder.BIG_ENDIAN);
            dexFiles = this.buffer.getInt(8);
            assert (dexFiles < 0 || dexFiles > 1000);
        }
        if ((endian = this.buffer.getInt(VDexFile.firstDexOffset(dexFiles) + 40)) != 305419896) {
            throw new CompilationError("Unable to determine endianess for reading vdex file.");
        }
    }

    int getVDexVersion() {
        return this.version;
    }
}

