/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.regalloc;

import com.android.tools.r8.com.google.common.collect.HashMultiset;
import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.com.google.common.collect.Multisets;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.And;
import com.android.tools.r8.ir.code.ArithmeticBinop;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.DebugLocalsChange;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Or;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.code.Xor;
import com.android.tools.r8.ir.regalloc.LiveIntervals;
import com.android.tools.r8.ir.regalloc.LiveIntervalsUse;
import com.android.tools.r8.ir.regalloc.LiveRange;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.ir.regalloc.RegisterPositions;
import com.android.tools.r8.ir.regalloc.SpillMoveSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class LinearScanRegisterAllocator
implements RegisterAllocator {
    public static final int REGISTER_CANDIDATE_NOT_FOUND = -1;
    public static final int MIN_CONSTANT_FREE_FOR_POSITIONS = 5;
    private static final int MAX_SMALL_REGISTER = 15;
    private static final int NUMBER_OF_SENTINEL_REGISTERS = 2;
    private final IRCode code;
    private final int numberOfArgumentRegisters;
    private final InternalOptions options;
    private Map<BasicBlock, Set<Value>> liveAtEntrySets;
    private Value preArgumentSentinelValue = null;
    private TreeSet<Integer> freeRegisters = new TreeSet();
    private int maxRegisterNumber = 0;
    private int nextUnusedRegisterNumber = 0;
    private List<LiveIntervals> liveIntervals = new ArrayList<LiveIntervals>();
    private List<LiveIntervals> active = new LinkedList<LiveIntervals>();
    protected List<LiveIntervals> inactive = new LinkedList<LiveIntervals>();
    protected PriorityQueue<LiveIntervals> unhandled = new PriorityQueue();
    private int firstParallelMoveTemporary = Integer.MIN_VALUE;
    private int[] unusedRegisters = null;
    private boolean hasDedicatedMoveExceptionRegister = false;

    public LinearScanRegisterAllocator(IRCode code, InternalOptions options) {
        this.code = code;
        this.options = options;
        int argumentRegisters = 0;
        for (Instruction instruction : code.blocks.getFirst().getInstructions()) {
            if (!instruction.isArgument()) continue;
            argumentRegisters += instruction.outValue().requiredRegisters();
        }
        this.numberOfArgumentRegisters = argumentRegisters;
    }

    @Override
    public void allocateRegisters(boolean debug) {
        assert (this.noLinkedValues());
        assert (this.code.isConsistentSSA());
        this.computeNeedsRegister();
        this.insertArgumentMoves();
        BasicBlock[] blocks = this.computeLivenessInformation();
        boolean noSpilling = this.performAllocationWithoutMoveInsertion(ArgumentReuseMode.ALLOW_ARGUMENT_REUSE);
        if (!noSpilling || this.highestUsedRegister() > 15) {
            this.clearRegisterAssignments();
            this.performAllocation(ArgumentReuseMode.DISALLOW_ARGUMENT_REUSE);
        } else {
            this.insertMoves();
            if (this.highestUsedRegister() > 15) {
                this.clearRegisterAssignments();
                this.removeSpillAndPhiMoves();
                this.performAllocation(ArgumentReuseMode.DISALLOW_ARGUMENT_REUSE);
            }
        }
        assert (this.code.isConsistentGraph());
        this.computeUnusedRegisters();
        if (debug) {
            this.computeDebugInfo(blocks);
        }
        this.clearUserInfo();
        this.clearState();
    }

    private static Integer nextInRange(int start, int end, List<Integer> points) {
        while (!points.isEmpty() && points.get(0) < start) {
            points.remove(0);
        }
        if (points.isEmpty()) {
            return null;
        }
        Integer next = points.get(0);
        assert (start <= next);
        if (next < end) {
            points.remove(0);
            return next;
        }
        return null;
    }

    private void computeDebugInfo(BasicBlock[] blocks) {
        LinearScanRegisterAllocator.computeDebugInfo(blocks, this.liveIntervals, this);
    }

    public static void computeDebugInfo(BasicBlock[] blocks, List<LiveIntervals> liveIntervals, RegisterAllocator allocator) {
        ArrayList<LocalRange> ranges = new ArrayList<LocalRange>();
        for (LiveIntervals interval : liveIntervals) {
            Value value = interval.getValue();
            if (!value.hasLocalInfo()) continue;
            List<Integer> starts = ListUtils.map(value.getDebugLocalStarts(), Instruction::getNumber);
            List<Integer> ends = ListUtils.map(value.getDebugLocalEnds(), Instruction::getNumber);
            ArrayList<LiveRange> liveRanges = new ArrayList<LiveRange>();
            liveRanges.addAll(interval.getRanges());
            for (LiveIntervals child : interval.getSplitChildren()) {
                assert (child.getValue() == value);
                assert (child.getSplitChildren() == null || child.getSplitChildren().isEmpty());
                liveRanges.addAll(child.getRanges());
            }
            liveRanges.sort((r1, r2) -> Integer.compare(r1.start, r2.start));
            starts.sort(Integer::compare);
            ends.sort(Integer::compare);
            for (LiveRange liveRange : liveRanges) {
                Integer nextEnd;
                int start = liveRange.start;
                int end = liveRange.end;
                while ((nextEnd = LinearScanRegisterAllocator.nextInRange(start, end, ends)) != null) {
                    int register = allocator.getArgumentOrAllocateRegisterForValue(value, start);
                    ranges.add(new LocalRange(value, register, start, nextEnd));
                    Integer nextStart = LinearScanRegisterAllocator.nextInRange(nextEnd, end, starts);
                    if (nextStart == null) {
                        start = -1;
                        break;
                    }
                    start = nextStart;
                }
                if (start < 0) continue;
                ranges.add(new LocalRange(value, allocator.getArgumentOrAllocateRegisterForValue(value, start), start, end));
            }
        }
        if (ranges.isEmpty()) {
            return;
        }
        ranges.sort(LocalRange::compareTo);
        boolean localsChanged = false;
        Int2ReferenceOpenHashMap<DebugLocalInfo> currentLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
        LinkedList<LocalRange> openRanges = new LinkedList<LocalRange>();
        Iterator rangeIterator = ranges.iterator();
        LocalRange nextStartingRange = (LocalRange)rangeIterator.next();
        while (nextStartingRange != null && nextStartingRange.start == 0) {
            currentLocals.put(nextStartingRange.register, nextStartingRange.local);
            openRanges.add(nextStartingRange);
            nextStartingRange = rangeIterator.hasNext() ? (LocalRange)rangeIterator.next() : null;
        }
        for (BasicBlock block : blocks) {
            InstructionListIterator instructionIterator = block.listIterator();
            int entryIndex = block.entry().getNumber();
            if (block.entry().isMoveException()) {
                ++entryIndex;
            }
            ListIterator it = openRanges.listIterator(0);
            while (it.hasNext()) {
                LocalRange openRange = (LocalRange)it.next();
                if (openRange.end >= entryIndex && (openRange.end != entryIndex || block.entry().isMoveException() || LinearScanRegisterAllocator.usesValues(openRange.value, block.entry()))) continue;
                it.remove();
                assert (currentLocals.get(openRange.register) == openRange.local);
                currentLocals.remove(openRange.register);
            }
            while (nextStartingRange != null && nextStartingRange.start < entryIndex) {
                if (entryIndex <= nextStartingRange.end) {
                    openRanges.add(nextStartingRange);
                    assert (!currentLocals.containsKey(nextStartingRange.register));
                    currentLocals.put(nextStartingRange.register, nextStartingRange.local);
                }
                nextStartingRange = rangeIterator.hasNext() ? (LocalRange)rangeIterator.next() : null;
            }
            if (block.entry().isMoveException()) {
                LinearScanRegisterAllocator.fixupLocalsLiveAtMoveException(block, instructionIterator, openRanges, currentLocals, allocator);
            } else {
                block.setLocalsAtEntry(new Int2ReferenceOpenHashMap<DebugLocalInfo>((Int2ReferenceMap<DebugLocalInfo>)currentLocals));
            }
            while (instructionIterator.hasNext()) {
                DebugLocalsChange change;
                Instruction instruction = (Instruction)instructionIterator.next();
                if (instruction.isDebugLocalRead()) {
                    assert (!instruction.getDebugValues().isEmpty());
                    instruction.clearDebugValues();
                    instructionIterator.remove();
                }
                if (LinearScanRegisterAllocator.isSpillInstruction(instruction)) continue;
                int index = instruction.getNumber();
                ListIterator<LocalRange> it2 = openRanges.listIterator(0);
                Int2ReferenceOpenHashMap<DebugLocalInfo> ending = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
                Int2ReferenceOpenHashMap<DebugLocalInfo> starting = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
                while (it2.hasNext()) {
                    LocalRange openRange = it2.next();
                    if (openRange.end > index) continue;
                    it2.remove();
                    assert (currentLocals.get(openRange.register) == openRange.local);
                    currentLocals.remove(openRange.register);
                    localsChanged = true;
                    ending.put(openRange.register, openRange.local);
                }
                while (nextStartingRange != null && nextStartingRange.start <= index) {
                    if (index < nextStartingRange.end) {
                        openRanges.add(nextStartingRange);
                        assert (!currentLocals.containsKey(nextStartingRange.register));
                        currentLocals.put(nextStartingRange.register, nextStartingRange.local);
                        starting.put(nextStartingRange.register, nextStartingRange.local);
                        localsChanged = true;
                    }
                    nextStartingRange = rangeIterator.hasNext() ? (LocalRange)rangeIterator.next() : null;
                }
                if (localsChanged && instruction.getBlock().exit() != instruction && (change = LinearScanRegisterAllocator.createLocalsChange(ending, starting)) != null) {
                    instructionIterator.add(change);
                }
                localsChanged = false;
            }
        }
    }

    private static boolean usesValues(Value usedValue, Instruction instruction) {
        return instruction.inValues().contains(usedValue) || instruction.getDebugValues().contains(usedValue);
    }

    private static void fixupLocalsLiveAtMoveException(BasicBlock block, ListIterator<Instruction> instructionIterator, List<LocalRange> openRanges, Int2ReferenceMap<DebugLocalInfo> finalLocals, RegisterAllocator allocator) {
        Int2ReferenceOpenHashMap<DebugLocalInfo> initialLocals = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
        int exceptionalIndex = block.getPredecessors().get(0).exceptionalExit().getNumber();
        for (LocalRange open : openRanges) {
            int exceptionalRegister = allocator.getArgumentOrAllocateRegisterForValue(open.value, exceptionalIndex);
            initialLocals.put(exceptionalRegister, open.local);
        }
        block.setLocalsAtEntry(new Int2ReferenceOpenHashMap<DebugLocalInfo>((Int2ReferenceMap<DebugLocalInfo>)initialLocals));
        Instruction entry = instructionIterator.next();
        assert (block.entry() == entry);
        assert (block.entry().isMoveException());
        while (instructionIterator.hasNext()) {
            if (LinearScanRegisterAllocator.isSpillInstruction(instructionIterator.next())) continue;
            instructionIterator.previous();
            break;
        }
        Int2ReferenceOpenHashMap<DebugLocalInfo> ending = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
        Int2ReferenceOpenHashMap<DebugLocalInfo> starting = new Int2ReferenceOpenHashMap<DebugLocalInfo>();
        for (Int2ReferenceMap.Entry entry2 : initialLocals.int2ReferenceEntrySet()) {
            if (finalLocals.get(entry2.getIntKey()) == entry2.getValue()) continue;
            ending.put(entry2.getIntKey(), (DebugLocalInfo)entry2.getValue());
        }
        for (Int2ReferenceMap.Entry entry3 : finalLocals.int2ReferenceEntrySet()) {
            if (initialLocals.get(entry3.getIntKey()) == entry3.getValue()) continue;
            starting.put(entry3.getIntKey(), (DebugLocalInfo)entry3.getValue());
        }
        DebugLocalsChange change = LinearScanRegisterAllocator.createLocalsChange(ending, starting);
        if (change != null) {
            instructionIterator.add(change);
        }
    }

    private static DebugLocalsChange createLocalsChange(Int2ReferenceMap<DebugLocalInfo> ending, Int2ReferenceMap<DebugLocalInfo> starting) {
        if (ending.isEmpty() && starting.isEmpty()) {
            return null;
        }
        if (ending.isEmpty() || starting.isEmpty()) {
            return new DebugLocalsChange(ending, starting);
        }
        IntArraySet unneeded = new IntArraySet(Math.min(ending.size(), starting.size()));
        for (Int2ReferenceMap.Entry entry : ending.int2ReferenceEntrySet()) {
            if (starting.get(entry.getIntKey()) != entry.getValue()) continue;
            unneeded.add(entry.getIntKey());
        }
        if (unneeded.size() == ending.size() && unneeded.size() == starting.size()) {
            return null;
        }
        IntIterator iterator = unneeded.iterator();
        while (iterator.hasNext()) {
            int n = iterator.nextInt();
            ending.remove(n);
            starting.remove(n);
        }
        return new DebugLocalsChange(ending, starting);
    }

    private void clearState() {
        this.liveAtEntrySets = null;
        this.liveIntervals = null;
        this.active = null;
        this.inactive = null;
        this.unhandled = null;
        this.freeRegisters = null;
    }

    private void computeUnusedRegisters() {
        if (this.registersUsed() == 0) {
            return;
        }
        HashSet<Integer> usedRegisters = new HashSet<Integer>();
        for (LiveIntervals intervals : this.liveIntervals) {
            this.addRegisterIfUsed(usedRegisters, intervals);
            for (LiveIntervals childIntervals : intervals.getSplitChildren()) {
                this.addRegisterIfUsed(usedRegisters, childIntervals);
            }
        }
        for (int i = this.firstParallelMoveTemporary; i < this.maxRegisterNumber + 1; ++i) {
            usedRegisters.add(this.realRegisterNumberFromAllocated(i));
        }
        int unused = 0;
        int[] computed = new int[this.registersUsed()];
        for (int i = 0; i < this.registersUsed(); ++i) {
            if (!usedRegisters.contains(i)) {
                // empty if block
            }
            computed[i] = ++unused;
        }
        this.unusedRegisters = computed;
    }

    private void addRegisterIfUsed(Set<Integer> used, LiveIntervals intervals) {
        boolean unused = intervals.isSpilledAndRematerializable(this);
        if (!unused) {
            used.add(this.realRegisterNumberFromAllocated(intervals.getRegister()));
            if (intervals.getType().isWide()) {
                used.add(this.realRegisterNumberFromAllocated(intervals.getRegister() + 1));
            }
        }
    }

    @Override
    public boolean argumentValueUsesHighRegister(Value value, int instructionNumber) {
        return this.isHighRegister(this.getRegisterForValue(value, instructionNumber) + value.requiredRegisters() - 1);
    }

    public int highestUsedRegister() {
        return this.registersUsed() - 1;
    }

    @Override
    public int registersUsed() {
        int numberOfRegister = this.maxRegisterNumber + 1 - 2;
        if (this.unusedRegisters != null) {
            return numberOfRegister - this.unusedRegisters[this.unusedRegisters.length - 1];
        }
        return numberOfRegister;
    }

    @Override
    public int getRegisterForValue(Value value, int instructionNumber) {
        if (value.isFixedRegisterValue()) {
            return this.realRegisterNumberFromAllocated(value.asFixedRegisterValue().getRegister());
        }
        LiveIntervals intervals = value.getLiveIntervals();
        if (intervals.hasSplits()) {
            intervals = intervals.getSplitCovering(instructionNumber);
        }
        return this.getRegisterForIntervals(intervals);
    }

    @Override
    public int getArgumentOrAllocateRegisterForValue(Value value, int instructionNumber) {
        if (value.isArgument()) {
            return this.getRegisterForIntervals(value.getLiveIntervals());
        }
        return this.getRegisterForValue(value, instructionNumber);
    }

    private BasicBlock[] computeLivenessInformation() {
        BasicBlock[] blocks = this.code.numberInstructions();
        this.liveAtEntrySets = this.code.computeLiveAtEntrySets();
        this.computeLiveRanges();
        return blocks;
    }

    private boolean performAllocationWithoutMoveInsertion(ArgumentReuseMode mode) {
        this.pinArgumentRegisters();
        return this.performLinearScan(mode);
    }

    private boolean performAllocation(ArgumentReuseMode mode) {
        boolean result = this.performAllocationWithoutMoveInsertion(mode);
        this.insertMoves();
        if (mode == ArgumentReuseMode.DISALLOW_ARGUMENT_REUSE && this.unsplitArguments()) {
            this.removeSpillAndPhiMoves();
            this.insertMoves();
        }
        return result;
    }

    private boolean unsplitArguments() {
        boolean argumentRegisterUnsplit = false;
        for (Value current = this.preArgumentSentinelValue; current != null; current = current.getNextConsecutive()) {
            LiveIntervals intervals = current.getLiveIntervals();
            assert (intervals.getRegisterLimit() == 65535);
            boolean canUseArgumentRegister = true;
            for (LiveIntervals child : intervals.getSplitChildren()) {
                if (child.getRegisterLimit() >= this.highestUsedRegister()) continue;
                canUseArgumentRegister = false;
                break;
            }
            if (!canUseArgumentRegister) continue;
            argumentRegisterUnsplit = true;
            for (LiveIntervals child : intervals.getSplitChildren()) {
                child.clearRegisterAssignment();
                child.setRegister(intervals.getRegister());
                child.setSpilled(false);
            }
        }
        return argumentRegisterUnsplit;
    }

    private void removeSpillAndPhiMoves() {
        for (BasicBlock block : this.code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!LinearScanRegisterAllocator.isSpillInstruction(instruction)) continue;
                it.remove();
            }
        }
    }

    private static boolean isSpillInstruction(Instruction instruction) {
        Value outValue = instruction.outValue();
        if (outValue != null && outValue.isFixedRegisterValue()) {
            assert (instruction.getNumber() == -1);
            assert (instruction.isMove() || instruction.isConstNumber());
            assert (!instruction.isDebugInstruction());
            return true;
        }
        return false;
    }

    private void clearRegisterAssignments() {
        this.freeRegisters.clear();
        this.maxRegisterNumber = 0;
        this.nextUnusedRegisterNumber = 0;
        this.active.clear();
        this.inactive.clear();
        this.unhandled.clear();
        for (LiveIntervals intervals : this.liveIntervals) {
            intervals.clearRegisterAssignment();
        }
    }

    private int getRegisterForIntervals(LiveIntervals intervals) {
        int intervalsRegister = intervals.getRegister();
        return this.realRegisterNumberFromAllocated(intervalsRegister);
    }

    int unadjustedRealRegisterFromAllocated(int allocated) {
        assert (allocated != Integer.MIN_VALUE);
        assert (allocated >= 0);
        int register = allocated < this.numberOfArgumentRegisters + 2 ? this.maxRegisterNumber - (this.numberOfArgumentRegisters - allocated) - 2 : allocated - this.numberOfArgumentRegisters - 2;
        return register;
    }

    int realRegisterNumberFromAllocated(int allocated) {
        int register = this.unadjustedRealRegisterFromAllocated(allocated);
        if (this.unusedRegisters != null) {
            return register - this.unusedRegisters[register];
        }
        return register;
    }

    private boolean isHighRegister(int register) {
        return register > 15;
    }

    private boolean performLinearScan(ArgumentReuseMode mode) {
        this.unhandled.addAll(this.liveIntervals);
        for (LiveIntervals argumentInterval = this.preArgumentSentinelValue.getLiveIntervals(); argumentInterval != null; argumentInterval = argumentInterval.getNextConsecutive()) {
            LiveIntervalsUse use;
            assert (argumentInterval.getRegister() != Integer.MIN_VALUE);
            this.unhandled.remove(argumentInterval);
            if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE) {
                this.active.add(argumentInterval);
                continue;
            }
            if (argumentInterval.getUses().size() <= 1 || (use = argumentInterval.firstUseWithConstraint()) == null) continue;
            LiveIntervals split = argumentInterval.numberOfUsesWithConstraint() == 1 ? argumentInterval.splitBefore(use.getPosition()) : argumentInterval.splitBefore(argumentInterval.getValue().definition.getNumber() + 1);
            this.unhandled.add(split);
        }
        if (mode != ArgumentReuseMode.ALLOW_ARGUMENT_REUSE) {
            int moveExceptionRegister = Integer.MIN_VALUE;
            ArrayList<LiveIntervals> moveExceptionIntervals = new ArrayList<LiveIntervals>();
            boolean overlappingMoveExceptionIntervals = false;
            for (BasicBlock block : this.code.blocks) {
                for (Instruction instruction : block.getInstructions()) {
                    if (!instruction.isMoveException()) continue;
                    this.hasDedicatedMoveExceptionRegister = true;
                    Value exceptionValue = instruction.outValue();
                    LiveIntervals intervals = exceptionValue.getLiveIntervals();
                    this.unhandled.remove(intervals);
                    if (moveExceptionRegister == Integer.MIN_VALUE) {
                        moveExceptionRegister = this.getFreeConsecutiveRegisters(1);
                    }
                    intervals.setRegister(moveExceptionRegister);
                    if (!overlappingMoveExceptionIntervals) {
                        for (LiveIntervals other : moveExceptionIntervals) {
                            overlappingMoveExceptionIntervals |= other.overlaps(intervals);
                        }
                    }
                    moveExceptionIntervals.add(intervals);
                }
            }
            if (overlappingMoveExceptionIntervals) {
                for (LiveIntervals intervals : moveExceptionIntervals) {
                    if (intervals.getUses().size() <= 1) continue;
                    LiveIntervalsUse firstUse = intervals.getUses().pollFirst();
                    LiveIntervalsUse secondUse = intervals.getUses().pollFirst();
                    intervals.getUses().add(firstUse);
                    intervals.getUses().add(secondUse);
                    LiveIntervals split = intervals.splitBefore(secondUse.getPosition());
                    this.unhandled.add(split);
                }
            }
        }
        while (!this.unhandled.isEmpty()) {
            LiveIntervals unhandledInterval = this.unhandled.poll();
            this.setHintForDestRegOfCheckCast(unhandledInterval);
            this.setHintToPromote2AddrInstruction(unhandledInterval);
            this.allocateArgumentIntervalsWithSrc(unhandledInterval);
            if (unhandledInterval.getRegister() != Integer.MIN_VALUE) continue;
            int start = unhandledInterval.getStart();
            Iterator<LiveIntervals> activeIterator = this.active.iterator();
            while (activeIterator.hasNext()) {
                LiveIntervals activeIntervals = activeIterator.next();
                if (start >= activeIntervals.getEnd()) {
                    activeIterator.remove();
                    this.freeRegistersForIntervals(activeIntervals);
                    continue;
                }
                if (activeIntervals.overlapsPosition(start)) continue;
                activeIterator.remove();
                assert (activeIntervals.getRegister() != Integer.MIN_VALUE);
                this.inactive.add(activeIntervals);
                this.freeRegistersForIntervals(activeIntervals);
            }
            Iterator<LiveIntervals> inactiveIterator = this.inactive.iterator();
            while (inactiveIterator.hasNext()) {
                LiveIntervals inactiveIntervals = inactiveIterator.next();
                if (start >= inactiveIntervals.getEnd()) {
                    inactiveIterator.remove();
                    continue;
                }
                if (!inactiveIntervals.overlapsPosition(start)) continue;
                inactiveIterator.remove();
                assert (inactiveIntervals.getRegister() != Integer.MIN_VALUE);
                this.active.add(inactiveIntervals);
                this.takeRegistersForIntervals(inactiveIntervals);
            }
            if (unhandledInterval.isLinked() && !unhandledInterval.isArgumentInterval()) {
                this.allocateLinkedIntervals(unhandledInterval);
                continue;
            }
            if (this.allocateSingleInterval(unhandledInterval, mode)) continue;
            return false;
        }
        return true;
    }

    private void setHintForDestRegOfCheckCast(LiveIntervals unhandledInterval) {
        if (unhandledInterval.getHint() == null && unhandledInterval.getValue().definition instanceof CheckCast) {
            CheckCast checkcast = unhandledInterval.getValue().definition.asCheckCast();
            Value checkcastInput = checkcast.inValues().get(0);
            assert (checkcastInput != null);
            if (checkcastInput.getLiveIntervals() != null && !checkcastInput.getLiveIntervals().overlaps(unhandledInterval) && checkcastInput.getLocalInfo() == unhandledInterval.getValue().definition.getLocalInfo()) {
                unhandledInterval.setHint(checkcastInput.getLiveIntervals());
            }
        }
    }

    private void setHintToPromote2AddrInstruction(LiveIntervals unhandledInterval) {
        if (unhandledInterval.getHint() == null && unhandledInterval.getValue().definition instanceof ArithmeticBinop) {
            ArithmeticBinop binOp = unhandledInterval.getValue().definition.asArithmeticBinop();
            Value left = binOp.leftValue();
            assert (left != null);
            if (left.getLiveIntervals() != null && !left.getLiveIntervals().overlaps(unhandledInterval)) {
                unhandledInterval.setHint(left.getLiveIntervals());
            } else {
                Value right = binOp.rightValue();
                assert (right != null);
                if (binOp.isCommutative() && right.getLiveIntervals() != null && !right.getLiveIntervals().overlaps(unhandledInterval)) {
                    unhandledInterval.setHint(right.getLiveIntervals());
                }
            }
        }
    }

    private void allocateArgumentIntervalsWithSrc(LiveIntervals srcInterval) {
        Value value = srcInterval.getValue();
        for (Instruction instruction : value.uniqueUsers()) {
            Move move;
            Value dest;
            LiveIntervals destIntervals;
            if (!instruction.isMove() || !instruction.asMove().dest().isLinked() || (destIntervals = (dest = (move = instruction.asMove()).dest()).getLiveIntervals()).getRegister() != Integer.MIN_VALUE) continue;
            TreeSet<Integer> savedFreeRegisters = new TreeSet<Integer>((SortedSet<Integer>)this.freeRegisters);
            int savedUnusedRegisterNumber = this.nextUnusedRegisterNumber;
            LinkedList<LiveIntervals> savedActive = new LinkedList<LiveIntervals>(this.active);
            LinkedList<LiveIntervals> savedInactive = new LinkedList<LiveIntervals>(this.inactive);
            for (LiveIntervals active : this.active) {
                if (active.isArgumentInterval()) {
                    this.freeRegistersForIntervals(active);
                }
                this.inactive.add(active);
            }
            this.unhandled.remove(destIntervals);
            this.allocateLinkedIntervals(destIntervals);
            this.freeRegisters = savedFreeRegisters;
            for (int i = savedUnusedRegisterNumber; i < this.nextUnusedRegisterNumber; ++i) {
                this.freeRegisters.add(i);
            }
            this.active = savedActive;
            this.inactive = savedInactive;
            for (LiveIntervals current = destIntervals.getStartOfConsecutive(); current != null; current = current.getNextConsecutive()) {
                assert (!this.inactive.contains(current));
                assert (!this.active.contains(current));
                assert (!this.unhandled.contains(current));
                this.inactive.add(current);
            }
        }
    }

    private void allocateLinkedIntervals(LiveIntervals unhandledInterval) {
        LiveIntervals current;
        HashSet<Integer> excludedRegisters = new HashSet<Integer>();
        for (current = unhandledInterval.getStartOfConsecutive(); current != null; current = current.getNextConsecutive()) {
            for (LiveIntervals inactiveIntervals : this.inactive) {
                if (!inactiveIntervals.overlaps(current)) continue;
                this.excludeRegistersForInterval(inactiveIntervals, excludedRegisters);
            }
        }
        current = unhandledInterval.getStartOfConsecutive();
        int numberOfRegister = current.numberOfConsecutiveRegisters();
        int firstRegister = this.getFreeConsecutiveRegisters(numberOfRegister);
        for (int i = 0; i < numberOfRegister; ++i) {
            Value value;
            assert (current != null);
            current.setRegister(firstRegister + i);
            if (current.getType().isWide()) {
                assert (i < numberOfRegister);
                ++i;
            }
            if (!(value = current.getValue()).isPhi() && value.definition.isMove()) {
                Move move = value.definition.asMove();
                LiveIntervals intervals = move.src().getLiveIntervals();
                intervals.setHint(current);
            }
            if (current != unhandledInterval) {
                this.unhandled.remove(current);
                assert (current.getRegister() != Integer.MIN_VALUE);
                this.inactive.add(current);
                this.freeRegistersForIntervals(current);
            }
            current = current.getNextConsecutive();
        }
        assert (current == null);
        assert (unhandledInterval.getRegister() != Integer.MIN_VALUE);
        this.active.add(unhandledInterval);
        this.freeRegisters.addAll(excludedRegisters);
    }

    private void updateRegisterState(int register, boolean needsRegisterPair) {
        int maxRegister = register + (needsRegisterPair ? 1 : 0);
        if (maxRegister >= this.nextUnusedRegisterNumber) {
            this.nextUnusedRegisterNumber = maxRegister + 1;
        }
        this.maxRegisterNumber = Math.max(this.maxRegisterNumber, maxRegister);
    }

    private int getSpillRegister(LiveIntervals intervals) {
        int registerNumber;
        this.maxRegisterNumber = registerNumber = this.nextUnusedRegisterNumber++;
        if (intervals.getType().isWide()) {
            ++this.nextUnusedRegisterNumber;
            ++this.maxRegisterNumber;
        }
        return registerNumber;
    }

    private int toInstructionPosition(int position) {
        return position % 2 == 0 ? position : position + 1;
    }

    private int toGapPosition(int position) {
        return position % 2 == 1 ? position : position - 1;
    }

    private boolean needsArrayGetWideWorkaround(LiveIntervals intervals) {
        if (this.options.canUseSameArrayAndResultRegisterInArrayGetWide()) {
            return false;
        }
        if (intervals.requiredRegisters() == 1) {
            return false;
        }
        if (intervals.getValue().isPhi()) {
            return false;
        }
        if (intervals.getSplitParent() != intervals) {
            return false;
        }
        Instruction definition = intervals.getValue().definition;
        return definition.isArrayGet() && definition.asArrayGet().outType().isWide();
    }

    private boolean isArrayGetArrayRegister(LiveIntervals intervals, int register) {
        assert (this.needsArrayGetWideWorkaround(intervals));
        Value array = intervals.getValue().definition.asArrayGet().array();
        int arrayReg = array.getLiveIntervals().getSplitCovering(intervals.getStart()).getRegister();
        assert (arrayReg != Integer.MIN_VALUE);
        return arrayReg == register;
    }

    private boolean needsOverlappingLongRegisterWorkaround(LiveIntervals intervals) {
        if (intervals.requiredRegisters() == 1) {
            return false;
        }
        if (intervals.getValue().isPhi()) {
            return false;
        }
        if (intervals.getSplitParent() != intervals) {
            return false;
        }
        Instruction definition = intervals.getValue().definition;
        if (definition.isArithmeticBinop() && definition.asArithmeticBinop().getNumericType() == NumericType.LONG) {
            return definition instanceof Add || definition instanceof Sub;
        }
        if (definition.isLogicalBinop() && definition.asLogicalBinop().getNumericType() == NumericType.LONG) {
            return definition instanceof Or || definition instanceof Xor || definition instanceof And;
        }
        return false;
    }

    private boolean hasOverlappingLongRegisters(LiveIntervals unhandledInterval, int register) {
        assert (this.needsOverlappingLongRegisterWorkaround(unhandledInterval));
        Value left = unhandledInterval.getValue().definition.asBinop().leftValue();
        Value right = unhandledInterval.getValue().definition.asBinop().rightValue();
        int leftReg = left.getLiveIntervals().getSplitCovering(unhandledInterval.getStart()).getRegister();
        int rightReg = right.getLiveIntervals().getSplitCovering(unhandledInterval.getStart()).getRegister();
        assert (leftReg != Integer.MIN_VALUE && rightReg != Integer.MIN_VALUE);
        return leftReg + 1 == register || rightReg + 1 == register;
    }

    private boolean allocateSingleInterval(LiveIntervals unhandledInterval, ArgumentReuseMode mode) {
        int moveExceptionRegister;
        boolean needsRegisterPair;
        int registerConstraint = unhandledInterval.getRegisterLimit();
        assert (registerConstraint <= 65535);
        assert (unhandledInterval.requiredRegisters() <= 2);
        boolean bl = needsRegisterPair = unhandledInterval.requiredRegisters() == 2;
        if (registerConstraint == 65535 && unhandledInterval.isArgumentInterval()) {
            int argumentRegister = unhandledInterval.getSplitParent().getRegister();
            this.assignRegisterToUnhandledInterval(unhandledInterval, needsRegisterPair, argumentRegister);
            return true;
        }
        if (registerConstraint < 65535) {
            registerConstraint += 2;
            if (mode == ArgumentReuseMode.DISALLOW_ARGUMENT_REUSE) {
                registerConstraint += this.numberOfArgumentRegisters;
            }
        }
        RegisterPositions freePositions = new RegisterPositions(registerConstraint + 1);
        if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE) {
            int lastSentinelRegister;
            freePositions.set(0, 0);
            if (this.options.debug && !this.code.method.accessFlags.isStatic()) {
                assert (this.numberOfArgumentRegisters > 0);
                assert (this.preArgumentSentinelValue.getNextConsecutive().requiredRegisters() == 1);
                freePositions.set(1, 0);
            }
            if ((lastSentinelRegister = this.numberOfArgumentRegisters + 2 - 1) <= registerConstraint) {
                freePositions.set(lastSentinelRegister, 0);
            }
        } else {
            for (int i = 0; i < this.numberOfArgumentRegisters + 2; ++i) {
                if (i > registerConstraint) continue;
                freePositions.set(i, 0);
            }
        }
        if (this.hasDedicatedMoveExceptionRegister && (moveExceptionRegister = this.numberOfArgumentRegisters + 2) <= registerConstraint) {
            freePositions.set(moveExceptionRegister, 0);
        }
        for (LiveIntervals intervals : this.active) {
            int activeRegister = intervals.getRegister();
            if (activeRegister > registerConstraint) continue;
            for (int i = 0; i < intervals.requiredRegisters(); ++i) {
                if (activeRegister + i > registerConstraint) continue;
                freePositions.set(activeRegister + i, 0);
            }
        }
        for (LiveIntervals intervals : this.inactive) {
            int inactiveRegister = intervals.getRegister();
            if (inactiveRegister > registerConstraint || !unhandledInterval.overlaps(intervals)) continue;
            int nextOverlap = unhandledInterval.nextOverlap(intervals);
            for (int i = 0; i < intervals.requiredRegisters(); ++i) {
                int register = inactiveRegister + i;
                if (register > registerConstraint) continue;
                int unhandledStart = this.toInstructionPosition(unhandledInterval.getStart());
                if (nextOverlap == unhandledStart) {
                    freePositions.set(register, 0);
                    continue;
                }
                if (nextOverlap >= freePositions.get(register)) continue;
                freePositions.set(register, nextOverlap, intervals);
            }
        }
        if (this.useRegisterHint(unhandledInterval, registerConstraint, freePositions, needsRegisterPair)) {
            return true;
        }
        int candidate = this.getLargestValidCandidate(unhandledInterval, registerConstraint, needsRegisterPair, freePositions, RegisterPositions.Type.ANY);
        assert (candidate != -1);
        int largestFreePosition = freePositions.get(candidate);
        if (needsRegisterPair) {
            largestFreePosition = Math.min(largestFreePosition, freePositions.get(candidate + 1));
        }
        if (largestFreePosition == 0) {
            if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE) {
                return false;
            }
            if (!unhandledInterval.getUses().first().hasConstraint()) {
                int nextConstrainedPosition = unhandledInterval.firstUseWithConstraint().getPosition();
                int register = unhandledInterval.isArgumentInterval() ? unhandledInterval.getSplitParent().getRegister() : this.getSpillRegister(unhandledInterval);
                LiveIntervals split = unhandledInterval.splitBefore(nextConstrainedPosition);
                this.assignRegisterToUnhandledInterval(unhandledInterval, needsRegisterPair, register);
                this.unhandled.add(split);
            } else {
                this.allocateBlockedRegister(unhandledInterval);
            }
        } else if (largestFreePosition >= unhandledInterval.getEnd()) {
            this.assignRegisterToUnhandledInterval(unhandledInterval, needsRegisterPair, candidate);
        } else {
            if (mode == ArgumentReuseMode.ALLOW_ARGUMENT_REUSE) {
                return false;
            }
            LiveIntervals split = unhandledInterval.splitBefore(largestFreePosition);
            assert (split != unhandledInterval);
            this.assignRegisterToUnhandledInterval(unhandledInterval, needsRegisterPair, candidate);
            this.unhandled.add(split);
        }
        return true;
    }

    private boolean useRegisterHint(LiveIntervals unhandledInterval, int registerConstraint, RegisterPositions freePositions, boolean needsRegisterPair) {
        int register;
        LiveIntervals hint = unhandledInterval.getHint();
        if (hint != null && this.tryHint(unhandledInterval, registerConstraint, freePositions, needsRegisterPair, register = hint.getRegister())) {
            return true;
        }
        Value value = unhandledInterval.getValue();
        if (value.isPhi()) {
            Phi phi = value.asPhi();
            HashMultiset<Integer> map = HashMultiset.create();
            List<Value> operands = phi.getOperands();
            for (int i = 0; i < operands.size(); ++i) {
                int operandRegister;
                LiveIntervals intervals = operands.get(i).getLiveIntervals();
                if (intervals.hasSplits()) {
                    BasicBlock pred = phi.getBlock().getPredecessors().get(i);
                    intervals = intervals.getSplitCovering(pred.exit().getNumber());
                }
                if ((operandRegister = intervals.getRegister()) == Integer.MIN_VALUE) continue;
                map.add(operandRegister);
            }
            for (Multiset.Entry entry : Multisets.copyHighestCountFirst(map).entrySet()) {
                int register2 = (Integer)entry.getElement();
                if (!this.tryHint(unhandledInterval, registerConstraint, freePositions, needsRegisterPair, register2)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryHint(LiveIntervals unhandledInterval, int registerConstraint, RegisterPositions freePositions, boolean needsRegisterPair, int register) {
        if (register == Integer.MIN_VALUE) {
            return false;
        }
        if (register + (needsRegisterPair ? 1 : 0) <= registerConstraint) {
            int freePosition = freePositions.get(register);
            if (needsRegisterPair) {
                freePosition = Math.min(freePosition, freePositions.get(register + 1));
            }
            if (freePosition >= unhandledInterval.getEnd()) {
                if (this.needsOverlappingLongRegisterWorkaround(unhandledInterval) && this.hasOverlappingLongRegisters(unhandledInterval, register)) {
                    return false;
                }
                if (this.needsArrayGetWideWorkaround(unhandledInterval) && this.isArrayGetArrayRegister(unhandledInterval, register)) {
                    return false;
                }
                this.assignRegisterToUnhandledInterval(unhandledInterval, needsRegisterPair, register);
                return true;
            }
        }
        return false;
    }

    private void assignRegister(LiveIntervals intervals, int register) {
        intervals.setRegister(register);
        this.updateRegisterHints(intervals);
    }

    private void updateRegisterHints(LiveIntervals intervals) {
        LiveIntervals operandIntervals;
        Value value = intervals.getValue();
        for (Phi phi : value.uniquePhiUsers()) {
            LiveIntervals phiIntervals = phi.getLiveIntervals();
            if (phiIntervals.getHint() != null) continue;
            for (int i = 0; i < phi.getOperands().size(); ++i) {
                Value operand = phi.getOperand(i);
                operandIntervals = operand.getLiveIntervals();
                BasicBlock pred = phi.getBlock().getPredecessors().get(i);
                if ((operandIntervals = operandIntervals.getSplitCovering(pred.exit().getNumber())).getHint() != null) continue;
                operandIntervals.setHint(intervals);
            }
        }
        if (value.isPhi() && intervals.getSplitParent() == intervals) {
            Phi phi = value.asPhi();
            BasicBlock block = phi.getBlock();
            for (int i = 0; i < phi.getOperands().size(); ++i) {
                Value operand = phi.getOperand(i);
                BasicBlock pred = block.getPredecessors().get(i);
                operandIntervals = operand.getLiveIntervals().getSplitCovering(pred.exit().getNumber());
                operandIntervals.setHint(intervals);
            }
        }
    }

    private void assignRegisterToUnhandledInterval(LiveIntervals unhandledInterval, boolean needsRegisterPair, int register) {
        this.assignRegister(unhandledInterval, register);
        this.takeRegistersForIntervals(unhandledInterval);
        this.updateRegisterState(register, needsRegisterPair);
        this.active.add(unhandledInterval);
    }

    private int getLargestCandidate(int registerConstraint, RegisterPositions freePositions, boolean needsRegisterPair, RegisterPositions.Type type) {
        int candidate = -1;
        int largest = -1;
        for (int i = 0; i <= registerConstraint; ++i) {
            if (!freePositions.hasType(i, type)) continue;
            int freePosition = freePositions.get(i);
            if (needsRegisterPair) {
                if (i >= registerConstraint) break;
                freePosition = Math.min(freePosition, freePositions.get(i + 1));
            }
            if (freePosition <= largest) continue;
            candidate = i;
            largest = freePosition;
            if (largest == Integer.MAX_VALUE) break;
        }
        return candidate;
    }

    private int getLargestValidCandidate(LiveIntervals unhandledInterval, int registerConstraint, boolean needsRegisterPair, RegisterPositions freePositions, RegisterPositions.Type type) {
        int lastCandidate;
        int candidate = this.getLargestCandidate(registerConstraint, freePositions, needsRegisterPair, type);
        if (candidate == -1) {
            return candidate;
        }
        if (this.needsOverlappingLongRegisterWorkaround(unhandledInterval)) {
            lastCandidate = candidate;
            while (this.hasOverlappingLongRegisters(unhandledInterval, candidate)) {
                freePositions.set(candidate, 0);
                candidate = this.getLargestCandidate(registerConstraint, freePositions, needsRegisterPair, type);
                if (lastCandidate == candidate) {
                    return -1;
                }
                lastCandidate = candidate;
            }
        }
        if (this.needsArrayGetWideWorkaround(unhandledInterval)) {
            lastCandidate = candidate;
            while (this.isArrayGetArrayRegister(unhandledInterval, candidate)) {
                freePositions.set(candidate, 0);
                candidate = this.getLargestCandidate(registerConstraint, freePositions, needsRegisterPair, type);
                if (lastCandidate == candidate) {
                    return -1;
                }
                lastCandidate = candidate;
            }
        }
        return candidate;
    }

    private void allocateBlockedRegister(LiveIntervals unhandledInterval) {
        int i;
        int registerConstraint = unhandledInterval.getRegisterLimit();
        if (registerConstraint < 65535) {
            registerConstraint += this.numberOfArgumentRegisters;
            registerConstraint += 2;
        }
        RegisterPositions usePositions = new RegisterPositions(registerConstraint + 1);
        RegisterPositions blockedPositions = new RegisterPositions(registerConstraint + 1);
        for (LiveIntervals intervals : this.active) {
            int activeRegister = intervals.getRegister();
            if (activeRegister > registerConstraint) continue;
            for (i = 0; i < intervals.requiredRegisters(); ++i) {
                if (activeRegister + i > registerConstraint) continue;
                int unhandledStart = unhandledInterval.getStart();
                usePositions.set(activeRegister + i, intervals.firstUseAfter(unhandledStart), intervals);
            }
        }
        for (LiveIntervals intervals : this.inactive) {
            int inactiveRegister = intervals.getRegister();
            if (inactiveRegister > registerConstraint || !intervals.overlaps(unhandledInterval)) continue;
            for (i = 0; i < intervals.requiredRegisters(); ++i) {
                int firstUse;
                if (inactiveRegister + i > registerConstraint || (firstUse = intervals.firstUseAfter(unhandledInterval.getStart())) >= usePositions.get(inactiveRegister + i)) continue;
                usePositions.set(inactiveRegister + i, firstUse, intervals);
            }
        }
        for (int i2 = 0; i2 < this.numberOfArgumentRegisters + 2; ++i2) {
            usePositions.set(i2, 0);
        }
        if (this.hasDedicatedMoveExceptionRegister) {
            usePositions.set(this.numberOfArgumentRegisters + 2, 0);
        }
        this.blockLinkedRegisters(this.active, unhandledInterval, registerConstraint, usePositions, blockedPositions);
        this.blockLinkedRegisters(this.inactive, unhandledInterval, registerConstraint, usePositions, blockedPositions);
        boolean needsRegisterPair = unhandledInterval.requiredRegisters() == 2;
        int candidate = this.getLargestValidCandidate(unhandledInterval, registerConstraint, needsRegisterPair, usePositions, RegisterPositions.Type.CONST_NUMBER);
        if (candidate != Integer.MAX_VALUE) {
            int otherCandidate = this.getLargestValidCandidate(unhandledInterval, registerConstraint, needsRegisterPair, usePositions, RegisterPositions.Type.OTHER);
            if (otherCandidate == Integer.MAX_VALUE || candidate == -1) {
                candidate = otherCandidate;
            } else {
                int largestConstUsePosition = this.getLargestPosition(usePositions, candidate, needsRegisterPair);
                if (largestConstUsePosition - 5 < unhandledInterval.getStart()) {
                    candidate = otherCandidate;
                }
            }
            if (candidate == -1) {
                candidate = this.getLargestValidCandidate(unhandledInterval, registerConstraint, needsRegisterPair, usePositions, RegisterPositions.Type.MONITOR);
            }
        }
        int largestUsePosition = this.getLargestPosition(usePositions, candidate, needsRegisterPair);
        int blockedPosition = this.getBlockedPosition(blockedPositions, candidate, needsRegisterPair);
        if (largestUsePosition < unhandledInterval.getFirstUse()) {
            int splitPosition = unhandledInterval.getFirstUse();
            LiveIntervals split = unhandledInterval.splitBefore(splitPosition);
            assert (split != unhandledInterval);
            int registerNumber = this.getSpillRegister(unhandledInterval);
            this.assignRegisterToUnhandledInterval(unhandledInterval, needsRegisterPair, registerNumber);
            unhandledInterval.setSpilled(true);
            this.unhandled.add(split);
        } else if (blockedPosition > unhandledInterval.getEnd()) {
            this.assignRegisterAndSpill(unhandledInterval, needsRegisterPair, candidate);
        } else {
            LiveIntervals splitChild = unhandledInterval.splitBefore(blockedPosition);
            this.unhandled.add(splitChild);
            this.assignRegisterAndSpill(unhandledInterval, needsRegisterPair, candidate);
        }
    }

    private int getLargestPosition(RegisterPositions usePositions, int register, boolean needsRegisterPair) {
        int largestUsePosition = usePositions.get(register);
        if (needsRegisterPair) {
            largestUsePosition = Math.min(largestUsePosition, usePositions.get(register + 1));
        }
        return largestUsePosition;
    }

    private int getBlockedPosition(RegisterPositions blockedPositions, int register, boolean needsRegisterPair) {
        int blockedPosition = blockedPositions.get(register);
        if (needsRegisterPair) {
            blockedPosition = Math.min(blockedPosition, blockedPositions.get(register + 1));
        }
        return blockedPosition;
    }

    private void assignRegisterAndSpill(LiveIntervals unhandledInterval, boolean needsRegisterPair, int candidate) {
        this.assignRegister(unhandledInterval, candidate);
        this.updateRegisterState(candidate, needsRegisterPair);
        this.spillOverlappingActiveIntervals(unhandledInterval, needsRegisterPair, candidate);
        this.takeRegistersForIntervals(unhandledInterval);
        this.active.add(unhandledInterval);
        this.splitOverlappingInactiveIntervals(unhandledInterval, needsRegisterPair, candidate);
    }

    protected void splitOverlappingInactiveIntervals(LiveIntervals unhandledInterval, boolean needsRegisterPair, int candidate) {
        ArrayList<LiveIntervals> newInactive = new ArrayList<LiveIntervals>();
        Iterator<LiveIntervals> inactiveIterator = this.inactive.iterator();
        while (inactiveIterator.hasNext()) {
            int nextUsePosition;
            LiveIntervals intervals = inactiveIterator.next();
            if (!intervals.usesRegister(candidate) && (!needsRegisterPair || !intervals.usesRegister(candidate + 1)) || !intervals.overlaps(unhandledInterval)) continue;
            if (intervals.isLinked() && !intervals.isArgumentInterval() && (nextUsePosition = intervals.firstUseAfter(unhandledInterval.getStart())) != Integer.MAX_VALUE) {
                LiveIntervals split = intervals.splitBefore(nextUsePosition);
                split.setRegister(intervals.getRegister());
                newInactive.add(split);
            }
            if (intervals.getStart() > unhandledInterval.getStart()) {
                intervals.clearRegisterAssignment();
                inactiveIterator.remove();
                this.unhandled.add(intervals);
                continue;
            }
            LiveIntervals split = intervals.splitBefore(unhandledInterval.getStart());
            this.unhandled.add(split);
        }
        this.inactive.addAll(newInactive);
    }

    private void spillOverlappingActiveIntervals(LiveIntervals unhandledInterval, boolean needsRegisterPair, int candidate) {
        ArrayList<LiveIntervals> newActive = new ArrayList<LiveIntervals>();
        Iterator<LiveIntervals> activeIterator = this.active.iterator();
        while (activeIterator.hasNext()) {
            LiveIntervals intervals = activeIterator.next();
            if (!intervals.usesRegister(candidate) && (!needsRegisterPair || !intervals.usesRegister(candidate + 1))) continue;
            activeIterator.remove();
            this.freeRegistersForIntervals(intervals);
            LiveIntervals splitChild = intervals.splitBefore(unhandledInterval.getStart());
            int registerNumber = this.getSpillRegister(intervals);
            this.assignRegister(splitChild, registerNumber);
            splitChild.setSpilled(true);
            this.takeRegistersForIntervals(splitChild);
            assert (splitChild.getRegister() != Integer.MIN_VALUE);
            assert (intervals.getRegister() != Integer.MIN_VALUE);
            newActive.add(splitChild);
            if (intervals.getValue().isConstNumber() && intervals.getStart() == intervals.getValue().definition.getNumber() && intervals.getUses().size() == 1) {
                intervals.setSpilled(true);
            }
            if (splitChild.getUses().size() <= 0) continue;
            if (splitChild.isLinked() && !splitChild.isArgumentInterval()) {
                LiveIntervals splitOfSplit = splitChild.splitBefore(splitChild.getFirstUse());
                splitOfSplit.setRegister(intervals.getRegister());
                this.inactive.add(splitOfSplit);
                continue;
            }
            if (intervals.getValue().isConstNumber()) {
                this.splitRangesForSpilledConstant(splitChild, registerNumber);
                continue;
            }
            if (intervals.isArgumentInterval()) {
                this.splitRangesForSpilledArgument(splitChild);
                continue;
            }
            this.splitRangesForSpilledInterval(splitChild, registerNumber);
        }
        this.active.addAll(newActive);
    }

    private void splitRangesForSpilledArgument(LiveIntervals spilled) {
        assert (spilled.isSpilled());
        assert (spilled.isArgumentInterval());
        if (!spilled.getUses().isEmpty()) {
            LiveIntervals split = spilled.splitBefore(spilled.getUses().first().getPosition());
            this.unhandled.add(split);
        }
    }

    private void splitRangesForSpilledInterval(LiveIntervals spilled, int registerNumber) {
        assert (spilled.isSpilled());
        assert (!spilled.getValue().isConstNumber());
        assert (!spilled.isLinked() || spilled.isArgumentInterval());
        if (spilled.isArgumentInterval()) {
            registerNumber = 65535;
        }
        LiveIntervalsUse firstUseWithLowerLimit = null;
        boolean hasUsesBeforeFirstUseWithLowerLimit = false;
        for (LiveIntervalsUse use : spilled.getUses()) {
            if (registerNumber > use.getLimit()) {
                firstUseWithLowerLimit = use;
                break;
            }
            hasUsesBeforeFirstUseWithLowerLimit = true;
        }
        if (hasUsesBeforeFirstUseWithLowerLimit) {
            spilled.setSpilled(false);
        }
        if (firstUseWithLowerLimit != null) {
            LiveIntervals splitOfSplit = spilled.splitBefore(firstUseWithLowerLimit.getPosition());
            this.unhandled.add(splitOfSplit);
        }
    }

    private void splitRangesForSpilledConstant(LiveIntervals spilled, int spillRegister) {
        assert (spilled.isSpilled());
        assert (spilled.getValue().isConstNumber());
        assert (!spilled.isLinked() || spilled.isArgumentInterval());
        int maxGapSize = 22;
        if (!spilled.getUses().isEmpty()) {
            LiveIntervals split = spilled.splitBefore(spilled.getFirstUse());
            this.unhandled.add(split);
            boolean changed = true;
            block0: while (changed) {
                changed = false;
                int previousUse = split.getStart();
                for (LiveIntervalsUse use : split.getUses()) {
                    if (use.getPosition() - previousUse > maxGapSize) {
                        split = split.splitBefore(previousUse + 2);
                        if (this.toGapPosition(use.getPosition()) > split.getStart()) {
                            this.assignRegister(split, spillRegister);
                            split.setSpilled(true);
                            this.inactive.add(split);
                            split = split.splitBefore(use.getPosition());
                        }
                        this.unhandled.add(split);
                        changed = true;
                        continue block0;
                    }
                    previousUse = use.getPosition();
                }
            }
        }
    }

    private void blockLinkedRegisters(List<LiveIntervals> intervalsList, LiveIntervals interval, int registerConstraint, RegisterPositions usePositions, RegisterPositions blockedPositions) {
        for (LiveIntervals other : intervalsList) {
            int register;
            if (!other.isLinked() || (register = other.getRegister()) > registerConstraint || !other.overlaps(interval)) continue;
            for (int i = 0; i < other.requiredRegisters(); ++i) {
                int firstUse;
                if (register + i > registerConstraint || (firstUse = other.firstUseAfter(interval.getStart())) >= blockedPositions.get(register + i)) continue;
                blockedPositions.set(register + i, firstUse, other);
                assert (usePositions.get(register + i) <= blockedPositions.get(register + i));
            }
        }
    }

    private void insertMoves() {
        SpillMoveSet spillMoves = new SpillMoveSet(this, this.code, this.numberOfArgumentRegisters + 2);
        for (LiveIntervals intervals : this.liveIntervals) {
            if (!intervals.hasSplits()) continue;
            LiveIntervals current = intervals;
            PriorityQueue<LiveIntervals> sortedChildren = new PriorityQueue<LiveIntervals>();
            sortedChildren.addAll(current.getSplitChildren());
            LiveIntervals split = (LiveIntervals)sortedChildren.poll();
            while (split != null) {
                int position = split.getStart();
                spillMoves.addSpillOrRestoreMove(this.toGapPosition(position), split, current);
                current = split;
                split = (LiveIntervals)sortedChildren.poll();
            }
        }
        this.resolveControlFlow(spillMoves);
        this.firstParallelMoveTemporary = this.maxRegisterNumber + 1;
        this.maxRegisterNumber += spillMoves.scheduleAndInsertMoves(this.maxRegisterNumber + 1);
    }

    private void resolveControlFlow(SpillMoveSet spillMoves) {
        for (BasicBlock block : this.code.blocks) {
            for (BasicBlock successor : block.getSuccessors()) {
                int fromInstruction = block.exit().getNumber();
                boolean isCatch = block.hasCatchSuccessor(successor);
                if (isCatch) {
                    for (Instruction instruction : block.getInstructions()) {
                        if (!instruction.instructionTypeCanThrow()) continue;
                        fromInstruction = instruction.getNumber();
                        break;
                    }
                }
                int toInstruction = successor.entry().getNumber();
                Set<Value> liveAtEntry = this.liveAtEntrySets.get(successor);
                for (Value value : liveAtEntry) {
                    LiveIntervals toIntervals;
                    LiveIntervals parentInterval = value.getLiveIntervals();
                    LiveIntervals fromIntervals = parentInterval.getSplitCovering(fromInstruction);
                    if (fromIntervals == (toIntervals = parentInterval.getSplitCovering(toInstruction))) continue;
                    if (block.exit().isGoto() && !isCatch) {
                        spillMoves.addOutResolutionMove(fromInstruction - 1, toIntervals, fromIntervals);
                        continue;
                    }
                    if (successor.entry().isMoveException()) {
                        spillMoves.addInResolutionMove(toInstruction + 1, toIntervals, fromIntervals);
                        continue;
                    }
                    spillMoves.addInResolutionMove(toInstruction - 1, toIntervals, fromIntervals);
                }
                int predIndex = successor.getPredecessors().indexOf(block);
                for (Phi phi : successor.getPhis()) {
                    LiveIntervals toIntervals = phi.getLiveIntervals().getSplitCovering(toInstruction);
                    Value operand = phi.getOperand(predIndex);
                    LiveIntervals fromIntervals = operand.getLiveIntervals().getSplitCovering(fromInstruction);
                    if (fromIntervals == toIntervals || toIntervals.isArgumentInterval()) continue;
                    assert (block.getSuccessors().size() == 1);
                    spillMoves.addPhiMove(fromInstruction - 1, toIntervals, fromIntervals);
                }
            }
        }
    }

    private static void addLiveRange(Value value, BasicBlock block, int end, List<LiveIntervals> liveIntervals, InternalOptions options) {
        int instructionNumber;
        int firstInstructionInBlock = block.entry().getNumber();
        int instructionsSize = block.getInstructions().size() * 2;
        int lastInstructionInBlock = firstInstructionInBlock + instructionsSize - 2;
        if (value.isPhi()) {
            instructionNumber = firstInstructionInBlock;
        } else {
            Instruction instruction = value.definition;
            instructionNumber = instruction.getNumber();
        }
        if (value.getLiveIntervals() == null) {
            Value current = value.getStartOfConsecutive();
            LiveIntervals intervals = new LiveIntervals(current);
            while (true) {
                liveIntervals.add(intervals);
                Value next = current.getNextConsecutive();
                if (next == null) break;
                LiveIntervals nextIntervals = new LiveIntervals(next);
                intervals.link(nextIntervals);
                current = next;
                intervals = nextIntervals;
            }
        }
        LiveIntervals intervals = value.getLiveIntervals();
        if (firstInstructionInBlock <= instructionNumber && instructionNumber <= lastInstructionInBlock) {
            if (value.isPhi()) {
                --instructionNumber;
            }
            intervals.addRange(new LiveRange(instructionNumber, end));
            assert (LinearScanRegisterAllocator.unconstrainedForCf(intervals.getRegisterLimit(), options));
            if (!options.outputClassFiles && !value.isPhi()) {
                int constraint = value.definition.maxOutValueRegister();
                intervals.addUse(new LiveIntervalsUse(instructionNumber, constraint));
            }
        } else {
            intervals.addRange(new LiveRange(firstInstructionInBlock - 1, end));
        }
    }

    private void computeLiveRanges() {
        LinearScanRegisterAllocator.computeLiveRanges(this.options, this.code, this.liveAtEntrySets, this.liveIntervals);
    }

    public static void computeLiveRanges(InternalOptions options, IRCode code, Map<BasicBlock, Set<Value>> liveAtEntrySets, List<LiveIntervals> liveIntervals) {
        for (BasicBlock block : code.topologicallySortedBlocks()) {
            HashSet live = new HashSet();
            List<BasicBlock> successors = block.getSuccessors();
            HashSet<Value> phiOperands = new HashSet<Value>();
            for (BasicBlock basicBlock : successors) {
                live.addAll(liveAtEntrySets.get(basicBlock));
                for (Phi phi : basicBlock.getPhis()) {
                    live.remove(phi);
                    phiOperands.add(phi.getOperand(basicBlock.getPredecessors().indexOf(block)));
                    assert (phi.getDebugValues().stream().allMatch(Value::needsRegister));
                    phiOperands.addAll(phi.getDebugValues());
                }
            }
            live.addAll(phiOperands);
            LinkedList<Instruction> instructions = block.getInstructions();
            for (Value value : live) {
                int end = block.entry().getNumber() + instructions.size() * 2;
                if (phiOperands.contains(value)) {
                    --end;
                }
                LinearScanRegisterAllocator.addLiveRange(value, block, end, liveIntervals, options);
            }
            ListIterator<Instruction> listIterator = block.getInstructions().listIterator(block.getInstructions().size());
            while (listIterator.hasPrevious()) {
                Instruction instruction = listIterator.previous();
                Value definition = instruction.outValue();
                if (definition != null) {
                    if (!definition.isUsed()) {
                        LinearScanRegisterAllocator.addLiveRange(definition, block, instruction.getNumber() + 2, liveIntervals, options);
                        assert (!options.outputClassFiles || instruction.isArgument()) : "Arguments should be the only potentially unused local in CF";
                    }
                    live.remove(definition);
                }
                for (Value use : instruction.inValues()) {
                    if (!use.needsRegister()) continue;
                    assert (LinearScanRegisterAllocator.unconstrainedForCf(instruction.maxInValueRegister(), options));
                    if (!live.contains(use)) {
                        live.add(use);
                        LinearScanRegisterAllocator.addLiveRange(use, block, instruction.getNumber(), liveIntervals, options);
                    }
                    if (options.outputClassFiles) continue;
                    int inConstraint = instruction.maxInValueRegister();
                    LiveIntervals useIntervals = use.getLiveIntervals();
                    useIntervals.addUse(new LiveIntervalsUse(instruction.getNumber(), inConstraint));
                }
                if (!options.debug) continue;
                int number = instruction.getNumber();
                for (Value use : instruction.getDebugValues()) {
                    assert (use.needsRegister());
                    if (live.contains(use)) continue;
                    live.add(use);
                    LinearScanRegisterAllocator.addLiveRange(use, block, number, liveIntervals, options);
                }
            }
        }
    }

    private static boolean unconstrainedForCf(int constraint, InternalOptions options) {
        return !options.outputClassFiles || constraint == 65535;
    }

    private void clearUserInfo() {
        this.code.blocks.forEach(BasicBlock::clearUserInfo);
    }

    private Value createValue(ValueType type) {
        Value value = this.code.createValue(type, null);
        value.setNeedsRegister(true);
        return value;
    }

    private void replaceArgument(Invoke invoke, int index, Value newArgument) {
        Value argument = invoke.arguments().get(index);
        invoke.arguments().set(index, newArgument);
        argument.removeUser(invoke);
        newArgument.addUser(invoke);
    }

    private void generateArgumentMoves(Invoke invoke, InstructionListIterator insertAt) {
        if (invoke.requiredArgumentRegisters() > 5 && !this.argumentsAreAlreadyLinked(invoke)) {
            List<Value> arguments = invoke.arguments();
            Value previous = null;
            for (int i = 0; i < arguments.size(); ++i) {
                Value argument;
                Value newArgument = argument = arguments.get(i);
                if (argument.definition == null || !argument.definition.isMove() || argument.isLinked() || argument == previous || argument.hasRegisterConstraint()) {
                    newArgument = this.createValue(argument.outType());
                    Move move = new Move(newArgument, argument);
                    move.setBlock(invoke.getBlock());
                    move.setPosition(invoke.getPosition());
                    this.replaceArgument(invoke, i, newArgument);
                    insertAt.add(move);
                }
                if (previous != null) {
                    previous.linkTo(newArgument);
                }
                previous = newArgument;
            }
        }
    }

    private boolean argumentsAreAlreadyLinked(Invoke invoke) {
        Iterator<Value> it = invoke.arguments().iterator();
        Value current = it.next();
        while (it.hasNext()) {
            Value next = it.next();
            if (!current.isLinked() || current.getNextConsecutive() != next) {
                return false;
            }
            current = next;
        }
        return true;
    }

    private Value createSentinelRegisterValue() {
        return this.createValue(ValueType.OBJECT);
    }

    private LiveIntervals createSentinelLiveInterval(Value sentinelValue) {
        LiveIntervals sentinelInterval = new LiveIntervals(sentinelValue);
        sentinelInterval.addRange(LiveRange.INFINITE);
        this.liveIntervals.add(sentinelInterval);
        return sentinelInterval;
    }

    private void linkArgumentValues() {
        Value current = this.preArgumentSentinelValue = this.createSentinelRegisterValue();
        for (Value argument : this.code.collectArguments()) {
            current.linkTo(argument);
            current = argument;
        }
        Value endSentinel = this.createSentinelRegisterValue();
        current.linkTo(endSentinel);
    }

    private void setupArgumentLiveIntervals() {
        Value current = this.preArgumentSentinelValue;
        LiveIntervals currentIntervals = this.createSentinelLiveInterval(current);
        current = current.getNextConsecutive();
        int index = 0;
        while (current.getNextConsecutive() != null) {
            LiveIntervals argumentInterval = new LiveIntervals(current);
            argumentInterval.addRange(new LiveRange(0, index * 2));
            ++index;
            this.liveIntervals.add(argumentInterval);
            currentIntervals.link(argumentInterval);
            currentIntervals = argumentInterval;
            current = current.getNextConsecutive();
        }
        currentIntervals.link(this.createSentinelLiveInterval(current));
    }

    private void insertArgumentMoves() {
        this.linkArgumentValues();
        this.setupArgumentLiveIntervals();
        for (BasicBlock block : this.code.blocks) {
            InstructionListIterator it = block.listIterator();
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isInvoke()) continue;
                it.previous();
                this.generateArgumentMoves(instruction.asInvoke(), it);
                it.next();
            }
        }
    }

    private void computeNeedsRegister() {
        for (BasicBlock block : this.code.topologicallySortedBlocks()) {
            for (Instruction instruction : block.getInstructions()) {
                if (instruction.outValue() == null) continue;
                instruction.outValue().computeNeedsRegister();
            }
        }
    }

    private void pinArgumentRegisters() {
        int register = 0;
        for (Value current = this.preArgumentSentinelValue; current != null; current = current.getNextConsecutive()) {
            LiveIntervals argumentLiveInterval = current.getLiveIntervals();
            register = this.getFreeConsecutiveRegisters(argumentLiveInterval.requiredRegisters());
            this.assignRegister(argumentLiveInterval, register);
        }
        assert (register == this.numberOfArgumentRegisters + 2 - 1);
    }

    private int getFreeConsecutiveRegisters(int numberOfRegister) {
        int first;
        ArrayList<Integer> unused = new ArrayList<Integer>();
        int current = first = this.getNextFreeRegister();
        block0: while (current - first + 1 != numberOfRegister) {
            for (int i = 0; i < numberOfRegister - 1; ++i) {
                int next = this.getNextFreeRegister();
                if (next != current + 1) {
                    for (int j = first; j <= current; ++j) {
                        unused.add(j);
                    }
                    current = first = next;
                    continue block0;
                }
                ++current;
            }
        }
        this.freeRegisters.addAll(unused);
        this.maxRegisterNumber = Math.max(this.maxRegisterNumber, first + numberOfRegister - 1);
        return first;
    }

    private int getNextFreeRegister() {
        if (this.freeRegisters.size() > 0) {
            return this.freeRegisters.pollFirst();
        }
        return this.nextUnusedRegisterNumber++;
    }

    private void excludeRegistersForInterval(LiveIntervals intervals, Set<Integer> excluded) {
        int register = intervals.getRegister();
        for (int i = 0; i < intervals.requiredRegisters(); ++i) {
            if (!this.freeRegisters.remove(register + i)) continue;
            excluded.add(register + i);
        }
    }

    private void freeRegistersForIntervals(LiveIntervals intervals) {
        int register = intervals.getRegister();
        this.freeRegisters.add(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.add(register + 1);
        }
    }

    private void takeRegistersForIntervals(LiveIntervals intervals) {
        int register = intervals.getRegister();
        this.freeRegisters.remove(register);
        if (intervals.getType().isWide()) {
            this.freeRegisters.remove(register + 1);
        }
    }

    private boolean noLinkedValues() {
        for (BasicBlock block : this.code.blocks) {
            for (Phi phi : block.getPhis()) {
                assert (phi.getNextConsecutive() == null);
            }
            for (Instruction instruction : block.getInstructions()) {
                for (Value value : instruction.inValues()) {
                    assert (value.getNextConsecutive() == null);
                }
                assert (instruction.outValue() == null || instruction.outValue().getNextConsecutive() == null);
            }
        }
        return true;
    }

    public String toString() {
        Value value;
        StringBuilder builder = new StringBuilder("Live ranges:\n");
        for (LiveIntervals intervals : this.liveIntervals) {
            value = intervals.getValue();
            builder.append(value);
            builder.append(" ");
            builder.append(intervals);
        }
        builder.append("\nLive range ascii art: \n");
        for (LiveIntervals intervals : this.liveIntervals) {
            value = intervals.getValue();
            if (intervals.getRegister() == Integer.MIN_VALUE) {
                StringUtils.appendRightPadded(builder, value + " (no reg): ", 20);
            } else {
                StringUtils.appendRightPadded(builder, value + " r" + intervals.getRegister() + ": ", 20);
            }
            builder.append("|");
            builder.append(intervals.toAscciArtString());
            builder.append("\n");
        }
        return builder.toString();
    }

    private static class LocalRange
    implements Comparable<LocalRange> {
        final Value value;
        final DebugLocalInfo local;
        final int register;
        final int start;
        final int end;

        LocalRange(Value value, int register, int start, int end) {
            assert (value.hasLocalInfo());
            this.value = value;
            this.local = value.getLocalInfo();
            this.register = register;
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(LocalRange o) {
            return this.start != o.start ? Integer.compare(this.start, o.start) : Integer.compare(this.end, o.end);
        }

        public String toString() {
            return this.local + " @ r" + this.register + ": " + new LiveRange(this.start, this.end);
        }
    }

    private static enum ArgumentReuseMode {
        ALLOW_ARGUMENT_REUSE,
        DISALLOW_ARGUMENT_REUSE;

    }
}

