/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.ClassFileConsumer;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.DexFilePerClassFileConsumer;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.utils.AndroidApiLevel;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DefaultDiagnosticsHandler;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OutputMode;
import com.android.tools.r8.utils.Reporter;
import java.nio.file.Path;

abstract class BaseCompilerCommand
extends BaseCommand {
    private final OutputOptions outputOptions;
    private final CompilationMode mode;
    private final ProgramConsumer programConsumer;
    private final int minApiLevel;
    private final Reporter reporter;
    private final boolean enableDesugaring;

    BaseCompilerCommand(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.programConsumer = null;
        this.mode = null;
        this.minApiLevel = 0;
        this.reporter = new Reporter(new DefaultDiagnosticsHandler());
        this.enableDesugaring = true;
        this.outputOptions = null;
    }

    BaseCompilerCommand(AndroidApp app, CompilationMode mode, ProgramConsumer programConsumer, OutputOptions outputOptions, int minApiLevel, Reporter reporter, boolean enableDesugaring) {
        super(app);
        assert (minApiLevel > 0);
        assert (mode != null);
        this.mode = mode;
        this.programConsumer = programConsumer;
        this.minApiLevel = minApiLevel;
        this.reporter = reporter;
        this.enableDesugaring = enableDesugaring;
        this.outputOptions = outputOptions;
    }

    public CompilationMode getMode() {
        return this.mode;
    }

    public int getMinApiLevel() {
        return this.minApiLevel;
    }

    @Deprecated
    public Path getOutputPath() {
        if (this.outputOptions == null) {
            throw new CompilationError("Use of deprecated API may not be used with new consumer API");
        }
        return this.outputOptions.path;
    }

    @Deprecated
    public OutputMode getOutputMode() {
        if (this.outputOptions == null) {
            throw new CompilationError("Use of deprecated API may not be used with new consumer API");
        }
        return this.outputOptions.mode;
    }

    public ProgramConsumer getProgramConsumer() {
        return this.programConsumer;
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public boolean getEnableDesugaring() {
        return this.enableDesugaring;
    }

    public static abstract class Builder<C extends BaseCompilerCommand, B extends Builder<C, B>>
    extends BaseCommand.Builder<C, B> {
        private ProgramConsumer programConsumer = null;
        private Path outputPath = null;
        private OutputMode outputMode = OutputMode.Indexed;
        private CompilationMode mode;
        private int minApiLevel = AndroidApiLevel.getDefault().getLevel();
        private boolean enableDesugaring = true;

        protected Builder() {
        }

        Builder(AndroidApp app) {
            super(AndroidApp.builder(app));
        }

        Builder(AndroidApp app, DiagnosticsHandler diagnosticsHandler) {
            super(AndroidApp.builder(app), diagnosticsHandler);
        }

        protected Builder(DiagnosticsHandler diagnosticsHandler) {
            super(diagnosticsHandler);
        }

        public CompilationMode getMode() {
            return this.mode;
        }

        public B setMode(CompilationMode mode) {
            assert (mode != null);
            this.mode = mode;
            return (B)((Builder)this.self());
        }

        public Path getOutputPath() {
            return this.outputPath;
        }

        public OutputMode getOutputMode() {
            return this.outputMode;
        }

        public ProgramConsumer getProgramConsumer() {
            return this.programConsumer;
        }

        public B setProgramConsumer(ProgramConsumer programConsumer) {
            this.outputPath = null;
            this.outputMode = null;
            this.programConsumer = programConsumer;
            return (B)((Builder)this.self());
        }

        public B setOutput(Path outputPath, OutputMode outputMode) {
            assert (outputPath != null);
            assert (outputMode != null);
            assert (!outputMode.isDeprecated());
            this.outputPath = outputPath;
            this.outputMode = outputMode;
            this.programConsumer = this.createProgramOutputConsumer(outputPath, outputMode);
            return (B)((Builder)this.self());
        }

        @Deprecated
        public B setOutputPath(Path outputPath) {
            assert (this.programConsumer == null);
            this.outputPath = outputPath;
            return (B)((Builder)this.self());
        }

        @Deprecated
        public B setOutputMode(OutputMode outputMode) {
            assert (this.programConsumer == null);
            assert (outputMode == null || outputMode.isDeprecated());
            assert (this.outputMode == null || this.outputMode.isDeprecated());
            this.outputMode = outputMode;
            return (B)((Builder)this.self());
        }

        private InternalProgramOutputPathConsumer createProgramOutputConsumer(Path path, OutputMode mode) {
            if (mode.isDexIndexed()) {
                return FileUtils.isArchive(path) ? new DexIndexedConsumer.ArchiveConsumer(path) : new DexIndexedConsumer.DirectoryConsumer(path);
            }
            if (mode.isDexFilePerClassFile()) {
                return FileUtils.isArchive(path) ? new DexFilePerClassFileConsumer.ArchiveConsumer(path) : new DexFilePerClassFileConsumer.DirectoryConsumer(path);
            }
            if (mode.isClassFile()) {
                return FileUtils.isArchive(path) ? new ClassFileConsumer.ArchiveConsumer(path) : new ClassFileConsumer.DirectoryConsumer(path);
            }
            throw new Unreachable("Unexpected output mode: " + (Object)((Object)mode));
        }

        public int getMinApiLevel() {
            return this.minApiLevel;
        }

        public B setMinApiLevel(int minApiLevel) {
            assert (minApiLevel > 0);
            this.minApiLevel = minApiLevel;
            return (B)((Builder)this.self());
        }

        public B setEnableDesugaring(boolean enableDesugaring) {
            this.enableDesugaring = enableDesugaring;
            return (B)((Builder)this.self());
        }

        public boolean getEnableDesugaring() {
            return this.enableDesugaring;
        }

        @Override
        protected void validate() {
            assert (this.mode != null);
            FileUtils.validateOutputFile(this.outputPath, this.reporter);
            super.validate();
        }
    }

    protected static class OutputOptions {
        final Path path;
        final OutputMode mode;

        public OutputOptions(Path path, OutputMode mode) {
            this.path = path;
            this.mode = mode;
        }
    }
}

