/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf;

import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Value;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TypeVerificationHelper {
    private final IRCode code;
    private final DexItemFactory factory;
    private Map<Value, DexType> types;

    public TypeVerificationHelper(IRCode code, DexItemFactory factory) {
        this.code = code;
        this.factory = factory;
    }

    public DexItemFactory getFactory() {
        return this.factory;
    }

    public DexType getType(Value value) {
        assert (value.outType().isObject());
        return this.types.get(value);
    }

    public DexType join(Set<DexType> types) {
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() != 1) {
            throw new Unimplemented("compute the join of the types");
        }
        return types.iterator().next();
    }

    public Map<Value, DexType> computeVerificationTypes() {
        int argumentIndex;
        this.types = new HashMap<Value, DexType>();
        HashSet<Value> worklist = new HashSet<Value>();
        InstructionIterator it = this.code.instructionIterator();
        Instruction instruction = null;
        int n = argumentIndex = this.code.method.accessFlags.isStatic() ? 0 : -1;
        while (it.hasNext() && (instruction = (Instruction)it.next()).isArgument()) {
            DexType argumentType = argumentIndex < 0 ? this.code.method.method.getHolder() : this.code.method.method.proto.parameters.values[argumentIndex];
            Value outValue = instruction.outValue();
            if (outValue.outType().isObject()) {
                this.types.put(outValue, argumentType);
                TypeVerificationHelper.addUsers(outValue, worklist);
            }
            ++argumentIndex;
        }
        while (instruction != null) {
            assert (!instruction.isArgument());
            if (instruction.outValue() != null && instruction.outType().isObject()) {
                Value outValue = instruction.outValue();
                if (instruction.hasInvariantVerificationType()) {
                    DexType type = instruction.computeVerificationType(this);
                    assert (type != null);
                    this.types.put(outValue, type);
                    TypeVerificationHelper.addUsers(outValue, worklist);
                }
            }
            instruction = it.hasNext() ? (Instruction)it.next() : null;
        }
        while (!worklist.isEmpty()) {
            DexType refinedType;
            Value item = (Value)worklist.iterator().next();
            worklist.remove(item);
            assert (item.outType().isObject());
            DexType previousType = this.types.get(item);
            if (previousType == (refinedType = this.computeVerificationType(item))) continue;
            this.types.put(item, refinedType);
            TypeVerificationHelper.addUsers(item, worklist);
        }
        return this.types;
    }

    private DexType computeVerificationType(Value value) {
        return value.isPhi() ? value.asPhi().computeVerificationType(this) : value.definition.computeVerificationType(this);
    }

    private static void addUsers(Value value, Set<Value> worklist) {
        worklist.addAll(value.uniquePhiUsers());
        for (Instruction instruction : value.uniqueUsers()) {
            if (instruction.outValue() == null || !instruction.outType().isObject() || instruction.hasInvariantVerificationType()) continue;
            worklist.add(instruction.outValue());
        }
    }
}

