/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.compatproguard;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.R8;
import com.android.tools.r8.R8Command;
import com.android.tools.r8.Version;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.compatproguard.CompatProguardCommandBuilder;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.utils.AbortException;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.OutputMode;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;

public class CompatProguard {
    private static void run(String[] args) throws IOException, CompilationException, CompilationFailedException {
        if (args.length == 0) {
            Version.printToolVersion("CompatProguard");
            return;
        }
        System.out.println("CompatProguard " + String.join((CharSequence)" ", args));
        CompatProguardOptions options = CompatProguardOptions.parse(args);
        CompatProguardCommandBuilder builder = new CompatProguardCommandBuilder(options.forceProguardCompatibility);
        ((R8Command.Builder)builder.setOutput(Paths.get(options.output, new String[0]), OutputMode.DexIndexed)).addProguardConfiguration(options.proguardConfig, CommandLineOrigin.INSTANCE).setMinApiLevel(options.minApi);
        if (options.mainDexList != null) {
            builder.addMainDexListFiles(Paths.get(options.mainDexList, new String[0]));
        }
        AndroidApp result = R8.runInternal((R8Command)builder.build());
        if (!options.multiDex && result.getDexProgramResources().size() > 1) {
            throw new CompilationError("Compilation result could not fit into a single dex file. Reduce the input-program size or run with --multi-dex enabled");
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            CompatProguard.run(args);
        }
        catch (CompilationException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (CompilationFailedException | AbortException e) {
            System.err.println("Compilation failed");
            System.exit(1);
        }
    }

    public static class CompatProguardOptions {
        public final String output;
        public final int minApi;
        public final boolean forceProguardCompatibility;
        public final boolean multiDex;
        public final String mainDexList;
        public final List<String> proguardConfig;

        CompatProguardOptions(List<String> proguardConfig, String output, int minApi, boolean multiDex, boolean forceProguardCompatibility, String mainDexList) {
            this.output = output;
            this.minApi = minApi;
            this.forceProguardCompatibility = forceProguardCompatibility;
            this.multiDex = multiDex;
            this.mainDexList = mainDexList;
            this.proguardConfig = proguardConfig;
        }

        public static CompatProguardOptions parse(String[] args) throws CompilationException {
            String output = null;
            int minApi = 1;
            boolean forceProguardCompatibility = false;
            boolean multiDex = false;
            String mainDexList = null;
            boolean minimalMainDex = false;
            boolean coreLibrary = false;
            ImmutableList.Builder builder = ImmutableList.builder();
            if (args.length > 0) {
                StringBuilder currentLine = new StringBuilder();
                for (int i = 0; i < args.length; ++i) {
                    String arg = args[i];
                    if (arg.charAt(0) == '-') {
                        if (arg.equals("--min-api")) {
                            minApi = Integer.valueOf(args[++i]);
                            continue;
                        }
                        if (arg.equals("--force-proguard-compatibility")) {
                            forceProguardCompatibility = true;
                            continue;
                        }
                        if (arg.equals("--output")) {
                            output = args[++i];
                            continue;
                        }
                        if (arg.equals("--multi-dex")) {
                            multiDex = true;
                            continue;
                        }
                        if (arg.equals("--main-dex-list")) {
                            mainDexList = args[++i];
                            continue;
                        }
                        if (arg.startsWith("--main-dex-list=")) {
                            mainDexList = arg.substring("--main-dex-list=".length());
                            continue;
                        }
                        if (arg.equals("--minimal-main-dex")) {
                            minimalMainDex = true;
                            continue;
                        }
                        if (arg.equals("--core-library")) {
                            coreLibrary = true;
                            continue;
                        }
                        if (arg.equals("-outjars")) {
                            throw new CompilationException("Proguard argument -outjar is not supported. Use R8 compatible --output flag");
                        }
                        if (currentLine.length() > 0) {
                            builder.add(currentLine.toString());
                        }
                        currentLine = new StringBuilder(arg);
                        continue;
                    }
                    if (currentLine.length() > 0) {
                        currentLine.append(' ');
                    }
                    currentLine.append(arg);
                }
                builder.add(currentLine.toString());
            }
            return new CompatProguardOptions((List<String>)((Object)builder.build()), output, minApi, multiDex, forceProguardCompatibility, mainDexList);
        }
    }
}

