/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class IRCodeInstructionsIterator
implements InstructionIterator {
    private ListIterator<BasicBlock> blockIterator;
    private InstructionListIterator instructionIterator;

    public IRCodeInstructionsIterator(IRCode code) {
        this.blockIterator = code.blocks.listIterator();
        this.instructionIterator = this.blockIterator.next().listIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.instructionIterator.hasNext()) {
            return true;
        }
        return this.blockIterator.hasNext();
    }

    @Override
    public Instruction next() {
        if (this.instructionIterator.hasNext()) {
            return (Instruction)this.instructionIterator.next();
        }
        if (!this.blockIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        this.instructionIterator = this.blockIterator.next().listIterator();
        assert (this.instructionIterator.hasNext());
        return (Instruction)this.instructionIterator.next();
    }

    @Override
    public void add(Instruction instruction) {
        this.instructionIterator.add(instruction);
    }

    @Override
    public void remove() {
        this.instructionIterator.remove();
    }

    @Override
    public void replaceCurrentInstruction(Instruction newInstruction) {
        this.instructionIterator.replaceCurrentInstruction(newInstruction);
    }

    @Override
    public void removeOrReplaceByDebugLocalRead() {
        this.instructionIterator.removeOrReplaceByDebugLocalRead();
    }
}

