/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import java.nio.charset.StandardCharsets;

class UsagePrinter {
    private static final String INDENT = "    ";
    static final UsagePrinter DONT_PRINT = new NoOpUsagePrinter();
    private final StringBuilder writer = new StringBuilder();
    private DexProgramClass enclosingClazz = null;
    private boolean clazzPrefixPrinted = false;

    UsagePrinter() {
    }

    String toStringContent() {
        return this.writer.toString();
    }

    byte[] toByteArray() {
        return this.writer.toString().getBytes(StandardCharsets.UTF_8);
    }

    void printUnusedClass(DexProgramClass clazz) {
        this.writer.append(clazz.toSourceString());
        this.writer.append('\n');
    }

    void visiting(DexProgramClass clazz) {
        assert (this.enclosingClazz == null);
        this.enclosingClazz = clazz;
    }

    void visited() {
        this.enclosingClazz = null;
        this.clazzPrefixPrinted = false;
    }

    private void printClazzPrefixIfNecessary() {
        assert (this.enclosingClazz != null);
        if (!this.clazzPrefixPrinted) {
            this.writer.append(this.enclosingClazz.toSourceString());
            this.writer.append('\n');
            this.clazzPrefixPrinted = true;
        }
    }

    void printUnusedMethod(DexEncodedMethod method) {
        this.printClazzPrefixIfNecessary();
        this.writer.append(INDENT);
        String accessFlags = method.accessFlags.toString();
        if (!accessFlags.isEmpty()) {
            this.writer.append(accessFlags).append(' ');
        }
        this.writer.append(method.method.proto.returnType.toSourceString()).append(' ');
        this.writer.append(method.method.name.toSourceString());
        this.writer.append('(');
        for (int i = 0; i < method.method.proto.parameters.values.length; ++i) {
            if (i != 0) {
                this.writer.append(',');
            }
            this.writer.append(method.method.proto.parameters.values[i].toSourceString());
        }
        this.writer.append(')');
        this.writer.append('\n');
    }

    void printUnusedField(DexEncodedField field) {
        this.printClazzPrefixIfNecessary();
        this.writer.append(INDENT);
        String accessFlags = field.accessFlags.toString();
        if (!accessFlags.isEmpty()) {
            this.writer.append(accessFlags).append(' ');
        }
        this.writer.append(field.field.type.toSourceString()).append(" ");
        this.writer.append(field.field.name.toSourceString());
        this.writer.append('\n');
    }

    private static class NoOpUsagePrinter
    extends UsagePrinter {
        private NoOpUsagePrinter() {
        }

        @Override
        byte[] toByteArray() {
            return null;
        }

        @Override
        void printUnusedClass(DexProgramClass clazz) {
        }

        @Override
        void visiting(DexProgramClass clazz) {
        }

        @Override
        void visited() {
        }

        @Override
        void printUnusedMethod(DexEncodedMethod method) {
        }

        @Override
        void printUnusedField(DexEncodedField field) {
        }
    }
}

