/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.ArchiveEntryOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.shaking.FilteredClassPath;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OneShotByteResource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ProgramFileArchiveReader {
    private final Origin origin;
    private final FilteredClassPath archive;
    private boolean ignoreDexInArchive;
    private List<ProgramResource> dexResources = null;
    private List<ProgramResource> classResources = null;

    ProgramFileArchiveReader(FilteredClassPath archive, boolean ignoreDexInArchive) {
        this.origin = new PathOrigin(archive.getPath());
        this.archive = archive;
        this.ignoreDexInArchive = ignoreDexInArchive;
    }

    private void readArchive() throws IOException {
        assert (FileUtils.isArchive(this.archive.getPath()));
        this.dexResources = new ArrayList<ProgramResource>();
        this.classResources = new ArrayList<ProgramResource>();
        try (ZipFile zipFile = new ZipFile(this.archive.getPath().toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    Path name = Paths.get(entry.getName(), new String[0]);
                    ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(entry.getName(), this.origin);
                    if (!this.archive.matchesFile(name)) continue;
                    if (FileUtils.isDexFile(name)) {
                        if (this.ignoreDexInArchive) continue;
                        ProgramResource resource = OneShotByteResource.create(ProgramResource.Kind.DEX, entryOrigin, ByteStreams.toByteArray(stream), null);
                        this.dexResources.add(resource);
                        continue;
                    }
                    if (!FileUtils.isClassFile(name)) continue;
                    String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                    ProgramResource resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray(stream), Collections.singleton(descriptor));
                    this.classResources.add(resource);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    ProgramFileArchiveReader.$closeResource(throwable, stream);
                }
            }
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e);
        }
        if (!this.dexResources.isEmpty() && !this.classResources.isEmpty()) {
            throw new CompilationError("Cannot create android app from an archive '" + this.archive + "' containing both DEX and Java-bytecode content");
        }
    }

    public Collection<ProgramResource> getDexProgramResources() throws IOException {
        if (this.dexResources == null) {
            this.readArchive();
        }
        List<ProgramResource> result = this.dexResources;
        this.dexResources = null;
        return result;
    }

    public Collection<ProgramResource> getClassProgramResources() throws IOException {
        if (this.classResources == null) {
            this.readArchive();
        }
        List<ProgramResource> result = this.classResources;
        this.classResources = null;
        return result;
    }
}

