/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.Resource;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.OutputMode;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

abstract class BaseOutput {
    private final AndroidApp app;
    private final OutputMode outputMode;

    BaseOutput(AndroidApp app, OutputMode outputMode) {
        this.app = app;
        this.outputMode = outputMode;
    }

    AndroidApp getAndroidApp() {
        return this.app;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    public List<Resource> getDexResources() {
        try {
            return ImmutableList.copyOf(this.app.getDexProgramResources());
        }
        catch (IOException e) {
            throw new InternalCompilerError("Unexpected resource error", e);
        }
    }

    public abstract void write(Path var1) throws IOException;
}

