/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import java.util.List;

abstract class FieldInstruction
extends Instruction {
    protected final MemberType type;
    protected final DexField field;

    protected FieldInstruction(MemberType type, DexField field, Value dest, Value object) {
        super(dest, object);
        assert (type != null);
        assert (field != null);
        this.type = type;
        this.field = field;
    }

    protected FieldInstruction(MemberType type, DexField field, Value dest, List<Value> values) {
        super(dest, values);
        assert (type != null);
        assert (field != null);
        this.type = type;
        this.field = field;
    }

    public MemberType getType() {
        return this.type;
    }

    public DexField getField() {
        return this.field;
    }

    abstract DexEncodedField lookupTarget(DexType var1, AppInfo var2);

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType invocationContext) {
        DexType fieldHolder = this.field.getHolder();
        DexEncodedField target = this.lookupTarget(fieldHolder, info);
        DexClass fieldClass = info.definitionFor(fieldHolder);
        if (target != null && fieldClass != null) {
            Inliner.Constraint fieldConstraint = Inliner.Constraint.deriveConstraint(invocationContext, fieldHolder, target.accessFlags, info);
            Inliner.Constraint classConstraint = Inliner.Constraint.deriveConstraint(invocationContext, fieldHolder, fieldClass.accessFlags, info);
            return Inliner.Constraint.min(fieldConstraint, classConstraint);
        }
        return Inliner.Constraint.NEVER;
    }
}

