/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import com.android.tools.r8.naming.ClassNamingForMapApplier;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.ProguardMapError;
import com.android.tools.r8.naming.SeedMapper;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.ArrayUtils;
import com.android.tools.r8.utils.ThrowingConsumer;
import com.android.tools.r8.utils.Timing;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;

public class ProguardMapApplier {
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final GraphLense previousLense;
    private final SeedMapper seedMapper;

    public ProguardMapApplier(Enqueuer.AppInfoWithLiveness appInfo, GraphLense previousLense, SeedMapper seedMapper) {
        this.appInfo = appInfo;
        this.previousLense = previousLense;
        this.seedMapper = seedMapper;
    }

    public GraphLense run(Timing timing) {
        timing.begin("from-pg-map-to-lense");
        GraphLense lenseFromMap = new MapToLenseConverter().run(this.previousLense);
        timing.end();
        timing.begin("fix-types-in-programs");
        GraphLense typeFixedLense = new TreeFixer(lenseFromMap).run();
        timing.end();
        return typeFixedLense;
    }

    private static class ConflictFreeBuilder
    extends GraphLense.Builder {
        ConflictFreeBuilder() {
        }

        @Override
        public void map(DexType from, DexType to) {
            String keptName;
            if (this.typeMap.containsKey(from) && !(keptName = ((DexType)this.typeMap.get(from)).getName()).equals(to.getName())) {
                throw ProguardMapError.keptTypeWasRenamed(from, keptName, to.getName());
            }
            super.map(from, to);
        }

        @Override
        public void map(DexMethod from, DexMethod to) {
            String keptName;
            if (this.methodMap.containsKey(from) && !(keptName = ((DexMethod)this.methodMap.get((Object)from)).name.toString()).equals(to.name.toString())) {
                throw ProguardMapError.keptMethodWasRenamed(from, keptName, to.name.toString());
            }
            super.map(from, to);
        }

        @Override
        public void map(DexField from, DexField to) {
            String keptName;
            if (this.fieldMap.containsKey(from) && !(keptName = ((DexField)this.fieldMap.get((Object)from)).name.toString()).equals(to.name.toString())) {
                throw ProguardMapError.keptFieldWasRenamed(from, keptName, to.name.toString());
            }
            super.map(from, to);
        }

        DexType lookup(DexType from) {
            return this.typeMap.getOrDefault(from, from);
        }
    }

    class TreeFixer {
        private final ConflictFreeBuilder lenseBuilder;
        private final GraphLense appliedLense;
        private final Map<DexProto, DexProto> protoFixupCache = new IdentityHashMap<DexProto, DexProto>();

        TreeFixer(GraphLense appliedLense) {
            this.lenseBuilder = new ConflictFreeBuilder();
            this.appliedLense = appliedLense;
        }

        private GraphLense run() {
            ProguardMapApplier.this.appInfo.classes().forEach(this::fixClass);
            ProguardMapApplier.this.appInfo.libraryClasses().forEach(this::fixClass);
            return this.lenseBuilder.build(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, this.appliedLense);
        }

        private void fixClass(DexClass clazz) {
            clazz.type = this.substituteType(clazz.type, null);
            clazz.superType = this.substituteType(clazz.superType, null);
            clazz.interfaces = this.substituteTypesIn(clazz.interfaces);
            clazz.annotations = this.substituteTypesIn(clazz.annotations);
            clazz.setDirectMethods(this.substituteTypesIn(clazz.directMethods()));
            clazz.setVirtualMethods(this.substituteTypesIn(clazz.virtualMethods()));
            clazz.setStaticFields(this.substituteTypesIn(clazz.staticFields()));
            clazz.setInstanceFields(this.substituteTypesIn(clazz.instanceFields()));
        }

        private DexEncodedMethod[] substituteTypesIn(DexEncodedMethod[] methods) {
            if (methods == null) {
                return null;
            }
            for (int i = 0; i < methods.length; ++i) {
                DexMethod newMethod;
                DexEncodedMethod encodedMethod = methods[i];
                DexMethod appliedMethod = this.appliedLense.lookupMethod(encodedMethod.method, encodedMethod);
                DexProto newProto = this.substituteTypesIn(appliedMethod.proto, encodedMethod);
                if (newProto != appliedMethod.proto) {
                    newMethod = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createMethod(this.substituteType(appliedMethod.holder, encodedMethod), newProto, appliedMethod.name);
                    this.lenseBuilder.map(encodedMethod.method, newMethod);
                } else {
                    newMethod = appliedMethod;
                }
                methods[i] = encodedMethod.toTypeSubstitutedMethod(newMethod);
            }
            return methods;
        }

        private DexEncodedField[] substituteTypesIn(DexEncodedField[] fields) {
            if (fields == null) {
                return null;
            }
            for (int i = 0; i < fields.length; ++i) {
                DexField newField;
                DexEncodedField encodedField = fields[i];
                DexField appliedField = this.appliedLense.lookupField(encodedField.field, null);
                DexType newType = this.substituteType(appliedField.type, null);
                if (newType != appliedField.type) {
                    newField = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createField(this.substituteType(appliedField.clazz, null), newType, appliedField.name);
                    this.lenseBuilder.map(encodedField.field, newField);
                } else {
                    newField = appliedField;
                }
                fields[i] = encodedField.toTypeSubstitutedField(newField);
            }
            return fields;
        }

        private DexProto substituteTypesIn(DexProto proto, DexEncodedMethod context) {
            DexProto result = this.protoFixupCache.get(proto);
            if (result == null) {
                DexType returnType = this.substituteType(proto.returnType, context);
                DexType[] arguments = this.substituteTypesIn(proto.parameters.values, context);
                if (arguments != null || returnType != proto.returnType) {
                    arguments = arguments == null ? proto.parameters.values : arguments;
                    result = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createProto(returnType, arguments);
                } else {
                    result = proto;
                }
                this.protoFixupCache.put(proto, result);
            }
            return result;
        }

        private DexAnnotationSet substituteTypesIn(DexAnnotationSet annotations) {
            if (annotations.isEmpty()) {
                return annotations;
            }
            DexAnnotation[] result = this.substituteTypesIn(annotations.annotations);
            return result == null ? annotations : new DexAnnotationSet(result);
        }

        private DexAnnotation[] substituteTypesIn(DexAnnotation[] annotations) {
            Int2ObjectArrayMap<DexAnnotation> changed = new Int2ObjectArrayMap<DexAnnotation>();
            for (int i = 0; i < annotations.length; ++i) {
                DexAnnotation applied = this.substituteTypesIn(annotations[i]);
                if (applied == annotations[i]) continue;
                changed.put(Integer.valueOf(i), applied);
            }
            return changed.isEmpty() ? null : ArrayUtils.copyWithSparseChanges(DexAnnotation[].class, annotations, changed);
        }

        private DexAnnotation substituteTypesIn(DexAnnotation annotation) {
            return new DexAnnotation(annotation.visibility, this.substituteTypesIn(annotation.annotation));
        }

        private DexEncodedAnnotation substituteTypesIn(DexEncodedAnnotation annotation) {
            return new DexEncodedAnnotation(this.substituteType(annotation.type, null), annotation.elements);
        }

        private DexTypeList substituteTypesIn(DexTypeList types) {
            if (types.isEmpty()) {
                return types;
            }
            DexType[] result = this.substituteTypesIn(types.values, null);
            return result == null ? types : new DexTypeList(result);
        }

        private DexType[] substituteTypesIn(DexType[] types, DexEncodedMethod context) {
            Int2ObjectArrayMap<DexType> changed = new Int2ObjectArrayMap<DexType>();
            for (int i = 0; i < types.length; ++i) {
                DexType applied = this.substituteType(types[i], context);
                if (applied == types[i]) continue;
                changed.put(Integer.valueOf(i), applied);
            }
            return changed.isEmpty() ? null : ArrayUtils.copyWithSparseChanges(DexType[].class, types, changed);
        }

        private DexType substituteType(DexType type, DexEncodedMethod context) {
            if (type == null) {
                return null;
            }
            if (type.isArrayType()) {
                DexType fixed;
                DexType base = type.toBaseType(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory);
                if (base == (fixed = this.substituteType(base, context))) {
                    return type;
                }
                return type.replaceBaseType(fixed, ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory);
            }
            return this.appliedLense.lookupType(type, context);
        }
    }

    static class ChainedClassNaming
    extends ClassNamingForMapApplier {
        final ChainedClassNaming superClassNaming;

        ChainedClassNaming(ChainedClassNaming superClassNaming, ClassNamingForMapApplier thisClassNaming) {
            super(thisClassNaming);
            this.superClassNaming = superClassNaming;
        }

        @Override
        public <T extends Throwable> void forAllMethodNaming(ThrowingConsumer<MemberNaming, T> consumer) throws T {
            super.forAllMethodNaming(consumer);
            if (this.superClassNaming != null) {
                this.superClassNaming.forAllMethodNaming(consumer);
            }
        }

        @Override
        protected MemberNaming lookupByOriginalItem(DexMethod method) {
            MemberNaming memberNaming = super.lookupByOriginalItem(method);
            if (memberNaming != null) {
                return memberNaming;
            }
            if (this.superClassNaming != null) {
                return this.superClassNaming.lookupByOriginalItem(method);
            }
            return null;
        }
    }

    class MapToLenseConverter {
        private final ConflictFreeBuilder lenseBuilder;
        private final Map<DexProto, DexProto> protoFixupCache = new IdentityHashMap<DexProto, DexProto>();

        MapToLenseConverter() {
            this.lenseBuilder = new ConflictFreeBuilder();
        }

        private GraphLense run(GraphLense previousLense) {
            this.applyClassMappingForClasses(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.objectType, null);
            DexType.forAllInterfaces(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, itf -> this.applyClassMappingForInterfaces((DexType)itf, null));
            return this.lenseBuilder.build(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, previousLense);
        }

        private void applyClassMappingForClasses(DexType type, ChainedClassNaming classNamingFromSuperType) {
            ChainedClassNaming classNaming = this.chainClassNaming(type, classNamingFromSuperType);
            this.applyClassMapping(type, classNaming);
            type.forAllExtendsSubtypes(subtype -> this.applyClassMappingForClasses((DexType)subtype, classNaming));
        }

        private void applyClassMappingForInterfaces(DexType type, ChainedClassNaming classNamingFromSuperType) {
            ChainedClassNaming classNaming = this.chainClassNaming(type, classNamingFromSuperType);
            DexClass clazz = ProguardMapApplier.this.appInfo.definitionFor(type);
            if (clazz != null && clazz.isProgramClass()) {
                this.applyClassMapping(type, classNaming);
            }
            type.forAllExtendsSubtypes(subtype -> this.applyClassMappingForInterfaces((DexType)subtype, classNaming));
            type.forAllImplementsSubtypes(subtype -> this.applyClassMappingForInterfaces((DexType)subtype, classNaming));
        }

        private ChainedClassNaming chainClassNaming(DexType type, ChainedClassNaming classNamingFromSuperType) {
            return ProguardMapApplier.this.seedMapper.hasMapping(type) ? new ChainedClassNaming(classNamingFromSuperType, ProguardMapApplier.this.seedMapper.getClassNaming(type)) : classNamingFromSuperType;
        }

        private void applyClassMapping(DexType type, ChainedClassNaming classNaming) {
            if (classNaming != null) {
                if (ProguardMapApplier.this.seedMapper.hasMapping(type) && this.lenseBuilder.lookup(type) == type) {
                    DexType appliedType = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createType(classNaming.renamedName);
                    this.lenseBuilder.map(type, appliedType);
                }
                this.applyMemberMapping(type, classNaming);
            }
        }

        private void applyMemberMapping(DexType from, ChainedClassNaming classNaming) {
            DexClass clazz = ProguardMapApplier.this.appInfo.definitionFor(from);
            if (clazz == null) {
                return;
            }
            HashSet appliedMemberNaming = new HashSet();
            clazz.forEachField(encodedField -> {
                MemberNaming memberNaming = classNaming.lookupByOriginalItem(encodedField.field);
                if (memberNaming != null) {
                    appliedMemberNaming.add(memberNaming);
                    this.applyFieldMapping(encodedField.field, memberNaming);
                }
            });
            clazz.forEachMethod(encodedMethod -> {
                MemberNaming memberNaming = classNaming.lookupByOriginalItem(encodedMethod.method);
                if (memberNaming != null) {
                    appliedMemberNaming.add(memberNaming);
                    this.applyMethodMapping(encodedMethod.method, memberNaming);
                }
            });
            if (clazz.isLibraryClass()) {
                classNaming.forAllFieldNaming(memberNaming -> {
                    if (!appliedMemberNaming.contains(memberNaming)) {
                        DexField pretendedOriginalField = ((MemberNaming.FieldSignature)memberNaming.getOriginalSignature()).toDexField(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, from);
                        this.applyFieldMapping(pretendedOriginalField, (MemberNaming)memberNaming);
                    }
                });
                classNaming.forAllMethodNaming(memberNaming -> {
                    if (!appliedMemberNaming.contains(memberNaming)) {
                        DexMethod pretendedOriginalMethod = ((MemberNaming.MethodSignature)memberNaming.getOriginalSignature()).toDexMethod(((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory, from);
                        this.applyMethodMapping(pretendedOriginalMethod, (MemberNaming)memberNaming);
                    }
                });
            }
        }

        private void applyFieldMapping(DexField originalField, MemberNaming memberNaming) {
            MemberNaming.FieldSignature appliedSignature = (MemberNaming.FieldSignature)memberNaming.getRenamedSignature();
            DexField appliedField = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createField(this.applyClassMappingOnTheFly(originalField.clazz), this.applyClassMappingOnTheFly(originalField.type), ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createString(appliedSignature.name));
            this.lenseBuilder.map(originalField, appliedField);
        }

        private void applyMethodMapping(DexMethod originalMethod, MemberNaming memberNaming) {
            MemberNaming.MethodSignature appliedSignature = (MemberNaming.MethodSignature)memberNaming.getRenamedSignature();
            DexMethod appliedMethod = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createMethod(this.applyClassMappingOnTheFly(originalMethod.holder), this.applyClassMappingOnTheFly(originalMethod.proto), ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createString(appliedSignature.name));
            this.lenseBuilder.map(originalMethod, appliedMethod);
        }

        private DexType applyClassMappingOnTheFly(DexType from) {
            if (ProguardMapApplier.this.seedMapper.hasMapping(from)) {
                DexType appliedType = this.lenseBuilder.lookup(from);
                if (appliedType != from) {
                    return appliedType;
                }
                ClassNamingForMapApplier classNaming = ProguardMapApplier.this.seedMapper.getClassNaming(from);
                appliedType = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createType(classNaming.renamedName);
                this.lenseBuilder.map(from, appliedType);
                return appliedType;
            }
            return from;
        }

        private DexProto applyClassMappingOnTheFly(DexProto proto) {
            DexProto result = this.protoFixupCache.get(proto);
            if (result == null) {
                DexType returnType = this.applyClassMappingOnTheFly(proto.returnType);
                DexType[] arguments = this.applyClassMappingOnTheFly(proto.parameters.values);
                if (arguments != null || returnType != proto.returnType) {
                    arguments = arguments == null ? proto.parameters.values : arguments;
                    result = ((ProguardMapApplier)ProguardMapApplier.this).appInfo.dexItemFactory.createProto(returnType, arguments);
                } else {
                    result = proto;
                }
                this.protoFixupCache.put(proto, result);
            }
            return result;
        }

        private DexType[] applyClassMappingOnTheFly(DexType[] types) {
            Int2ObjectArrayMap<DexType> changed = new Int2ObjectArrayMap<DexType>();
            for (int i = 0; i < types.length; ++i) {
                DexType applied = this.applyClassMappingOnTheFly(types[i]);
                if (applied == types[i]) continue;
                changed.put(Integer.valueOf(i), applied);
            }
            return changed.isEmpty() ? null : ArrayUtils.copyWithSparseChanges(DexType[].class, types, changed);
        }
    }
}

