/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Opcodes;

public class CfFrame
extends CfInstruction {
    private final Int2ReferenceSortedMap<DexType> locals;

    public CfFrame(Int2ReferenceSortedMap<DexType> locals) {
        this.locals = locals;
    }

    private boolean isWide(DexType type) {
        return type.isPrimitiveType() && (type.toShorty() == 'J' || type.toShorty() == 'D');
    }

    @Override
    public void write(MethodVisitor visitor) {
        if (this.locals.isEmpty()) {
            visitor.visitFrame(-1, 0, null, 0, null);
            return;
        }
        int maxRegister = this.locals.lastIntKey();
        int localsCount = 0;
        for (int i = 0; i <= maxRegister; ++i) {
            ++localsCount;
            DexType type = (DexType)this.locals.get(i);
            if (type == null || !this.isWide(type)) continue;
            ++i;
        }
        Object[] localsCopy = new Object[localsCount];
        int localIndex = 0;
        for (int i = 0; i <= maxRegister; ++i) {
            DexType type = (DexType)this.locals.get(i);
            Object typeOpcode = this.getType(type);
            localsCopy[localIndex++] = typeOpcode;
            if (type == null || !this.isWide(type)) continue;
            ++i;
        }
        visitor.visitFrame(-1, localsCount, localsCopy, 0, null);
    }

    private Object getType(DexType type) {
        if (type == null) {
            return Opcodes.TOP;
        }
        if (type == DexItemFactory.nullValueType) {
            return Opcodes.NULL;
        }
        switch (type.toShorty()) {
            case 'L': {
                return type.getInternalName();
            }
            case 'I': {
                return Opcodes.INTEGER;
            }
            case 'F': {
                return Opcodes.FLOAT;
            }
            case 'J': {
                return Opcodes.LONG;
            }
            case 'D': {
                return Opcodes.DOUBLE;
            }
        }
        throw new Unreachable("Unexpected value type: " + type);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }
}

