/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;

public class ClassTypeLatticeElement
extends TypeLatticeElement {
    final DexType classType;

    ClassTypeLatticeElement(DexType classType, boolean isNullable) {
        super(isNullable);
        assert (classType.isClassType());
        this.classType = classType;
    }

    @Override
    TypeLatticeElement asNullable() {
        return this.isNullable() ? this : new ClassTypeLatticeElement(this.classType, true);
    }

    @Override
    public TypeLatticeElement arrayGet(AppInfoWithSubtyping appInfo) {
        return ClassTypeLatticeElement.objectType(appInfo, true);
    }

    @Override
    public TypeLatticeElement checkCast(AppInfoWithSubtyping appInfo, DexType castType) {
        if (this.classType.isSubtypeOf(castType, appInfo)) {
            return this;
        }
        return ClassTypeLatticeElement.fromDexType(appInfo, castType, this.isNullable());
    }

    @Override
    public String toString() {
        return this.isNullableString() + this.classType.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ClassTypeLatticeElement other = (ClassTypeLatticeElement)o;
        return this.classType == other.classType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.classType.hashCode();
        return result;
    }
}

