/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfReturn;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.code.MoveType;
import com.android.tools.r8.code.ReturnObject;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.code.ReturnWide;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;

public class Return
extends JumpInstruction {
    private final ValueType returnType;

    public Return() {
        super(null);
        this.returnType = null;
    }

    public Return(Value value, ValueType returnType) {
        super(null, value);
        assert (returnType != ValueType.INT_OR_FLOAT_OR_NULL);
        this.returnType = returnType;
    }

    public boolean isReturnVoid() {
        return this.inValues.size() == 0;
    }

    public ValueType getReturnType() {
        return this.returnType;
    }

    public Value returnValue() {
        assert (!this.isReturnVoid());
        return (Value)this.inValues.get(0);
    }

    public com.android.tools.r8.code.Instruction createDexInstruction(DexBuilder builder) {
        if (this.isReturnVoid()) {
            return new ReturnVoid();
        }
        int register = builder.allocatedRegister(this.returnValue(), this.getNumber());
        switch (MoveType.fromValueType(this.returnType)) {
            case OBJECT: {
                assert (this.returnValue().outType().isObjectOrNull());
                return new ReturnObject(register);
            }
            case SINGLE: {
                assert (this.returnValue().outType().isSingleOrZero());
                return new com.android.tools.r8.code.Return(register);
            }
            case WIDE: {
                assert (this.returnValue().outType().isWide());
                return new ReturnWide(register);
            }
        }
        throw new Unreachable();
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addReturn(this, this.createDexInstruction(builder));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (this.isReturnVoid()) {
            return other.asReturn().isReturnVoid();
        }
        return other.asReturn().returnValue().type == this.returnValue().type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        if (this.isReturnVoid()) {
            return other.asReturn().isReturnVoid() ? 0 : -1;
        }
        return this.returnValue().type.ordinal() - other.asReturn().returnValue().type.ordinal();
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "Return defines no values.";
        return 0;
    }

    @Override
    public boolean isReturn() {
        return true;
    }

    @Override
    public Return asReturn() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(AppInfoWithSubtyping info, DexType invocationContext) {
        return Inliner.Constraint.ALWAYS;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        if (!this.isReturnVoid()) {
            helper.loadInValues(this, it);
        }
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(this.isReturnVoid() ? new CfReturnVoid() : new CfReturn(this.returnType));
    }
}

