/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NumericType;

public enum ValueType {
    OBJECT,
    INT,
    FLOAT,
    INT_OR_FLOAT,
    INT_OR_FLOAT_OR_NULL,
    LONG,
    DOUBLE,
    LONG_OR_DOUBLE;


    public boolean isObject() {
        return this == OBJECT;
    }

    public boolean isSingle() {
        return this == INT || this == FLOAT || this == INT_OR_FLOAT;
    }

    public boolean isWide() {
        return this == LONG || this == DOUBLE || this == LONG_OR_DOUBLE;
    }

    public boolean isObjectOrSingle() {
        return !this.isWide();
    }

    public boolean isObjectOrNull() {
        return this.isObject() || this == INT_OR_FLOAT_OR_NULL;
    }

    public boolean isSingleOrZero() {
        return this.isSingle() || this == INT_OR_FLOAT_OR_NULL;
    }

    public boolean isPreciseType() {
        return this != INT_OR_FLOAT && this != LONG_OR_DOUBLE && this != INT_OR_FLOAT_OR_NULL;
    }

    public boolean compatible(ValueType other) {
        return this == other || this.isSingle() && other.isSingle() || this.isWide() && other.isWide();
    }

    public int requiredRegisters() {
        return this.isWide() ? 2 : 1;
    }

    public static ValueType fromMemberType(MemberType type) {
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case INT_OR_FLOAT: {
                return INT_OR_FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case LONG_OR_DOUBLE: {
                return LONG_OR_DOUBLE;
            }
            case OBJECT: {
                return OBJECT;
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)type));
    }

    public static ValueType fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static ValueType fromDexType(DexType type) {
        return ValueType.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public static ValueType fromNumericType(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)type) + "'");
    }
}

