/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCommand;
import com.android.tools.r8.StringConsumer;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.origin.CommandLineOrigin;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.shaking.ProguardConfigurationParser;
import com.android.tools.r8.shaking.ProguardConfigurationRule;
import com.android.tools.r8.shaking.ProguardConfigurationSource;
import com.android.tools.r8.shaking.ProguardConfigurationSourceFile;
import com.android.tools.r8.shaking.ProguardConfigurationSourceStrings;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.DefaultDiagnosticsHandler;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class GenerateMainDexListCommand
extends BaseCommand {
    private final ImmutableList<ProguardConfigurationRule> mainDexKeepRules;
    private final StringConsumer mainDexListConsumer;
    private final DexItemFactory factory;
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", ImmutableList.of("Usage: maindex [options] <input-files>", " where <input-files> are JAR files", " and options are:", "  --main-dex-rules <file>  # Proguard keep rules for classes to place in the", "                           # primary dex file.", "  --main-dex-list <file>   # List of classes to place in the primary dex file.", "  --main-dex-list-output <file>  # Output the full main-dex list in <file>.", "  --version                # Print the version.", "  --help                   # Print this message."));

    @Deprecated
    public Path getMainDexListOutputPath() {
        return this.mainDexListConsumer instanceof StringConsumer.FileConsumer ? ((StringConsumer.FileConsumer)this.mainDexListConsumer).getOutputPath() : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder parse(String[] args) {
        Builder builder = GenerateMainDexListCommand.builder();
        GenerateMainDexListCommand.parse(args, builder);
        return builder;
    }

    private static void parse(String[] args, Builder builder) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (arg.length() == 0) continue;
            if (arg.equals("--help")) {
                builder.setPrintHelp(true);
                continue;
            }
            if (arg.equals("--version")) {
                builder.setPrintVersion(true);
                continue;
            }
            if (arg.equals("--main-dex-rules")) {
                builder.addMainDexRulesFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list")) {
                builder.addMainDexListFiles(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.equals("--main-dex-list-output")) {
                builder.setMainDexListOutputPath(Paths.get(args[++i], new String[0]));
                continue;
            }
            if (arg.startsWith("--")) {
                builder.getReporter().error(new StringDiagnostic("Unknown option: " + arg, CommandLineOrigin.INSTANCE));
            }
            builder.addProgramFiles(Paths.get(arg, new String[0]));
        }
    }

    private GenerateMainDexListCommand(DexItemFactory factory, AndroidApp inputApp, ImmutableList<ProguardConfigurationRule> mainDexKeepRules, StringConsumer mainDexListConsumer) {
        super(inputApp);
        this.factory = factory;
        this.mainDexKeepRules = mainDexKeepRules;
        this.mainDexListConsumer = mainDexListConsumer;
    }

    private GenerateMainDexListCommand(boolean printHelp, boolean printVersion) {
        super(printHelp, printVersion);
        this.factory = new DexItemFactory();
        this.mainDexKeepRules = ImmutableList.of();
        this.mainDexListConsumer = null;
    }

    @Override
    InternalOptions getInternalOptions() {
        InternalOptions internal = new InternalOptions(this.factory, new Reporter(new DefaultDiagnosticsHandler()));
        internal.mainDexKeepRules = this.mainDexKeepRules;
        internal.mainDexListConsumer = this.mainDexListConsumer;
        internal.minimalMainDex = internal.debug;
        internal.removeSwitchMaps = false;
        internal.inlineAccessors = false;
        internal.allowLibraryClassesToExtendProgramClasses = true;
        return internal;
    }

    public static class Builder
    extends BaseCommand.Builder<GenerateMainDexListCommand, Builder> {
        private final DexItemFactory factory = new DexItemFactory();
        private final List<ProguardConfigurationSource> mainDexRules = new ArrayList<ProguardConfigurationSource>();
        private Path mainDexListOutput = null;

        @Override
        Builder self() {
            return this;
        }

        public Builder addMainDexRulesFiles(Path ... paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRulesFiles(List<Path> paths) {
            this.guard(() -> {
                for (Path path : paths) {
                    this.mainDexRules.add(new ProguardConfigurationSourceFile(path));
                }
            });
            return this.self();
        }

        public Builder addMainDexRules(List<String> lines, Origin origin) {
            this.guard(() -> this.mainDexRules.add(new ProguardConfigurationSourceStrings(lines, Paths.get(".", new String[0]), origin)));
            return this.self();
        }

        public Path getMainDexListOutputPath() {
            return this.mainDexListOutput;
        }

        public Builder setMainDexListOutputPath(Path mainDexListOutputPath) {
            this.mainDexListOutput = mainDexListOutputPath;
            return this.self();
        }

        @Override
        protected GenerateMainDexListCommand makeCommand() {
            ImmutableList<Object> mainDexKeepRules;
            if (this.isPrintHelp() || this.isPrintVersion()) {
                return new GenerateMainDexListCommand(this.isPrintHelp(), this.isPrintVersion());
            }
            if (this.mainDexRules.isEmpty()) {
                mainDexKeepRules = ImmutableList.of();
            } else {
                ProguardConfigurationParser parser = new ProguardConfigurationParser(this.factory, this.getReporter());
                parser.parse(this.mainDexRules);
                mainDexKeepRules = parser.getConfig().getRules();
            }
            StringConsumer.FileConsumer mainDexListConsumer = this.mainDexListOutput != null ? new StringConsumer.FileConsumer(this.mainDexListOutput) : null;
            return new GenerateMainDexListCommand(this.factory, this.getAppBuilder().build(), mainDexKeepRules, mainDexListConsumer);
        }
    }
}

