/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import java.nio.ShortBuffer;
import java.util.function.BiPredicate;

public abstract class Format35c
extends Base3Format {
    public final byte A;
    public final byte C;
    public final byte D;
    public final byte E;
    public final byte F;
    public final byte G;
    public IndexedDexItem BBBB;

    Format35c(int high, BytecodeStream stream, IndexedDexItem[] map) {
        super(stream);
        this.G = (byte)(high & 0xF);
        this.A = (byte)(high >> 4 & 0xF);
        this.BBBB = map[Format35c.read16BitValue(stream)];
        short next = Format35c.read8BitValue(stream);
        this.E = (byte)(next & 0xF);
        this.F = (byte)(next >> 4 & 0xF);
        next = Format35c.read8BitValue(stream);
        this.C = (byte)(next & 0xF);
        this.D = (byte)(next >> 4 & 0xF);
    }

    protected Format35c(int A, IndexedDexItem BBBB, int C, int D, int E, int F, int G) {
        assert (0 <= A && A <= 15);
        assert (0 <= C && C <= 15);
        assert (0 <= D && D <= 15);
        assert (0 <= E && E <= 15);
        assert (0 <= F && F <= 15);
        assert (0 <= G && G <= 15);
        this.A = (byte)A;
        this.BBBB = BBBB;
        this.C = (byte)C;
        this.D = (byte)D;
        this.E = (byte)E;
        this.F = (byte)F;
        this.G = (byte)G;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.writeFirst(this.A, this.G, dest);
        this.write16BitReference(this.BBBB, dest, mapping);
        this.write16BitValue(Format35c.combineBytes(Format35c.makeByte(this.F, this.E), Format35c.makeByte(this.D, this.C)), dest);
    }

    @Override
    public final int hashCode() {
        return (this.BBBB.hashCode() << 24 | this.A << 20 | this.C << 16 | this.D << 12 | this.E << 8 | this.F << 4 | this.G) ^ this.getClass().hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format35c o = (Format35c)other;
        return o.A == this.A && o.C == this.C && o.D == this.D && o.E == this.E && o.F == this.F && o.G == this.G && o.BBBB.equals(this.BBBB);
    }

    private void appendRegisterArguments(StringBuilder builder, String separator) {
        builder.append("{ ");
        int[] values = new int[]{this.C, this.D, this.E, this.F, this.G};
        for (int i = 0; i < this.A; ++i) {
            if (i != 0) {
                builder.append(separator);
            }
            builder.append("v").append(values[i]);
        }
        builder.append(" }");
    }

    @Override
    public String toString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterArguments(builder, " ");
        builder.append(" ");
        if (naming == null) {
            builder.append(this.BBBB.toSmaliString());
        } else {
            builder.append(naming.originalNameOf(this.BBBB));
        }
        return this.formatString(builder.toString());
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterArguments(builder, ", ");
        builder.append(", ");
        builder.append(this.BBBB.toSmaliString());
        return this.formatSmaliString(builder.toString());
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.BBBB.collectIndexedItems(indexedItems);
    }

    @Override
    public boolean equals(Instruction other, BiPredicate<IndexedDexItem, IndexedDexItem> equality) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format35c o = (Format35c)other;
        return o.A == this.A && o.C == this.C && o.D == this.D && o.E == this.E && o.F == this.F && o.G == this.G && equality.test(this.BBBB, o.BBBB);
    }
}

