/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip;

import com.android.apkzlib.zip.FileUseMapEntry;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringJoiner;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class FileUseMap {
    private long size;
    @Nonnull
    private TreeSet<FileUseMapEntry<?>> map;
    @Nonnull
    private TreeSet<FileUseMapEntry<?>> free;
    private int mMinFreeSize;

    FileUseMap(long size, int minFreeSize) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0, (Object)"size < 0");
        Preconditions.checkArgument((minFreeSize >= 0 ? 1 : 0) != 0, (Object)"minFreeSize < 0");
        this.size = size;
        this.map = new TreeSet(FileUseMapEntry.COMPARE_BY_START);
        this.free = new TreeSet(FileUseMapEntry.COMPARE_BY_SIZE);
        this.mMinFreeSize = minFreeSize;
        if (size > 0L) {
            this.internalAdd(FileUseMapEntry.makeFree(0L, size));
        }
    }

    private void internalAdd(@Nonnull FileUseMapEntry<?> entry) {
        this.map.add(entry);
        if (entry.isFree()) {
            this.free.add(entry);
        }
    }

    private void internalRemove(@Nonnull FileUseMapEntry<?> entry) {
        boolean wasRemoved = this.map.remove(entry);
        Preconditions.checkState((boolean)wasRemoved, (Object)"entry not in map");
        if (entry.isFree()) {
            this.free.remove(entry);
        }
    }

    private void add(@Nonnull FileUseMapEntry<?> entry) {
        Preconditions.checkArgument((entry.getStart() < this.size ? 1 : 0) != 0, (Object)"entry.getStart() >= size");
        Preconditions.checkArgument((entry.getEnd() <= this.size ? 1 : 0) != 0, (Object)"entry.getEnd() > size");
        Preconditions.checkArgument((!entry.isFree() ? 1 : 0) != 0, (Object)"entry.isFree()");
        FileUseMapEntry<?> container = this.findContainer(entry);
        Verify.verify((boolean)container.isFree(), (String)"!container.isFree()", (Object[])new Object[0]);
        Set<FileUseMapEntry<?>> replacements = FileUseMap.split(container, entry);
        this.internalRemove(container);
        for (FileUseMapEntry<?> r : replacements) {
            this.internalAdd(r);
        }
    }

    void remove(@Nonnull FileUseMapEntry<?> entry) {
        Preconditions.checkState((boolean)this.map.contains(entry), (Object)"!map.contains(entry)");
        Preconditions.checkArgument((!entry.isFree() ? 1 : 0) != 0, (Object)"entry.isFree()");
        this.internalRemove(entry);
        FileUseMapEntry<Object> replacement = FileUseMapEntry.makeFree(entry.getStart(), entry.getEnd());
        this.internalAdd(replacement);
        this.coalesce(replacement);
    }

    <T> FileUseMapEntry<T> add(long start, long end, @Nonnull T store) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start < 0");
        Preconditions.checkArgument((end > start ? 1 : 0) != 0, (Object)"end < start");
        FileUseMapEntry<T> entry = FileUseMapEntry.makeUsed(start, end, store);
        this.add(entry);
        return entry;
    }

    @Nonnull
    private FileUseMapEntry<?> findContainer(@Nonnull FileUseMapEntry<?> entry) {
        FileUseMapEntry<?> container = this.map.floor(entry);
        Verify.verifyNotNull(container);
        Verify.verify((container.getStart() <= entry.getStart() ? 1 : 0) != 0);
        Verify.verify((container.getEnd() >= entry.getEnd() ? 1 : 0) != 0);
        return container;
    }

    @Nonnull
    private static Set<FileUseMapEntry<?>> split(@Nonnull FileUseMapEntry<?> container, @Nonnull FileUseMapEntry<?> entry) {
        Preconditions.checkArgument((boolean)container.isFree(), (Object)"!container.isFree()");
        long farStart = container.getStart();
        long start = entry.getStart();
        long end = entry.getEnd();
        long farEnd = container.getEnd();
        Verify.verify((farStart <= start ? 1 : 0) != 0, (String)"farStart > start", (Object[])new Object[0]);
        Verify.verify((start < end ? 1 : 0) != 0, (String)"start >= end", (Object[])new Object[0]);
        Verify.verify((farEnd >= end ? 1 : 0) != 0, (String)"farEnd < end", (Object[])new Object[0]);
        HashSet result = Sets.newHashSet();
        if (farStart < start) {
            result.add(FileUseMapEntry.makeFree(farStart, start));
        }
        result.add(entry);
        if (end < farEnd) {
            result.add(FileUseMapEntry.makeFree(end, farEnd));
        }
        return result;
    }

    private void coalesce(@Nonnull FileUseMapEntry<?> entry) {
        Preconditions.checkArgument((boolean)entry.isFree(), (Object)"!entry.isFree()");
        FileUseMapEntry<Object> prevToMerge = null;
        long start = entry.getStart();
        if (start > 0L) {
            prevToMerge = this.map.floor(FileUseMapEntry.makeFree(start - 1L, start));
            Verify.verifyNotNull(prevToMerge);
            if (!prevToMerge.isFree()) {
                prevToMerge = null;
            }
        }
        FileUseMapEntry<Object> nextToMerge = null;
        long end = entry.getEnd();
        if (end < this.size) {
            nextToMerge = this.map.ceiling(FileUseMapEntry.makeFree(end, end + 1L));
            Verify.verifyNotNull(nextToMerge);
            if (!nextToMerge.isFree()) {
                nextToMerge = null;
            }
        }
        if (prevToMerge == null && nextToMerge == null) {
            return;
        }
        long newStart = start;
        if (prevToMerge != null) {
            newStart = prevToMerge.getStart();
            this.internalRemove(prevToMerge);
        }
        long newEnd = end;
        if (nextToMerge != null) {
            newEnd = nextToMerge.getEnd();
            this.internalRemove(nextToMerge);
        }
        this.internalRemove(entry);
        this.internalAdd(FileUseMapEntry.makeFree(newStart, newEnd));
    }

    void truncate() {
        if (this.size == 0L) {
            return;
        }
        FileUseMapEntry<?> last = this.map.last();
        Verify.verifyNotNull(last, (String)"last == null", (Object[])new Object[0]);
        if (last.isFree()) {
            this.internalRemove(last);
            this.size = last.getStart();
        }
    }

    long size() {
        return this.size;
    }

    long usedSize() {
        if (this.size == 0L) {
            return 0L;
        }
        FileUseMapEntry<?> last = this.map.last();
        Verify.verifyNotNull(last, (String)"last == null", (Object[])new Object[0]);
        if (last.isFree()) {
            return last.getStart();
        }
        Verify.verify((last.getEnd() == this.size ? 1 : 0) != 0);
        return this.size;
    }

    void extend(long size) {
        Preconditions.checkArgument((size >= this.size ? 1 : 0) != 0, (Object)"size < size");
        if (this.size == size) {
            return;
        }
        FileUseMapEntry<Object> newBlock = FileUseMapEntry.makeFree(this.size, size);
        this.internalAdd(newBlock);
        this.size = size;
        this.coalesce(newBlock);
    }

    long locateFree(long size, long alignOffset, long align, @Nonnull PositionAlgorithm alg) {
        FileUseMapEntry<?> last;
        SortedSet<FileUseMapEntry<Object>> matches;
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"size <= 0");
        FileUseMapEntry<Object> minimumSizedEntry = FileUseMapEntry.makeFree(0L, size);
        switch (alg) {
            case BEST_FIT: {
                matches = this.free.tailSet(minimumSizedEntry);
                break;
            }
            case FIRST_FIT: {
                matches = this.map;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        FileUseMapEntry best = null;
        long bestExtraSize = 0L;
        for (FileUseMapEntry fileUseMapEntry : matches) {
            FileUseMapEntry next;
            long emptySpaceLeft;
            if (!fileUseMapEntry.isFree()) continue;
            long extraSize = align == 0L ? 0L : (align - (fileUseMapEntry.getStart() + alignOffset) % align) % align;
            if (extraSize > 0L && extraSize < (long)this.mMinFreeSize) {
                int addAlignBlocks = Ints.checkedCast((long)(((long)this.mMinFreeSize - extraSize + align - 1L) / align));
                extraSize += (long)addAlignBlocks * align;
            }
            if (fileUseMapEntry.getSize() < size + extraSize || (emptySpaceLeft = fileUseMapEntry.getSize() - (size + extraSize)) > 0L && emptySpaceLeft < (long)this.mMinFreeSize && (next = this.map.higher(fileUseMapEntry)) != null && !next.isFree() || best != null && best.getSize() < fileUseMapEntry.getSize()) continue;
            best = fileUseMapEntry;
            bestExtraSize = extraSize;
            if (alg != PositionAlgorithm.FIRST_FIT) continue;
            break;
        }
        long firstFree = this.size;
        if (best == null && !this.map.isEmpty() && (last = this.map.last()).isFree()) {
            firstFree = last.getStart();
        }
        if (best == null) {
            long extra = (align - (firstFree + alignOffset) % align) % align;
            if (extra > 0L && extra < (long)this.mMinFreeSize) {
                extra += align * (((long)this.mMinFreeSize - extra + (align - 1L)) / align);
            }
            return firstFree + extra;
        }
        return best.getStart() + bestExtraSize;
    }

    @Nonnull
    List<FileUseMapEntry<?>> getFreeAreas() {
        ArrayList freeAreas = Lists.newArrayList();
        for (FileUseMapEntry<?> area : this.map) {
            if (!area.isFree() || area.getEnd() == this.size) continue;
            freeAreas.add(area);
        }
        return freeAreas;
    }

    @Nullable
    FileUseMapEntry<?> before(@Nonnull FileUseMapEntry<?> entry) {
        Preconditions.checkNotNull(entry, (Object)"entry == null");
        return this.map.lower(entry);
    }

    @Nullable
    FileUseMapEntry<?> after(@Nonnull FileUseMapEntry<?> entry) {
        Preconditions.checkNotNull(entry, (Object)"entry == null");
        return this.map.higher(entry);
    }

    @Nullable
    FileUseMapEntry<?> at(long offset) {
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset < 0");
        Preconditions.checkArgument((offset < this.size ? 1 : 0) != 0, (Object)"offset >= size");
        FileUseMapEntry<Object> entry = this.map.floor(FileUseMapEntry.makeFree(offset, offset + 1L));
        if (entry == null) {
            return null;
        }
        Verify.verify((entry.getStart() <= offset ? 1 : 0) != 0);
        Verify.verify((entry.getEnd() > offset ? 1 : 0) != 0);
        return entry;
    }

    public String toString() {
        StringJoiner j = new StringJoiner(", ");
        this.map.stream().map(e -> e.getStart() + " - " + e.getEnd() + ": " + e.getStore()).forEach(j::add);
        return "FileUseMap[" + j.toString() + "]";
    }

    public static enum PositionAlgorithm {
        BEST_FIT,
        FIRST_FIT;

    }
}

