/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt;

import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AbstractAapt;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfo;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.ide.common.res2.CompileResourceRequest;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;

public abstract class AbstractProcessExecutionAapt
extends AbstractAapt {
    private final ProcessExecutor mProcessExecutor;
    private final ProcessOutputHandler mProcessOutputHandler;

    public AbstractProcessExecutionAapt(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler) {
        this.mProcessExecutor = processExecutor;
        this.mProcessOutputHandler = processOutputHandler;
    }

    @Override
    protected ListenableFuture<Void> makeValidatedPackage(AaptPackageConfig config) throws AaptException {
        ProcessInfoBuilder builder = this.makePackageProcessBuilder(config);
        ProcessInfo processInfo = builder.createProcess();
        ListenableFuture execResult = this.mProcessExecutor.submit(processInfo, this.mProcessOutputHandler);
        final SettableFuture result = SettableFuture.create();
        Futures.addCallback((ListenableFuture)execResult, (FutureCallback)new FutureCallback<ProcessResult>(){

            public void onSuccess(ProcessResult processResult) {
                try {
                    processResult.rethrowFailure().assertNormalExitValue();
                    result.set(null);
                }
                catch (Exception e) {
                    result.setException((Throwable)e);
                }
            }

            public void onFailure(Throwable t) {
                result.setException(t);
            }
        });
        return result;
    }

    protected abstract ProcessInfoBuilder makePackageProcessBuilder(AaptPackageConfig var1) throws AaptException;

    public ListenableFuture<File> compile(CompileResourceRequest request) throws AaptException {
        Preconditions.checkArgument((boolean)request.getInputFile().isFile(), (Object)"!file.isFile()");
        Preconditions.checkArgument((boolean)request.getOutputDirectory().isDirectory(), (Object)"!output.isDirectory()");
        final SettableFuture result = SettableFuture.create();
        final CompileInvocation compileInvocation = this.makeCompileProcessBuilder(request);
        if (compileInvocation == null) {
            result.set(null);
            return result;
        }
        ProcessInfo processInfo = compileInvocation.builder.createProcess();
        ListenableFuture execResult = this.mProcessExecutor.submit(processInfo, this.mProcessOutputHandler);
        Futures.addCallback((ListenableFuture)execResult, (FutureCallback)new FutureCallback<ProcessResult>(){

            public void onSuccess(ProcessResult processResult) {
                try {
                    processResult.rethrowFailure().assertNormalExitValue();
                    result.set((Object)compileInvocation.outputFile);
                }
                catch (Exception e) {
                    result.setException((Throwable)e);
                }
            }

            public void onFailure(Throwable t) {
                result.setException(t);
            }
        });
        return result;
    }

    protected abstract CompileInvocation makeCompileProcessBuilder(CompileResourceRequest var1) throws AaptException;

    protected static final class CompileInvocation {
        final ProcessInfoBuilder builder;
        final File outputFile;

        public CompileInvocation(ProcessInfoBuilder builder, File outputFile) {
            this.builder = builder;
            this.outputFile = outputFile;
        }
    }
}

