/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.ide.common.vectordrawable.VdPreview;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class VectorDrawableRenderer
implements ResourcePreprocessor {
    private static final int MIN_SDK_WITH_VECTOR_SUPPORT = 21;
    private static final int MIN_SDK_WITH_GRADIENT_SUPPORT = 24;
    private static final String TAG_GRADIENT = "gradient";
    private final Supplier<ILogger> mLogger;
    private final int mMinSdk;
    private final boolean mSupportLibraryIsUsed;
    private final File mOutputDir;
    private final Collection<Density> mDensities;

    public VectorDrawableRenderer(int minSdk, boolean supportLibraryIsUsed, File outputDir, Collection<Density> densities, Supplier<ILogger> loggerSupplier) {
        this.mMinSdk = minSdk;
        this.mSupportLibraryIsUsed = supportLibraryIsUsed;
        this.mOutputDir = outputDir;
        this.mDensities = densities;
        this.mLogger = loggerSupplier;
    }

    public Collection<File> getFilesToBeGenerated(File inputXmlFile) throws IOException {
        FolderConfiguration originalConfiguration = VectorDrawableRenderer.getFolderConfiguration(inputXmlFile);
        int versionQualifier = this.getVersionQualifier(inputXmlFile, originalConfiguration);
        if (versionQualifier <= 0) {
            return Collections.emptyList();
        }
        ArrayList<File> filesToBeGenerated = new ArrayList<File>();
        DensityQualifier densityQualifier = originalConfiguration.getDensityQualifier();
        boolean validDensityQualifier = ResourceQualifier.isValid((ResourceQualifier)densityQualifier);
        if (validDensityQualifier && densityQualifier.getValue() == Density.NODPI) {
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
        } else if (validDensityQualifier && densityQualifier.getValue() != Density.ANYDPI) {
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName().replace(".xml", ".png")));
            originalConfiguration.setVersionQualifier(new VersionQualifier(versionQualifier));
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
        } else {
            for (Density density : this.mDensities) {
                FolderConfiguration newConfiguration = FolderConfiguration.copyOf((FolderConfiguration)originalConfiguration);
                newConfiguration.setDensityQualifier(new DensityQualifier(density));
                filesToBeGenerated.add(new File(this.getDirectory(newConfiguration), inputXmlFile.getName().replace(".xml", ".png")));
            }
            originalConfiguration.setDensityQualifier(new DensityQualifier(Density.ANYDPI));
            originalConfiguration.setVersionQualifier(new VersionQualifier(versionQualifier));
            filesToBeGenerated.add(new File(this.getDirectory(originalConfiguration), inputXmlFile.getName()));
        }
        return filesToBeGenerated;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getVersionQualifier(File resourceFile, FolderConfiguration folderConfig) throws IOException {
        int fileVersion;
        if (this.mMinSdk >= 24) {
            return -1;
        }
        if (!VectorDrawableRenderer.isXml(resourceFile)) return -1;
        if (!VectorDrawableRenderer.isInDrawable(resourceFile)) {
            return -1;
        }
        VersionQualifier versionQualifier = folderConfig.getVersionQualifier();
        int n = fileVersion = versionQualifier == null ? 0 : versionQualifier.getVersion();
        if (fileVersion >= 24) {
            return -1;
        }
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(resourceFile));){
            XMLInputFactory factory = XMLInputFactory.newFactory();
            XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(stream);
            boolean beforeFirstTag = true;
            while (xmlStreamReader.hasNext()) {
                int event = xmlStreamReader.next();
                if (event != 1) continue;
                if (beforeFirstTag) {
                    if (!"vector".equals(xmlStreamReader.getLocalName())) {
                        int n2 = -1;
                        return n2;
                    }
                    beforeFirstTag = false;
                    continue;
                }
                if (!TAG_GRADIENT.equals(xmlStreamReader.getLocalName())) continue;
                int n3 = 24;
                return n3;
            }
            if (beforeFirstTag) return -1;
            if (this.mSupportLibraryIsUsed) return -1;
            if (this.mMinSdk >= 21) return -1;
            if (fileVersion >= 21) return -1;
            int n4 = 21;
            return n4;
        }
        catch (XMLStreamException e) {
            throw new IOException("Failed to parse resource file " + resourceFile.getAbsolutePath(), e);
        }
    }

    private File getDirectory(FolderConfiguration newConfiguration) {
        return new File(this.mOutputDir, newConfiguration.getFolderName(ResourceFolderType.DRAWABLE));
    }

    public void generateFile(File toBeGenerated, File original) throws IOException {
        Files.createParentDirs((File)toBeGenerated);
        if (VectorDrawableRenderer.isXml(toBeGenerated)) {
            Files.copy((File)original, (File)toBeGenerated);
        } else {
            String xmlContent;
            VdPreview.TargetSize imageSize;
            BufferedImage image;
            this.mLogger.get().verbose("Generating PNG: [%s] from [%s]", new Object[]{toBeGenerated.getAbsolutePath(), original.getAbsolutePath()});
            FolderConfiguration folderConfiguration = VectorDrawableRenderer.getFolderConfiguration(toBeGenerated);
            Preconditions.checkState((folderConfiguration.getDensityQualifier() != null ? 1 : 0) != 0);
            Density density = folderConfiguration.getDensityQualifier().getValue();
            assert (density != null);
            float scaleFactor = (float)density.getDpiValue() / (float)Density.MEDIUM.getDpiValue();
            if (scaleFactor <= 0.0f) {
                scaleFactor = 1.0f;
            }
            Preconditions.checkState(((image = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)(imageSize = VdPreview.TargetSize.createSizeFromScale((float)scaleFactor)), (String)(xmlContent = Files.asCharSource((File)original, (Charset)StandardCharsets.UTF_8).read()), null)) != null ? 1 : 0) != 0, (Object)"Generating the image failed.");
            ImageIO.write((RenderedImage)image, "png", toBeGenerated);
        }
    }

    private static FolderConfiguration getFolderConfiguration(File inputXmlFile) {
        String parentName = inputXmlFile.getParentFile().getName();
        FolderConfiguration originalConfiguration = FolderConfiguration.getConfigForFolder((String)parentName);
        Preconditions.checkArgument((originalConfiguration != null ? 1 : 0) != 0, (String)"Invalid resource folder name [%s].", (Object)parentName);
        return originalConfiguration;
    }

    private static boolean isInDrawable(File inputXmlFile) {
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)inputXmlFile.getParentFile().getName());
        return folderType == ResourceFolderType.DRAWABLE;
    }

    private static boolean isXml(File resourceFile) {
        return Files.getFileExtension((String)resourceFile.getName()).equals("xml");
    }
}

