/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.origin;

import java.util.ArrayList;
import java.util.List;

public abstract class Origin
implements Comparable<Origin> {
    private static final Origin ROOT = new Origin(){

        @Override
        public String part() {
            return "";
        }

        @Override
        List<String> buildParts(int size) {
            return new ArrayList<String>(size);
        }
    };
    private static final Origin UNKNOWN = new Origin(){

        @Override
        public String part() {
            return "<unknown>";
        }

        @Override
        List<String> buildParts(int size) {
            ArrayList<String> parts = new ArrayList<String>(size + 1);
            parts.add(this.part());
            return parts;
        }
    };
    private final Origin parent;

    public static Origin root() {
        return ROOT;
    }

    public static Origin unknown() {
        return UNKNOWN;
    }

    private Origin() {
        this.parent = null;
    }

    protected Origin(Origin parent) {
        assert (parent != null);
        this.parent = parent;
    }

    public abstract String part();

    public Origin parent() {
        return this.parent;
    }

    public List<String> parts() {
        return this.buildParts(0);
    }

    List<String> buildParts(int size) {
        List<String> parts = this.parent().buildParts(size + 1);
        parts.add(this.part());
        return parts;
    }

    public <T extends Origin> T getFromHierarchy(Class<T> type) {
        Origin origin = this;
        do {
            if (!type.isInstance(origin)) continue;
            return (T)origin;
        } while ((origin = origin.parent()) != null);
        return null;
    }

    public boolean equals(Object obj) {
        Origin other;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Origin)) {
            return false;
        }
        Origin self = this;
        for (other = (Origin)obj; self != null && other != null && self.part().equals(other.part()); self = self.parent(), other = other.parent()) {
        }
        return self == other;
    }

    @Override
    public int compareTo(Origin other) {
        List<String> thisParts = this.parts();
        List<String> otherParts = other.parts();
        int len = Math.min(thisParts.size(), otherParts.size());
        for (int i = 0; i < len; ++i) {
            int compare = thisParts.get(i).compareTo(otherParts.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(thisParts.size(), otherParts.size());
    }

    public int hashCode() {
        int hash = 1;
        for (String part : this.parts()) {
            hash = 31 * hash + part.hashCode();
        }
        return hash;
    }

    public String toString() {
        return String.join((CharSequence)":", this.parts());
    }
}

