/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.shaking.ProguardClassNameList;
import com.android.tools.r8.shaking.ProguardClassType;
import com.android.tools.r8.shaking.ProguardKeepRule;
import com.android.tools.r8.shaking.ProguardKeepRuleType;
import com.android.tools.r8.shaking.ProguardMemberRule;
import com.android.tools.r8.shaking.ProguardMemberType;
import com.android.tools.r8.shaking.ProguardTypeMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ProguardConfigurationUtils {
    public static ProguardKeepRule buildDefaultInitializerKeepRule(DexClass clazz) {
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setType(ProguardKeepRuleType.KEEP);
        builder.getModifiersBuilder().allowsObfuscation = true;
        builder.getModifiersBuilder().allowsOptimization = true;
        builder.getClassAccessFlags().setPublic();
        builder.setClassType(ProguardClassType.CLASS);
        ProguardClassNameList.Builder classNameListBuilder = ProguardClassNameList.builder();
        classNameListBuilder.addClassName(false, ProguardTypeMatcher.create(clazz.type));
        builder.setClassNames(classNameListBuilder.build());
        if (clazz.hasDefaultInitializer()) {
            ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
            memberRuleBuilder.setRuleType(ProguardMemberType.INIT);
            memberRuleBuilder.setName("<init>");
            memberRuleBuilder.setArguments(ImmutableList.of());
            builder.getMemberRules().add(memberRuleBuilder.build());
        }
        return builder.build();
    }

    public static ProguardKeepRule buildDefaultMethodKeepRule(DexClass clazz, DexEncodedMethod method) {
        assert (clazz.type == method.method.holder);
        ProguardKeepRule.Builder builder = ProguardKeepRule.builder();
        builder.setType(ProguardKeepRuleType.KEEP);
        builder.getModifiersBuilder().allowsObfuscation = true;
        builder.getModifiersBuilder().allowsOptimization = true;
        builder.getClassAccessFlags().setPublic();
        builder.setClassType(ProguardClassType.INTERFACE);
        builder.setClassNames(ProguardClassNameList.singletonList(ProguardTypeMatcher.create(clazz.type)));
        ProguardMemberRule.Builder memberRuleBuilder = ProguardMemberRule.builder();
        memberRuleBuilder.setRuleType(ProguardMemberType.METHOD);
        memberRuleBuilder.setName(method.method.name.toString());
        memberRuleBuilder.setTypeMatcher(ProguardTypeMatcher.create(method.method.proto.returnType));
        List<ProguardTypeMatcher> arguments = Arrays.stream(method.method.proto.parameters.values).map(ProguardTypeMatcher::create).collect(Collectors.toList());
        memberRuleBuilder.setArguments(arguments);
        builder.getMemberRules().add(memberRuleBuilder.build());
        return builder.build();
    }
}

