/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.utils.FileUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.File;

public class RelativeFile {
    private final File base;
    private final String relativePath;
    public final Type type;

    public RelativeFile(File base, File file) {
        this(base, FileUtils.toSystemIndependentPath((String)FileUtils.relativePossiblyNonExistingPath((File)file, (File)base)), Type.DIRECTORY);
        Preconditions.checkArgument((!base.equals(file) ? 1 : 0) != 0, (String)"Base must not equal file. Given: %s", (Object)base.getAbsolutePath());
    }

    public RelativeFile(File base, String relativePath) {
        this(base, relativePath, Type.JAR);
    }

    public RelativeFile(File base, String relativePath, Type type) {
        Preconditions.checkArgument((!relativePath.isEmpty() ? 1 : 0) != 0, (Object)"Relative path cannot be empty");
        this.base = base;
        this.relativePath = relativePath;
        this.type = type;
    }

    public File getBase() {
        return this.base;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.base, this.relativePath});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RelativeFile)) {
            return false;
        }
        RelativeFile other = (RelativeFile)obj;
        return Objects.equal((Object)this.base, (Object)other.base) && Objects.equal((Object)this.relativePath, (Object)other.relativePath) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("base", (Object)this.base).add("path", (Object)this.relativePath).add("type", (Object)this.type).toString();
    }

    public static enum Type {
        DIRECTORY,
        JAR;

    }
}

