/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.cf.LoadStoreHelper;
import com.android.tools.r8.cf.code.CfInstanceOf;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.PrimitiveTypeLatticeElement;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.DexBuilder;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.function.Function;

public class InstanceOf
extends Instruction {
    private final DexType type;

    public InstanceOf(Value dest, Value value, DexType type) {
        super(dest, value);
        this.type = type;
    }

    public DexType type() {
        return this.type;
    }

    public Value dest() {
        return this.outValue;
    }

    public Value value() {
        return (Value)this.inValues.get(0);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        builder.add((Instruction)this, new com.android.tools.r8.code.InstanceOf(dest, value, this.type));
    }

    @Override
    public int maxInValueRegister() {
        return 15;
    }

    @Override
    public int maxOutValueRegister() {
        return 15;
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.asInstanceOf().type == this.type;
    }

    @Override
    public int compareNonValueParts(Instruction other) {
        return this.type.slowCompareTo(other.asInstanceOf().type);
    }

    @Override
    public boolean isInstanceOf() {
        return true;
    }

    @Override
    public InstanceOf asInstanceOf() {
        return this;
    }

    @Override
    public Inliner.Constraint inliningConstraint(Enqueuer.AppInfoWithLiveness info, DexType invocationContext) {
        return Inliner.Constraint.classIsVisible(invocationContext, this.type, info);
    }

    @Override
    public TypeLatticeElement evaluate(AppInfo appInfo, Function<Value, TypeLatticeElement> getLatticeElement) {
        return PrimitiveTypeLatticeElement.getInstance();
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
        helper.storeOutValue(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfInstanceOf(this.type));
    }
}

