/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dexsplitter;

import com.android.tools.r8.CompilationException;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DexSplitterHelper;
import com.android.tools.r8.utils.OptionsParsing;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class DexSplitter {
    private static final String DEFAULT_OUTPUT_ARCHIVE_FILENAME = "split";
    private static final boolean PRINT_ARGS = false;

    private static Options parseArguments(String[] args) throws IOException {
        Options options = new Options();
        OptionsParsing.ParseContext context = new OptionsParsing.ParseContext(args);
        while (context.head() != null) {
            List<String> input = OptionsParsing.tryParseMulti(context, "--input");
            if (input != null) {
                options.inputArchives.addAll(input);
                continue;
            }
            String output = OptionsParsing.tryParseSingle(context, "--output", "-o");
            if (output != null) {
                options.splitBaseName = output;
                continue;
            }
            String featureSplit = OptionsParsing.tryParseSingle(context, "--feature-splits", null);
            if (featureSplit != null) {
                options.featureSplitMapping = featureSplit;
                continue;
            }
            throw new RuntimeException(String.format("Unknown options: '%s'.", context.head()));
        }
        return options;
    }

    public static void run(String[] args) throws CompilationFailedException, IOException, CompilationException, ExecutionException {
        Options options = DexSplitter.parseArguments(args);
        if (options.inputArchives.isEmpty()) {
            throw new RuntimeException("Need at least one --input");
        }
        if (options.featureSplitMapping == null) {
            throw new RuntimeException("You must supply a feature split mapping");
        }
        D8Command.Builder builder = D8Command.builder();
        for (String s : options.inputArchives) {
            builder.addProgramFiles(Paths.get(s, new String[0]));
        }
        builder.setProgramConsumer(DexIndexedConsumer.emptyConsumer());
        DexSplitterHelper.run((D8Command)builder.build(), options.featureSplitMapping, options.splitBaseName);
    }

    public static void main(String[] args) {
        try {
            DexSplitter.run(args);
        }
        catch (CompilationException | CompilationFailedException | IOException | ExecutionException e) {
            System.err.println("Splitting failed: " + e.getMessage());
            System.exit(1);
        }
    }

    private static void printArgs(String[] args) {
        System.err.printf("r8.DexSplitter", new Object[0]);
        for (String s : args) {
            System.err.printf(" %s", s);
        }
        System.err.println("");
    }

    private static class Options {
        List<String> inputArchives = new ArrayList<String>();
        String splitBaseName = "split";
        String featureSplitMapping;

        private Options() {
        }
    }
}

