/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.analysis.type;

import com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.Bottom;
import com.android.tools.r8.ir.analysis.type.Top;
import com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class TypeAnalysis
implements TypeEnvironment {
    private final AppInfo appInfo;
    private final DexEncodedMethod encodedMethod;
    private final Deque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
    private final Map<Value, TypeLatticeElement> typeMap = Maps.newHashMap();
    private final Map<Value, Set<BasicBlock>> users = Maps.newHashMap();
    private static final TypeEnvironment DEFAULT_ENVIRONMENT = new TypeEnvironment(){

        @Override
        public TypeLatticeElement getLatticeElement(Value value) {
            return Top.getInstance();
        }

        @Override
        public DexType getObjectType(Value value) {
            return null;
        }

        @Override
        public DexType getRefinedReceiverType(InvokeMethodWithReceiver invoke) {
            return invoke.getInvokedMethod().holder;
        }
    };

    public TypeAnalysis(AppInfo appInfo, DexEncodedMethod encodedMethod, IRCode code) {
        this.appInfo = appInfo;
        this.encodedMethod = encodedMethod;
        this.updateBlocks(code.topologicallySortedBlocks());
    }

    public void updateBlocks(List<BasicBlock> blocks) {
        assert (this.worklist.isEmpty());
        this.worklist.addAll(blocks);
        while (!this.worklist.isEmpty()) {
            this.processBasicBlock(this.worklist.poll());
        }
    }

    private void addToWorklist(BasicBlock block) {
        if (!this.worklist.contains(block)) {
            this.worklist.add(block);
        }
    }

    private void processBasicBlock(BasicBlock block) {
        int argumentsSeen = this.encodedMethod.accessFlags.isStatic() ? 0 : -1;
        for (Instruction instruction : block.getInstructions()) {
            TypeLatticeElement current;
            TypeLatticeElement derived = Bottom.getInstance();
            Value outValue = instruction.outValue();
            if (instruction instanceof Argument) {
                if (argumentsSeen < 0) {
                    derived = TypeLatticeElement.fromDexType(this.encodedMethod.method.holder, false);
                } else {
                    DexType argType = this.encodedMethod.method.proto.parameters.values[argumentsSeen];
                    derived = TypeLatticeElement.fromDexType(argType, true);
                }
                ++argumentsSeen;
            } else {
                instruction.inValues().forEach((? super T v) -> this.registerAsUserOfValue((Value)v, block, Sets.newIdentityHashSet()));
                if (outValue != null) {
                    derived = instruction.evaluate(this.appInfo, this::getLatticeElement);
                }
            }
            if (outValue == null || (current = this.getLatticeElement(outValue)).equals(derived)) continue;
            this.updateTypeOfValue(outValue, derived);
        }
    }

    private void registerAsUserOfValue(Value value, BasicBlock block, Set<Value> seenPhis) {
        if (value.isPhi() && seenPhis.add(value)) {
            for (Value operand : value.asPhi().getOperands()) {
                this.registerAsUserOfValue(operand, block, seenPhis);
            }
        } else {
            this.users.computeIfAbsent(value, k -> Sets.newIdentityHashSet()).add(block);
        }
    }

    private void updateTypeOfValue(Value value, TypeLatticeElement type) {
        this.setLatticeElement(value, type);
        this.users.getOrDefault(value, Collections.emptySet()).forEach(this::addToWorklist);
        for (Phi phi : value.uniquePhiUsers()) {
            TypeLatticeElement phiType = this.computePhiType(phi);
            if (this.getLatticeElement(phi).equals(phiType)) continue;
            this.updateTypeOfValue(phi, phiType);
        }
    }

    private TypeLatticeElement computePhiType(Phi phi) {
        return TypeLatticeElement.join(this.appInfo, phi.getOperands().stream().map(this::getLatticeElement));
    }

    private void setLatticeElement(Value value, TypeLatticeElement type) {
        this.typeMap.put(value, type);
    }

    @Override
    public TypeLatticeElement getLatticeElement(Value value) {
        return this.typeMap.getOrDefault(value, Bottom.getInstance());
    }

    @Override
    public DexType getObjectType(Value value) {
        DexType type = this.appInfo.dexItemFactory.objectType;
        TypeLatticeElement l = this.getLatticeElement(value);
        if (l.isClassTypeLatticeElement()) {
            type = l.asClassTypeLatticeElement().getClassType();
        } else if (l.isArrayTypeLatticeElement()) {
            type = l.asArrayTypeLatticeElement().getArrayType();
        }
        return type;
    }

    @Override
    public DexType getRefinedReceiverType(InvokeMethodWithReceiver invoke) {
        DexType refinedType;
        DexType receiverType = invoke.getInvokedMethod().getHolder();
        TypeLatticeElement lattice = this.getLatticeElement(invoke.getReceiver());
        if (lattice.isClassTypeLatticeElement() && (refinedType = lattice.asClassTypeLatticeElement().getClassType()).isSubtypeOf(receiverType, this.appInfo)) {
            return refinedType;
        }
        return receiverType;
    }

    public static TypeEnvironment getDefaultTypeEnvironment() {
        return DEFAULT_ENVIRONMENT;
    }

    @VisibleForTesting
    void forEach(BiConsumer<Value, TypeLatticeElement> consumer) {
        this.typeMap.forEach(consumer);
    }
}

