/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging;

import com.android.builder.files.RelativeFile;
import com.android.builder.internal.packaging.DexFileNameSupplier;
import com.android.builder.internal.packaging.PackagedFileUpdate;
import com.android.ide.common.res2.FileStatus;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

class DexIncrementalRenameManager
implements Closeable {
    private static final String STATE_FILE = "dex-renamer-state.txt";
    private static final String BASE_KEY_PREFIX = "base.";
    private static final String RELATIVE_PATH_PREFIX = "path.";
    private static final String RENAMED_KEY_PREFIX = "renamed.";
    private final BiMap<RelativeFile, String> mNameMap;
    private final File mIncrementalDir;
    private boolean mClosed;

    DexIncrementalRenameManager(File incrementalDir) throws IOException {
        Preconditions.checkArgument((boolean)incrementalDir.isDirectory(), (Object)"!incrementalDir.isDirectory()");
        this.mNameMap = HashBiMap.create();
        this.mIncrementalDir = incrementalDir;
        this.mClosed = false;
        this.readState();
    }

    private void readState() throws IOException {
        File stateFile = new File(this.mIncrementalDir, STATE_FILE);
        if (!stateFile.isFile()) {
            return;
        }
        Properties props = new Properties();
        try (Closer closer = Closer.create();){
            props.load((Reader)closer.register((Closeable)new FileReader(stateFile)));
        }
        int i = 0;
        while (true) {
            String baseKey = BASE_KEY_PREFIX + i;
            String relativePathKey = RELATIVE_PATH_PREFIX + i;
            String renamedKey = RENAMED_KEY_PREFIX + i;
            String base = props.getProperty(baseKey);
            String relativePath = props.getProperty(relativePathKey);
            String rename = props.getProperty(renamedKey);
            if (base == null || relativePath == null || rename == null) break;
            RelativeFile rf = new RelativeFile(new File(base), relativePath, RelativeFile.Type.DIRECTORY);
            this.mNameMap.put((Object)rf, (Object)rename);
            ++i;
        }
    }

    private void writeState() throws IOException {
        File stateFile = new File(this.mIncrementalDir, STATE_FILE);
        Properties props = new Properties();
        int currIdx = 0;
        for (Map.Entry entry : this.mNameMap.entrySet()) {
            props.put(BASE_KEY_PREFIX + currIdx, ((RelativeFile)entry.getKey()).getBase().getAbsolutePath());
            props.put(RELATIVE_PATH_PREFIX + currIdx, ((RelativeFile)entry.getKey()).getRelativePath());
            props.put(RENAMED_KEY_PREFIX + currIdx, entry.getValue());
            ++currIdx;
        }
        try (Closer closer = Closer.create();){
            props.store((Writer)closer.register((Closeable)new FileWriter(stateFile)), null);
        }
    }

    Set<PackagedFileUpdate> update(ImmutableMap<RelativeFile, FileStatus> files) throws IOException {
        Deque newFiles = files.entrySet().stream().filter(e -> e.getValue() == FileStatus.NEW).map(Map.Entry::getKey).sorted(Comparator.comparing(RelativeFile::getRelativePath, new DexNameComparator())).collect(Collectors.toCollection(LinkedList::new));
        DexFileNameSupplier supplier = new DexFileNameSupplier();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        for (int i = 0; i < this.mNameMap.size(); ++i) {
            String nameInDex = supplier.get();
            RelativeFile rf = (RelativeFile)this.mNameMap.inverse().get((Object)nameInDex);
            Verify.verify((rf != null ? 1 : 0) != 0, (String)("No file known for: " + nameInDex), (Object[])new Object[0]);
            if (nameInDex.equals("classes.dex") && !DexIncrementalRenameManager.getOsIndependentFileName(rf).equals("classes.dex") && !newFiles.isEmpty() && DexIncrementalRenameManager.getOsIndependentFileName((RelativeFile)newFiles.getFirst()).equals("classes.dex")) {
                Verify.verify((i == 0 ? 1 : 0) != 0);
                buckets.add(new Bucket((RelativeFile)newFiles.removeFirst(), nameInDex, BucketAction.UPDATE));
                newFiles.add(rf);
                continue;
            }
            Bucket newBucket = new Bucket(rf, nameInDex, BucketAction.NOTHING);
            FileStatus status = (FileStatus)files.get((Object)rf);
            if (status == FileStatus.REMOVED) {
                if (newFiles.isEmpty()) {
                    newBucket.file = rf;
                    newBucket.action = BucketAction.DELETE;
                } else {
                    newBucket.file = (RelativeFile)newFiles.removeFirst();
                    newBucket.action = BucketAction.UPDATE;
                }
            } else if (status == FileStatus.CHANGED) {
                newBucket.file = rf;
                newBucket.action = BucketAction.UPDATE;
            }
            buckets.add(newBucket);
        }
        if (newFiles.isEmpty()) {
            int emp = 0;
            int use2 = buckets.size() - 1;
            while (true) {
                if (emp < buckets.size() && ((Bucket)buckets.get((int)emp)).action != BucketAction.DELETE) {
                    ++emp;
                    continue;
                }
                while (use2 >= 0 && ((Bucket)buckets.get((int)use2)).action == BucketAction.DELETE) {
                    --use2;
                }
                if (emp <= use2) {
                    ((Bucket)buckets.get((int)emp)).file = ((Bucket)buckets.get((int)use2)).file;
                    ((Bucket)buckets.get((int)emp)).action = BucketAction.UPDATE;
                    ((Bucket)buckets.get((int)use2)).action = BucketAction.DELETE;
                    ++emp;
                    --use2;
                    continue;
                }
                break;
            }
        } else {
            newFiles.forEach(nf -> buckets.add(new Bucket((RelativeFile)nf, supplier.get(), BucketAction.CREATE)));
        }
        this.mNameMap.clear();
        return buckets.stream().peek(b -> {
            if (b.action != BucketAction.DELETE) {
                this.mNameMap.put((Object)b.file, (Object)b.nameInDex);
            }
        }).map(b -> {
            switch (b.action) {
                case CREATE: {
                    return new PackagedFileUpdate(b.file, b.nameInDex, FileStatus.NEW);
                }
                case DELETE: {
                    return new PackagedFileUpdate(b.file, b.nameInDex, FileStatus.REMOVED);
                }
                case NOTHING: {
                    return null;
                }
                case UPDATE: {
                    return new PackagedFileUpdate(b.file, b.nameInDex, FileStatus.CHANGED);
                }
            }
            throw new AssertionError();
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        this.mClosed = true;
        this.writeState();
    }

    private static String getOsIndependentFileName(RelativeFile file) {
        String[] pathSplit = file.getRelativePath().split("/");
        return pathSplit[pathSplit.length - 1];
    }

    private static class DexNameComparator
    implements Comparator<String> {
        private DexNameComparator() {
        }

        @Override
        public int compare(String f1, String f2) {
            if (f1.equals("classes.dex")) {
                return -1;
            }
            if (f2.equals("classes.dex")) {
                return 1;
            }
            return f1.compareTo(f2);
        }
    }

    private static class Bucket {
        RelativeFile file;
        String nameInDex;
        BucketAction action;

        Bucket(RelativeFile file, String nameInDex, BucketAction action) {
            this.file = file;
            this.nameInDex = nameInDex;
            this.action = action;
        }
    }

    private static enum BucketAction {
        NOTHING,
        UPDATE,
        DELETE,
        CREATE;

    }
}

