/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.files.RelativeFile;
import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.ide.common.res2.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.android.tools.build.apkzlib.zip.StoredEntry;
import com.android.tools.build.apkzlib.zip.ZFile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LazyIncrementalFileMergerInput
implements IncrementalFileMergerInput {
    private final String name;
    final CachedSupplier<ImmutableMap<RelativeFile, FileStatus>> updates;
    final CachedSupplier<ImmutableMap<String, RelativeFile>> updatePaths;
    final CachedSupplier<ImmutableMap<String, RelativeFile>> filePaths;
    final CachedSupplier<ImmutableSet<File>> zips;
    Map<File, ZFile> openZips;

    public LazyIncrementalFileMergerInput(String name, CachedSupplier<ImmutableMap<RelativeFile, FileStatus>> updates, CachedSupplier<ImmutableSet<RelativeFile>> files) {
        this.name = name;
        this.updates = updates;
        this.updatePaths = new CachedSupplier(() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (Map.Entry e : ((ImmutableMap)updates.get()).entrySet()) {
                pathsBuilder.put((Object)((RelativeFile)e.getKey()).getRelativePath(), e.getKey());
            }
            return pathsBuilder.build();
        });
        this.filePaths = new CachedSupplier(() -> {
            ImmutableMap.Builder pathsBuilder = ImmutableMap.builder();
            for (RelativeFile rf : (ImmutableSet)files.get()) {
                pathsBuilder.put((Object)rf.getRelativePath(), (Object)rf);
            }
            return pathsBuilder.build();
        });
        this.zips = new CachedSupplier(() -> {
            HashSet<File> zips = new HashSet<File>();
            HashSet<File> known = new HashSet<File>();
            for (RelativeFile rf : (ImmutableSet)files.get()) {
                if (known.contains(rf.getBase())) continue;
                known.add(rf.getBase());
                if (!rf.getBase().isFile()) continue;
                zips.add(rf.getBase());
            }
            return ImmutableSet.copyOf(zips);
        });
        this.openZips = null;
    }

    @Override
    public ImmutableSet<String> getUpdatedPaths() {
        return ((ImmutableMap)this.updatePaths.get()).keySet();
    }

    @Override
    public ImmutableSet<String> getAllPaths() {
        return ((ImmutableMap)this.filePaths.get()).keySet();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FileStatus getFileStatus(String path) {
        RelativeFile rf = (RelativeFile)((ImmutableMap)this.updatePaths.get()).get((Object)path);
        if (rf == null) {
            return null;
        }
        return (FileStatus)((ImmutableMap)this.updates.get()).get((Object)rf);
    }

    @Override
    public InputStream openPath(String path) {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        RelativeFile rf = (RelativeFile)((ImmutableMap)this.filePaths.get()).get((Object)path);
        Preconditions.checkState((rf != null ? 1 : 0) != 0, (String)"Unknown file: %s", (Object)path);
        if (((ImmutableSet)this.zips.get()).contains((Object)rf.getBase())) {
            ZFile zf = this.openZips.get(rf.getBase());
            Preconditions.checkState((zf != null ? 1 : 0) != 0, (String)"Unknown base: %s", (Object)rf.getBase().getName());
            StoredEntry entry = zf.get(path);
            Preconditions.checkState((entry != null ? 1 : 0) != 0, (String)"Unknown path %s in zip file %s", (Object)path, (Object)zf.getFile().getAbsolutePath());
            try {
                return entry.open();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            return new FileInputStream(new File(rf.getBase(), rf.getRelativePath()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void open() {
        Preconditions.checkState((this.openZips == null ? 1 : 0) != 0, (Object)"input already open");
        HashMap<File, ZFile> open = new HashMap<File, ZFile>();
        UncheckedIOException failure = null;
        for (File f : (ImmutableSet)this.zips.get()) {
            try {
                ZFile zf = new ZFile(f);
                open.put(f, zf);
            }
            catch (IOException e) {
                failure = new UncheckedIOException(e);
                break;
            }
        }
        if (failure != null) {
            for (ZFile zf : open.values()) {
                try {
                    zf.close();
                }
                catch (IOException e) {
                    failure.addSuppressed(e);
                }
            }
            throw failure;
        }
        this.openZips = open;
    }

    @Override
    public void close() {
        Preconditions.checkState((this.openZips != null ? 1 : 0) != 0, (Object)"input not open");
        try (Closer closer = Closer.create();){
            for (ZFile zf : this.openZips.values()) {
                closer.register((Closeable)zf);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.openZips = null;
        }
    }
}

