/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

public class FeatureClassMapping {
    HashMap<String, String> parsedRules = new HashMap();
    HashSet<FeaturePredicate> mappings = new HashSet();
    Path mappingFile;
    static final String COMMENT = "#";
    static final String SEPARATOR = ":";

    public static FeatureClassMapping fromSpecification(Path file) throws FeatureMappingException, IOException {
        FeatureClassMapping mapping = new FeatureClassMapping();
        List<String> lines = FileUtils.readAllLines(file);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            mapping.parseAndAdd(line, i);
        }
        return mapping;
    }

    public static FeatureClassMapping fromJarFiles(List<String> jarFiles) throws FeatureMappingException, IOException {
        FeatureClassMapping mapping = new FeatureClassMapping();
        for (String jar : jarFiles) {
            Path jarPath = Paths.get(jar, new String[0]);
            String featureName = jarPath.getFileName().toString();
            if (featureName.endsWith(".jar") || featureName.endsWith(".zip")) {
                featureName = featureName.substring(0, featureName.length() - 4);
            }
            ArchiveClassFileProvider provider = new ArchiveClassFileProvider(jarPath);
            for (String javaDescriptor : provider.getClassDescriptors()) {
                String javaType = DescriptorUtils.descriptorToJavaType(javaDescriptor);
                mapping.addMapping(javaType, featureName);
            }
        }
        return mapping;
    }

    private FeatureClassMapping() {
    }

    public void addMapping(String clazz, String feature) throws FeatureMappingException {
        this.addRule(clazz, feature, 0);
    }

    FeatureClassMapping(List<String> lines) throws FeatureMappingException {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this.parseAndAdd(line, i);
        }
    }

    public String featureForClass(String clazz) throws FeatureMappingException {
        FeaturePredicate bestMatch = null;
        for (FeaturePredicate mapping : this.mappings) {
            if (!mapping.match(clazz) || bestMatch != null && bestMatch.predicate.length() >= mapping.predicate.length()) continue;
            bestMatch = mapping;
        }
        if (bestMatch == null) {
            throw new FeatureMappingException("Class: " + clazz + " is not mapped to any feature");
        }
        return bestMatch.feature;
    }

    private void parseAndAdd(String line, int lineNumber) throws FeatureMappingException {
        String[] values;
        if (line.startsWith(COMMENT)) {
            return;
        }
        if (line.isEmpty()) {
            return;
        }
        if (!line.contains(SEPARATOR)) {
            this.error("Mapping lines must contain a :", lineNumber);
        }
        if ((values = line.split(SEPARATOR)).length != 2) {
            this.error("Mapping lines can only contain one :", lineNumber);
        }
        String predicate = values[0];
        String feature = values[1];
        this.addRule(predicate, feature, lineNumber);
    }

    private void addRule(String predicate, String feature, int lineNumber) throws FeatureMappingException {
        if (this.parsedRules.containsKey(predicate)) {
            if (!this.parsedRules.get(predicate).equals(feature)) {
                this.error("Redefinition of predicate " + predicate + "not allowed", lineNumber);
            }
            return;
        }
        this.parsedRules.put(predicate, feature);
        FeaturePredicate featurePredicate = new FeaturePredicate(predicate, feature);
        this.mappings.add(featurePredicate);
    }

    private void error(String error, int line) throws FeatureMappingException {
        throw new FeatureMappingException("Invalid mappings specification: " + error + "\n in file " + this.mappingFile + SEPARATOR + line);
    }

    private static class FeaturePredicate {
        private static Pattern identifier = Pattern.compile("[A-Za-z_\\-][A-Za-z0-9_$\\-]*");
        final String predicate;
        final String feature;
        final boolean isWildcard;

        FeaturePredicate(String predicate, String feature) throws FeatureMappingException {
            this.isWildcard = predicate.endsWith(".*");
            this.predicate = this.isWildcard ? predicate.substring(0, predicate.length() - 3) : predicate;
            if (!DescriptorUtils.isValidJavaType(this.predicate)) {
                throw new FeatureMappingException(this.predicate + " is not a valid identifier");
            }
            this.feature = feature;
        }

        boolean match(String className) {
            if (this.isWildcard) {
                return className.startsWith(this.predicate);
            }
            return className.startsWith(this.predicate);
        }
    }

    public static class FeatureMappingException
    extends Exception {
        FeatureMappingException(String message) {
            super(message);
        }
    }
}

