/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Format21h;
import com.android.tools.r8.ir.code.SingleConstant;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;

public class ConstHigh16
extends Format21h
implements SingleConstant {
    public static final int OPCODE = 21;
    public static final String NAME = "ConstHigh16";
    public static final String SMALI_NAME = "const/high16";

    ConstHigh16(int high, BytecodeStream stream) {
        super(high, stream);
    }

    public ConstHigh16(int register, int constantHighBits) {
        super(register, constantHighBits);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getSmaliName() {
        return SMALI_NAME;
    }

    @Override
    public int getOpcode() {
        return 21;
    }

    @Override
    public int decodedValue() {
        return this.BBBB << 16;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", " + StringUtils.hexString(this.decodedValue(), 8) + " (" + this.decodedValue() + ")");
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", " + StringUtils.hexString(this.decodedValue(), 8) + "  # " + this.decodedValue());
    }

    @Override
    public void buildIR(IRBuilder builder) {
        int value = this.decodedValue();
        ValueType type = value == 0 ? ValueType.INT_OR_FLOAT_OR_NULL : ValueType.INT_OR_FLOAT;
        builder.addConst(type, this.AA, value);
    }
}

