/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.D8DiagnosticsHandler;
import com.android.builder.dexing.DexArchive;
import com.android.builder.dexing.DexArchiveEntry;
import com.android.builder.dexing.DexArchiveMerger;
import com.android.builder.dexing.DexArchiveMergerException;
import com.android.builder.dexing.DexArchives;
import com.android.builder.dexing.DexingType;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.MessageReceiver;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.OutputMode;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

final class D8DexArchiveMerger
implements DexArchiveMerger {
    private static final Logger LOGGER = Logger.getLogger(D8DexArchiveMerger.class.getName());
    private static final String ERROR_MULTIDEX = "Cannot fit requested classes in a single dex file";
    private static final String ERROR_DUPLICATE = "Program type already present";
    private final int minSdkVersion;
    private final CompilationMode compilationMode;
    private final MessageReceiver messageReceiver;
    private volatile boolean hintForMultidex = false;

    public D8DexArchiveMerger(@Nonnull MessageReceiver messageReceiver, int minSdkVersion, CompilationMode compilationMode) {
        this.minSdkVersion = minSdkVersion;
        this.compilationMode = compilationMode;
        this.messageReceiver = messageReceiver;
    }

    @Override
    public void mergeDexArchives(Iterable<Path> inputs, Path outputDir, Path mainDexClasses, DexingType dexingType) throws DexArchiveMergerException {
        LOGGER.log(Level.INFO, "Merging to '" + outputDir.toAbsolutePath().toString() + "' with D8 from " + Streams.stream(inputs).map(path -> path.toAbsolutePath().toString()).collect(Collectors.joining(", ")));
        if (Iterables.isEmpty(inputs)) {
            return;
        }
        InterceptingDiagnosticsHandler d8DiagnosticsHandler = new InterceptingDiagnosticsHandler();
        D8Command.Builder builder = D8Command.builder(d8DiagnosticsHandler);
        builder.setDisableDesugaring(true);
        for (Path input : inputs) {
            try {
                DexArchive archive = DexArchives.fromInput(input);
                Throwable throwable = null;
                try {
                    for (DexArchiveEntry dexArchiveEntry : archive.getFiles()) {
                        builder.addDexProgramData(dexArchiveEntry.getDexFileContent(), D8DiagnosticsHandler.getOrigin(dexArchiveEntry));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (archive == null) continue;
                    if (throwable != null) {
                        try {
                            archive.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    archive.close();
                }
            }
            catch (IOException e) {
                throw this.getExceptionToRethrow(e, input, d8DiagnosticsHandler);
            }
        }
        try {
            if (mainDexClasses != null) {
                builder.addMainDexListFiles(mainDexClasses);
            }
            ((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)builder.setMinApiLevel(this.minSdkVersion)).setMode(this.compilationMode)).setOutput(outputDir, OutputMode.DexIndexed)).setDisableDesugaring(true)).setIntermediate(false);
            D8.run((D8Command)builder.build(), ForkJoinPool.commonPool());
        }
        catch (CompilationFailedException e) {
            throw this.getExceptionToRethrow(e, inputs, d8DiagnosticsHandler);
        }
    }

    private DexArchiveMergerException getExceptionToRethrow(Throwable t, Iterable<Path> inputs, D8DiagnosticsHandler d8DiagnosticsHandler) {
        StringBuilder msg = new StringBuilder("Error while merging dex archives: ");
        msg.append(Joiner.on((String)", ").join(inputs));
        for (String hint : d8DiagnosticsHandler.getPendingHints()) {
            msg.append(System.lineSeparator());
            msg.append(hint);
        }
        return new DexArchiveMergerException(msg.toString(), t);
    }

    private class InterceptingDiagnosticsHandler
    extends D8DiagnosticsHandler {
        public InterceptingDiagnosticsHandler() {
            super(D8DexArchiveMerger.this.messageReceiver);
        }

        @Override
        protected Message convertToMessage(Message.Kind kind, Diagnostic diagnostic) {
            if (diagnostic.getDiagnosticMessage().startsWith(D8DexArchiveMerger.ERROR_MULTIDEX)) {
                this.addHint("The number of method references in a .dex file cannot exceed 64K.\nLearn how to resolve this issue at https://developer.android.com/tools/building/multidex.html");
            }
            if (diagnostic.getDiagnosticMessage().startsWith(D8DexArchiveMerger.ERROR_DUPLICATE)) {
                this.addHint(diagnostic.getDiagnosticMessage());
            }
            return super.convertToMessage(kind, diagnostic);
        }
    }
}

