/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.kotlin.KotlinClass;
import com.android.tools.r8.kotlin.KotlinClassFacade;
import com.android.tools.r8.kotlin.KotlinClassPart;
import com.android.tools.r8.kotlin.KotlinFile;
import com.android.tools.r8.kotlin.KotlinInfo;
import com.android.tools.r8.kotlin.KotlinSyntheticClass;
import com.android.tools.r8.utils.StringDiagnostic;
import java.util.Set;

public final class Kotlin {
    public final DexItemFactory factory;
    public final Functional functional;
    public final Intrinsics intrinsics;
    public final Metadata metadata;

    public Kotlin(DexItemFactory factory) {
        this.factory = factory;
        this.functional = new Functional();
        this.intrinsics = new Intrinsics();
        this.metadata = new Metadata();
    }

    public KotlinInfo getKotlinInfo(DexClass clazz, DiagnosticsHandler reporter) {
        if (clazz.annotations.isEmpty()) {
            return null;
        }
        DexAnnotation meta = clazz.annotations.getFirstMatching(this.metadata.kotlinMetadataType);
        if (meta != null) {
            try {
                return this.createKotlinInfo(clazz, meta);
            }
            catch (MetadataError e) {
                reporter.warning(new StringDiagnostic("Class " + clazz.type.toSourceString() + " has malformed kotlin.Metadata: " + e.getMessage()));
            }
        }
        return null;
    }

    private KotlinInfo createKotlinInfo(DexClass clazz, DexAnnotation meta) {
        DexAnnotationElement kindElement = this.getAnnotationElement(meta, this.metadata.elementNameK);
        if (kindElement == null) {
            throw new MetadataError("element 'k' is missing");
        }
        DexValue value = kindElement.value;
        if (!(value instanceof DexValue.DexValueInt)) {
            throw new MetadataError("invalid 'k' value: " + value.toSourceString());
        }
        DexValue.DexValueInt intValue = (DexValue.DexValueInt)value;
        switch (intValue.value) {
            case 1: {
                return new KotlinClass();
            }
            case 2: {
                return new KotlinFile();
            }
            case 3: {
                return this.createSyntheticClass(clazz, meta);
            }
            case 4: {
                return new KotlinClassFacade();
            }
            case 5: {
                return new KotlinClassPart();
            }
        }
        throw new MetadataError("unsupported 'k' value: " + value.toSourceString());
    }

    private KotlinSyntheticClass createSyntheticClass(DexClass clazz, DexAnnotation meta) {
        if (this.isKotlinStyleLambda(clazz)) {
            return new KotlinSyntheticClass(KotlinSyntheticClass.Flavour.KotlinStyleLambda);
        }
        if (this.isJavaStyleLambda(clazz, meta)) {
            return new KotlinSyntheticClass(KotlinSyntheticClass.Flavour.JavaStyleLambda);
        }
        return new KotlinSyntheticClass(KotlinSyntheticClass.Flavour.Unclassified);
    }

    private boolean isKotlinStyleLambda(DexClass clazz) {
        return clazz.superType == this.functional.lambdaType;
    }

    private boolean isJavaStyleLambda(DexClass clazz, DexAnnotation meta) {
        assert (!this.isKotlinStyleLambda(clazz));
        return clazz.superType == this.factory.objectType && clazz.interfaces.size() == 1 && this.isAnnotationElementNotEmpty(meta, this.metadata.elementNameD1);
    }

    private DexAnnotationElement getAnnotationElement(DexAnnotation annotation, DexString name) {
        for (DexAnnotationElement element : annotation.annotation.elements) {
            if (element.name != name) continue;
            return element;
        }
        return null;
    }

    private boolean isAnnotationElementNotEmpty(DexAnnotation annotation, DexString name) {
        for (DexAnnotationElement element : annotation.annotation.elements) {
            if (element.name != name || !(element.value instanceof DexValue.DexValueArray)) continue;
            DexValue[] values = ((DexValue.DexValueArray)element.value).getValues();
            if (values.length == 1 && values[0] instanceof DexValue.DexValueString) {
                return true;
            }
            assert (false);
        }
        return false;
    }

    private static class MetadataError
    extends RuntimeException {
        MetadataError(String cause) {
            super(cause);
        }
    }

    public final class Intrinsics {
        public final DexType type;
        public final DexMethod throwParameterIsNullException;
        public final DexMethod throwNpe;

        public Intrinsics() {
            this.type = Kotlin.this.factory.createType("Lkotlin/jvm/internal/Intrinsics;");
            this.throwParameterIsNullException = Kotlin.this.factory.createMethod(this.type, Kotlin.this.factory.createProto(Kotlin.this.factory.voidType, Kotlin.this.factory.stringType), "throwParameterIsNullException");
            this.throwNpe = Kotlin.this.factory.createMethod(this.type, Kotlin.this.factory.createProto(Kotlin.this.factory.voidType, new DexType[0]), "throwNpe");
        }
    }

    public final class Metadata {
        public final DexType kotlinMetadataType;
        public final DexString elementNameK;
        public final DexString elementNameD1;
        public final DexString elementNameD2;

        public Metadata() {
            this.kotlinMetadataType = Kotlin.this.factory.createType("Lkotlin/Metadata;");
            this.elementNameK = Kotlin.this.factory.createString("k");
            this.elementNameD1 = Kotlin.this.factory.createString("d1");
            this.elementNameD2 = Kotlin.this.factory.createString("d2");
        }
    }

    public final class Functional {
        private final Set<DexType> functions = Sets.newIdentityHashSet();
        public final DexString kotlinStyleLambdaInstanceName;
        public final DexType lambdaType;
        public final DexMethod lambdaInitializerMethod;

        private Functional() {
            this.kotlinStyleLambdaInstanceName = Kotlin.this.factory.createString("INSTANCE");
            this.lambdaType = Kotlin.this.factory.createType("Lkotlin/jvm/internal/Lambda;");
            this.lambdaInitializerMethod = Kotlin.this.factory.createMethod(this.lambdaType, Kotlin.this.factory.createProto(Kotlin.this.factory.voidType, Kotlin.this.factory.intType), Kotlin.this.factory.constructorMethodName);
            for (int i = 0; i <= 22; ++i) {
                this.functions.add(Kotlin.this.factory.createType("Lkotlin/jvm/functions/Function" + i + ";"));
            }
        }

        public boolean isFunctionInterface(DexType type) {
            return this.functions.contains(type);
        }
    }
}

