/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Add;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Div;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Mul;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Rem;
import com.android.tools.r8.ir.code.Sub;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.origin.SynthesizedOrigin;
import com.android.tools.r8.shaking.Enqueuer;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Outliner {
    private final InternalOptions options;
    private final Map<Outline, List<DexEncodedMethod>> candidates = new HashMap<Outline, List<DexEncodedMethod>>();
    private final Map<Outline, DexMethod> generatedOutlines = new HashMap<Outline, DexMethod>();
    private final Set<DexEncodedMethod> methodsSelectedForOutlining = Sets.newIdentityHashSet();
    static final int MAX_IN_SIZE = 5;
    private final Enqueuer.AppInfoWithLiveness appInfo;
    private final DexItemFactory dexItemFactory;

    public Outliner(Enqueuer.AppInfoWithLiveness appInfo, InternalOptions options) {
        this.appInfo = appInfo;
        this.dexItemFactory = appInfo.dexItemFactory;
        this.options = options;
    }

    public void identifyCandidates(IRCode code, DexEncodedMethod method) {
        assert (!(method.getCode() instanceof OutlineCode));
        for (BasicBlock block : code.blocks) {
            new OutlineIdentifier(method, block).process();
        }
    }

    public boolean selectMethodsForOutlining() {
        assert (this.methodsSelectedForOutlining.size() == 0);
        ArrayList<Outline> toRemove = new ArrayList<Outline>();
        for (Map.Entry<Outline, List<DexEncodedMethod>> entry : this.candidates.entrySet()) {
            if (entry.getValue().size() < this.options.outline.threshold) {
                toRemove.add(entry.getKey());
                continue;
            }
            this.methodsSelectedForOutlining.addAll((Collection<DexEncodedMethod>)entry.getValue());
        }
        for (Outline outline : toRemove) {
            this.candidates.remove(outline);
        }
        return this.methodsSelectedForOutlining.size() > 0;
    }

    public Set<DexEncodedMethod> getMethodsSelectedForOutlining() {
        return this.methodsSelectedForOutlining;
    }

    public void applyOutliningCandidate(IRCode code, DexEncodedMethod method) {
        assert (!(method.getCode() instanceof OutlineCode));
        ListIterator<BasicBlock> blocksIterator = code.blocks.listIterator();
        while (blocksIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blocksIterator.next();
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            new OutlineRewriter(method, code, blocksIterator, block, toRemove).process();
            block.removeInstructions(toRemove);
        }
    }

    public static void noProcessing(IRCode code, DexEncodedMethod method) {
    }

    public DexProgramClass buildOutlinerClass(DexType type) {
        if (this.candidates.size() == 0) {
            return null;
        }
        DexEncodedMethod[] direct = new DexEncodedMethod[this.candidates.size()];
        int count = 0;
        ArrayList<Outline> outlines = new ArrayList<Outline>(this.candidates.keySet());
        outlines.sort(Comparator.naturalOrder());
        for (Outline outline : outlines) {
            MethodAccessFlags methodAccess = MethodAccessFlags.fromSharedAccessFlags(9, false);
            DexString methodName = this.dexItemFactory.createString("outline" + count);
            DexMethod method = outline.buildMethod(type, methodName);
            direct[count] = new DexEncodedMethod(method, methodAccess, DexAnnotationSet.empty(), DexAnnotationSetRefList.empty(), new OutlineCode(outline));
            this.generatedOutlines.put(outline, method);
            ++count;
        }
        DexType superType = this.dexItemFactory.createType("Ljava/lang/Object;");
        DexTypeList interfaces = DexTypeList.empty();
        DexString sourceFile = this.dexItemFactory.createString("outline");
        ClassAccessFlags accessFlags = ClassAccessFlags.fromSharedAccessFlags(1);
        DexProgramClass clazz = new DexProgramClass(type, null, new SynthesizedOrigin("outlining", this.getClass()), accessFlags, superType, interfaces, sourceFile, null, Collections.emptyList(), DexAnnotationSet.empty(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, direct, DexEncodedMethod.EMPTY_ARRAY, this.options.itemFactory.getSkipNameValidationForTesting());
        return clazz;
    }

    public class OutlineCode
    extends Code {
        private final Outline outline;

        OutlineCode(Outline outline) {
            this.outline = outline;
        }

        @Override
        public boolean isOutlineCode() {
            return true;
        }

        @Override
        public int estimatedSizeForInlining() {
            return Integer.MAX_VALUE;
        }

        @Override
        public OutlineCode asOutlineCode() {
            return this;
        }

        @Override
        public boolean isEmptyVoidMethod() {
            return false;
        }

        @Override
        public IRCode buildIR(DexEncodedMethod encodedMethod, InternalOptions options) throws ApiLevelException {
            OutlineSourceCode source = new OutlineSourceCode(this.outline);
            IRBuilder builder = new IRBuilder(encodedMethod, source, options);
            return builder.build();
        }

        @Override
        public String toString() {
            return this.outline.toString();
        }

        @Override
        public void registerCodeReferences(UseRegistry registry) {
            throw new Unreachable();
        }

        @Override
        protected int computeHashCode() {
            return this.outline.hashCode();
        }

        @Override
        protected boolean computeEquals(Object other) {
            return this.outline.equals(other);
        }

        @Override
        public String toString(DexEncodedMethod method, ClassNameMapper naming) {
            return null;
        }
    }

    private class OutlineSourceCode
    implements SourceCode {
        private final Outline outline;
        int argumentMapIndex = 0;

        OutlineSourceCode(Outline outline) {
            this.outline = outline;
        }

        @Override
        public int instructionCount() {
            return this.outline.templateInstructions.size() + 1;
        }

        @Override
        public int instructionIndex(int instructionOffset) {
            return instructionOffset;
        }

        @Override
        public int instructionOffset(int instructionIndex) {
            return instructionIndex;
        }

        @Override
        public DebugLocalInfo getCurrentLocal(int register) {
            return null;
        }

        @Override
        public int traceInstruction(int instructionIndex, IRBuilder builder) {
            return instructionIndex == this.outline.templateInstructions.size() ? instructionIndex : -1;
        }

        @Override
        public void closingCurrentBlockWithFallthrough(int fallthroughInstructionIndex, IRBuilder builder) {
        }

        @Override
        public void setUp() {
        }

        @Override
        public void clear() {
        }

        @Override
        public void buildPrelude(IRBuilder builder) {
            for (int i = 0; i < this.outline.arguments.size(); ++i) {
                ValueType valueType = this.outline.arguments.get(i).outType();
                builder.addNonThisArgument(i, valueType);
            }
        }

        @Override
        public void buildPostlude(IRBuilder builder) {
        }

        @Override
        public void buildInstruction(IRBuilder builder, int instructionIndex) {
            Value value;
            if (instructionIndex == this.outline.templateInstructions.size()) {
                if (this.outline.returnType == ((Outliner)Outliner.this).dexItemFactory.voidType) {
                    builder.addReturn();
                } else {
                    builder.addReturn(ValueType.fromDexType(this.outline.returnType), this.outline.argumentCount());
                }
                return;
            }
            Instruction template = this.outline.templateInstructions.get(instructionIndex);
            ArrayList<Value> inValues = new ArrayList<Value>(template.inValues().size());
            List<Value> templateInValues = template.inValues();
            for (int i = 0; i < templateInValues.size(); ++i) {
                int register;
                value = templateInValues.get(i);
                if ((register = this.outline.argumentMap.get(this.argumentMapIndex++).intValue()) == -1) {
                    register = this.outline.argumentCount();
                }
                inValues.add(builder.readRegister(register, value.outType()));
            }
            Value outValue = null;
            if (template.outValue() != null) {
                value = template.outValue();
                outValue = builder.writeRegister(this.outline.argumentCount(), value.outType(), BasicBlock.ThrowingInfo.CAN_THROW);
            }
            Instruction newInstruction = null;
            if (template.isInvoke()) {
                Invoke templateInvoke = template.asInvoke();
                newInstruction = Invoke.createFromTemplate(templateInvoke, outValue, inValues);
            } else if (template.isAdd()) {
                Add templateInvoke = template.asAdd();
                newInstruction = new Add(templateInvoke.getNumericType(), outValue, (Value)inValues.get(0), (Value)inValues.get(1));
            } else if (template.isMul()) {
                Mul templateInvoke = template.asMul();
                newInstruction = new Mul(templateInvoke.getNumericType(), outValue, (Value)inValues.get(0), (Value)inValues.get(1));
            } else if (template.isSub()) {
                Sub templateInvoke = template.asSub();
                newInstruction = new Sub(templateInvoke.getNumericType(), outValue, (Value)inValues.get(0), (Value)inValues.get(1));
            } else if (template.isDiv()) {
                Div templateInvoke = template.asDiv();
                newInstruction = new Div(templateInvoke.getNumericType(), outValue, (Value)inValues.get(0), (Value)inValues.get(1));
            } else if (template.isRem()) {
                Rem templateInvoke = template.asRem();
                newInstruction = new Rem(templateInvoke.getNumericType(), outValue, (Value)inValues.get(0), (Value)inValues.get(1));
            } else {
                assert (template.isNewInstance());
                NewInstance templateNewInstance = template.asNewInstance();
                newInstruction = new NewInstance(templateNewInstance.clazz, outValue);
            }
            builder.add(newInstruction);
        }

        @Override
        public void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
            throw new Unreachable("Unexpected call to resolveAndBuildSwitch");
        }

        @Override
        public void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
            throw new Unreachable("Unexpected call to resolveAndBuildNewArrayFilledData");
        }

        @Override
        public CatchHandlers<Integer> getCurrentCatchHandlers() {
            return null;
        }

        @Override
        public int getMoveExceptionRegister() {
            throw new Unreachable();
        }

        @Override
        public Position getDebugPositionAtOffset(int offset) {
            throw new Unreachable();
        }

        @Override
        public Position getCurrentPosition() {
            return Position.none();
        }

        @Override
        public boolean verifyCurrentInstructionCanThrow() {
            return true;
        }

        @Override
        public boolean verifyLocalInScope(DebugLocalInfo local) {
            return true;
        }

        @Override
        public boolean verifyRegister(int register) {
            return true;
        }
    }

    private class OutlineRewriter
    extends OutlineSpotter {
        private final IRCode code;
        private final ListIterator<BasicBlock> blocksIterator;
        private final List<Integer> toRemove;
        int argumentsMapIndex;

        OutlineRewriter(DexEncodedMethod method, IRCode code, ListIterator<BasicBlock> blocksIterator, BasicBlock block, List<Integer> toRemove) {
            super(method, block);
            this.code = code;
            this.blocksIterator = blocksIterator;
            this.toRemove = toRemove;
        }

        @Override
        protected void handle(int start, int end, Outline outline) {
            if (Outliner.this.candidates.containsKey(outline)) {
                DexMethod m = (DexMethod)Outliner.this.generatedOutlines.get(outline);
                assert (m != null);
                ArrayList<Value> in = new ArrayList<Value>();
                Value returnValue = null;
                this.argumentsMapIndex = 0;
                Position position = Position.none();
                List<Instruction> instructions = this.getInstructionArray();
                for (int i = start; i < end; ++i) {
                    Instruction current = instructions.get(i);
                    if (current.isConstInstruction()) continue;
                    if (position.isNone()) {
                        position = current.getPosition();
                    }
                    List<Value> inValues = this.orderedInValues(current, returnValue);
                    for (int j = 0; j < inValues.size(); ++j) {
                        Value value = inValues.get(j);
                        value.removeUser(current);
                        int argumentIndex = outline.argumentMap.get(this.argumentsMapIndex++);
                        if (argumentIndex < in.size()) continue;
                        assert (argumentIndex == in.size());
                        in.add(value);
                    }
                    if (current.outValue() != null) {
                        returnValue = current.outValue();
                    }
                    if (i >= end - 1) continue;
                    this.toRemove.add(i);
                }
                assert (m.proto.shorty.toString().length() - 1 == in.size());
                if (returnValue != null && !returnValue.isUsed()) {
                    returnValue = null;
                }
                InvokeStatic outlineInvoke = new InvokeStatic(m, returnValue, in);
                outlineInvoke.setBlock(this.block);
                outlineInvoke.setPosition(position);
                if (position.isNone() && this.code.doAllThrowingInstructionsHavePositions()) {
                    this.code.setAllThrowingInstructionsHavePositions(false);
                }
                InstructionListIterator endIterator = this.block.listIterator(end - 1);
                Instruction instructionBeforeEnd = (Instruction)endIterator.next();
                this.invalidateInstructionArray();
                instructionBeforeEnd.clearBlock();
                endIterator.set(outlineInvoke);
                if (this.block.hasCatchHandlers()) {
                    endIterator.split(this.code, this.blocksIterator);
                }
            }
        }
    }

    private class OutlineIdentifier
    extends OutlineSpotter {
        OutlineIdentifier(DexEncodedMethod method, BasicBlock block) {
            super(method, block);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handle(int start, int end, Outline outline) {
            Map map = Outliner.this.candidates;
            synchronized (map) {
                Outliner.this.candidates.computeIfAbsent(outline, k -> new ArrayList()).add(this.method);
            }
        }
    }

    private abstract class OutlineSpotter {
        final DexEncodedMethod method;
        final BasicBlock block;
        private List<Instruction> instructionArrayCache = null;
        int start;
        int index;
        int actualInstructions;
        List<Value> arguments;
        List<DexType> argumentTypes;
        List<Integer> argumentsMap;
        int argumentRegisters;
        DexType returnType;
        Value returnValue;
        int returnValueUsersLeft;
        int pendingNewInstanceIndex = -1;

        OutlineSpotter(DexEncodedMethod method, BasicBlock block) {
            this.method = method;
            this.block = block;
            this.reset(0);
        }

        protected List<Instruction> getInstructionArray() {
            if (this.instructionArrayCache == null) {
                this.instructionArrayCache = new ArrayList<Instruction>(this.block.getInstructions());
            }
            return this.instructionArrayCache;
        }

        protected void invalidateInstructionArray() {
            this.instructionArrayCache = null;
        }

        protected void process() {
            List<Instruction> instructions;
            while (this.index < (instructions = this.getInstructionArray()).size()) {
                this.processInstruction(instructions.get(this.index));
            }
        }

        protected List<Value> orderedInValues(Instruction instruction, Value returnValue) {
            List<Value> inValues = instruction.inValues();
            if (instruction.isBinop() && instruction.asBinop().isCommutative() && inValues.get(1) == returnValue) {
                Value tmp = inValues.get(0);
                inValues.set(0, inValues.get(1));
                inValues.set(1, tmp);
            }
            return inValues;
        }

        private void processInstruction(Instruction instruction) {
            boolean include = false;
            int instructionIncrement = 1;
            if (instruction.isConstInstruction()) {
                if (this.index == this.start) {
                    this.reset(this.index + 1);
                    return;
                }
                include = true;
                instructionIncrement = 0;
            } else {
                include = this.canIncludeInstruction(instruction);
            }
            if (include) {
                this.actualInstructions += instructionIncrement;
                this.includeInstruction(instruction);
                if (this.actualInstructions >= ((Outliner)Outliner.this).options.outline.maxSize) {
                    this.candidate(this.start, this.index + 1);
                } else {
                    ++this.index;
                }
            } else if (this.index > this.start) {
                this.candidate(this.start, this.index);
            } else {
                this.reset(this.index + 1);
            }
        }

        private boolean canIncludeInstruction(Instruction instruction) {
            int returnValueUsersLeftIfIncluded = this.returnValueUsersLeft;
            if (this.returnValue != null) {
                for (Value value : instruction.inValues()) {
                    if (value != this.returnValue) continue;
                    --returnValueUsersLeftIfIncluded;
                }
            }
            if (instruction.outValue() != null && returnValueUsersLeftIfIncluded > 0) {
                return false;
            }
            if (instruction.isNewInstance()) {
                if (instruction.outValue().isUsed()) {
                    this.pendingNewInstanceIndex = this.index;
                }
                return true;
            }
            if (instruction.isArithmeticBinop()) {
                return true;
            }
            if (!instruction.isInvokeMethod()) {
                return false;
            }
            InvokeMethod invoke = instruction.asInvokeMethod();
            boolean constructor = Outliner.this.dexItemFactory.isConstructor(invoke.getInvokedMethod());
            Inliner.Constraint constraint = invoke.inliningConstraint(Outliner.this.appInfo, this.method.method.holder);
            if (constraint != Inliner.Constraint.ALWAYS) {
                return false;
            }
            int newArgumentRegisters = this.argumentRegisters;
            if (instruction.inValues().size() > 0) {
                List<Value> inValues = this.orderedInValues(instruction, this.returnValue);
                for (int i = 0; i < inValues.size(); ++i) {
                    Value value = inValues.get(i);
                    if (value == this.returnValue) continue;
                    if (invoke.isInvokeStatic()) {
                        newArgumentRegisters += value.requiredRegisters();
                        continue;
                    }
                    if (i <= 0 && this.arguments.contains(value)) continue;
                    newArgumentRegisters += value.requiredRegisters();
                }
            }
            if (newArgumentRegisters > 5) {
                return false;
            }
            if (constructor) {
                Instruction previous;
                if (this.start == this.index) {
                    return false;
                }
                assert (this.index > 0);
                int offset = 0;
                List<Instruction> instructions = this.getInstructionArray();
                while ((previous = instructions.get(this.index - ++offset)).isConstInstruction()) {
                }
                if (!previous.isNewInstance() || previous.outValue() != this.returnValue) {
                    return false;
                }
                this.pendingNewInstanceIndex = -1;
            }
            return true;
        }

        private void includeInstruction(Instruction instruction) {
            List<Value> inValues = this.orderedInValues(instruction, this.returnValue);
            Value prevReturnValue = this.returnValue;
            if (this.returnValue != null) {
                for (Value value : inValues) {
                    if (value == this.returnValue) {
                        assert (this.returnValueUsersLeft > 0);
                        --this.returnValueUsersLeft;
                    }
                    if (this.returnValueUsersLeft != 0) continue;
                    this.returnValue = null;
                    this.returnType = ((Outliner)Outliner.this).dexItemFactory.voidType;
                }
            }
            if (instruction.isNewInstance()) {
                assert (this.returnValue == null);
                this.updateReturnValueState(instruction.outValue(), instruction.asNewInstance().clazz);
                return;
            }
            assert (instruction.isInvoke() || instruction.isConstInstruction() || instruction.isArithmeticBinop());
            if (inValues.size() > 0) {
                for (int i = 0; i < inValues.size(); ++i) {
                    Value value;
                    value = inValues.get(i);
                    if (value == prevReturnValue) {
                        this.argumentsMap.add(-1);
                        continue;
                    }
                    if (instruction.isInvoke() && instruction.asInvoke().getType() != Invoke.Type.STATIC && instruction.asInvoke().getType() != Invoke.Type.CUSTOM) {
                        InvokeMethod invoke = instruction.asInvokeMethod();
                        int argumentIndex = this.arguments.indexOf(value);
                        if (i == 0 && argumentIndex != -1) {
                            this.argumentsMap.add(argumentIndex);
                            continue;
                        }
                        this.arguments.add(value);
                        this.argumentRegisters += value.requiredRegisters();
                        if (i == 0) {
                            this.argumentTypes.add(invoke.getInvokedMethod().getHolder());
                        } else {
                            DexProto methodProto = instruction.asInvoke().getType() == Invoke.Type.POLYMORPHIC ? instruction.asInvokePolymorphic().getProto() : invoke.getInvokedMethod().proto;
                            this.argumentTypes.add(methodProto.parameters.values[i - 1]);
                        }
                        this.argumentsMap.add(this.arguments.size() - 1);
                        continue;
                    }
                    this.arguments.add(value);
                    if (instruction.isInvokeMethod()) {
                        this.argumentTypes.add(instruction.asInvokeMethod().getInvokedMethod().proto.parameters.values[i]);
                    } else {
                        this.argumentTypes.add(instruction.asBinop().getNumericType().dexTypeFor(Outliner.this.dexItemFactory));
                    }
                    this.argumentsMap.add(this.arguments.size() - 1);
                }
            }
            if (!instruction.isConstInstruction() && instruction.outValue() != null) {
                assert (this.returnValue == null);
                if (instruction.isInvokeMethod()) {
                    this.updateReturnValueState(instruction.outValue(), instruction.asInvokeMethod().getInvokedMethod().proto.returnType);
                } else {
                    this.updateReturnValueState(instruction.outValue(), instruction.asBinop().getNumericType().dexTypeFor(Outliner.this.dexItemFactory));
                }
            }
        }

        private void updateReturnValueState(Value newReturnValue, DexType newReturnType) {
            this.returnValueUsersLeft = newReturnValue.numberOfAllUsers();
            if (this.returnValueUsersLeft == 0) {
                this.returnValue = null;
                this.returnType = ((Outliner)Outliner.this).dexItemFactory.voidType;
            } else {
                this.returnValue = newReturnValue;
                this.returnType = newReturnType;
            }
        }

        protected abstract void handle(int var1, int var2, Outline var3);

        private void candidate(int start, int index) {
            List<Instruction> instructions = this.getInstructionArray();
            assert (!instructions.get(start).isConstInstruction());
            if (this.pendingNewInstanceIndex != -1) {
                if (this.pendingNewInstanceIndex == start) {
                    this.reset(index);
                } else {
                    this.reset(this.pendingNewInstanceIndex);
                }
                return;
            }
            int end = index;
            while (instructions.get(end - 1).isConstInstruction()) {
                --end;
            }
            int nonConstInstructions = 0;
            for (int i = start; i < end; ++i) {
                if (instructions.get(i).isConstInstruction()) continue;
                ++nonConstInstructions;
            }
            if (nonConstInstructions < ((Outliner)Outliner.this).options.outline.minSize) {
                this.reset(start + 1);
                return;
            }
            Outline outline = new Outline(instructions, this.arguments, this.argumentTypes, this.argumentsMap, this.returnType, start, end);
            this.handle(start, end, outline);
            this.reset(index);
        }

        private void reset(int startIndex) {
            this.start = startIndex;
            this.index = startIndex;
            this.actualInstructions = 0;
            this.arguments = new ArrayList<Value>(5);
            this.argumentTypes = new ArrayList<DexType>(5);
            this.argumentsMap = new ArrayList<Integer>(5);
            this.argumentRegisters = 0;
            this.returnType = ((Outliner)Outliner.this).dexItemFactory.voidType;
            this.returnValue = null;
            this.returnValueUsersLeft = 0;
            this.pendingNewInstanceIndex = -1;
        }
    }

    public class Outline
    implements Comparable<Outline> {
        final List<Value> arguments;
        final List<DexType> argumentTypes;
        final List<Integer> argumentMap;
        final List<Instruction> templateInstructions = new ArrayList<Instruction>();
        public final DexType returnType;
        private DexProto proto;

        Outline(List<Instruction> instructions, List<Value> arguments, List<DexType> argumentTypes, List<Integer> argumentMap, DexType returnType, int start, int end) {
            this.arguments = arguments;
            this.argumentTypes = argumentTypes;
            this.argumentMap = argumentMap;
            this.returnType = returnType;
            for (int i = start; i < end; ++i) {
                Instruction current = instructions.get(i);
                if (current.isInvoke() || current.isNewInstance() || current.isArithmeticBinop()) {
                    this.templateInstructions.add(current);
                    continue;
                }
                if (!current.isConstInstruction()) assert (false) : "Unexpected type of instruction in outlining template.";
            }
        }

        int argumentCount() {
            return this.arguments.size();
        }

        DexProto buildProto() {
            if (this.proto == null) {
                DexType[] argumentTypesArray = this.argumentTypes.toArray(new DexType[this.argumentTypes.size()]);
                this.proto = Outliner.this.dexItemFactory.createProto(this.returnType, argumentTypesArray);
            }
            return this.proto;
        }

        DexMethod buildMethod(DexType clazz, DexString name) {
            return Outliner.this.dexItemFactory.createMethod(clazz, this.buildProto(), name);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Outline)) {
                return false;
            }
            List<Instruction> instructions0 = this.templateInstructions;
            List<Instruction> instructions1 = ((Outline)other).templateInstructions;
            if (instructions0.size() != instructions1.size()) {
                return false;
            }
            for (int i = 0; i < instructions0.size(); ++i) {
                Instruction i0 = instructions0.get(i);
                Instruction i1 = instructions1.get(i);
                if (i0.getClass() != i1.getClass() || !i0.identicalNonValueNonPositionParts(i1)) {
                    return false;
                }
                if (i0.outValue() != null == (i1.outValue() != null)) continue;
                return false;
            }
            return this.argumentMap.equals(((Outline)other).argumentMap) && this.returnType == ((Outline)other).returnType;
        }

        public int hashCode() {
            int MAX_HASH_INSTRUCTIONS = 5;
            int hash = this.templateInstructions.size();
            int hashPart = 0;
            for (int i = 0; i < this.templateInstructions.size() && i < 5; ++i) {
                Instruction instruction = this.templateInstructions.get(i);
                if (instruction.isInvokeMethod()) {
                    hashPart <<= 4;
                    hashPart += instruction.asInvokeMethod().getInvokedMethod().hashCode();
                }
                hash = hash * 3 + hashPart;
            }
            return hash;
        }

        @Override
        public int compareTo(Outline other) {
            int i;
            if (this == other) {
                return 0;
            }
            int result = this.buildProto().slowCompareTo(other.buildProto());
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            assert (this.argumentCount() == other.argumentCount());
            List<Instruction> instructions0 = this.templateInstructions;
            List<Instruction> instructions1 = other.templateInstructions;
            result = instructions0.size() - instructions1.size();
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            for (i = 0; i < instructions0.size(); ++i) {
                Instruction i0 = instructions0.get(i);
                Instruction i1 = instructions1.get(i);
                result = i0.getInstructionName().compareTo(i1.getInstructionName());
                if (result != 0) {
                    assert (!this.equals(other));
                    return result;
                }
                result = i0.inValues().size() - i1.inValues().size();
                if (result != 0) {
                    assert (!this.equals(other));
                    return result;
                }
                result = (i0.outValue() != null ? 1 : 0) - (i1.outValue() != null ? 1 : 0);
                if (result != 0) {
                    assert (!this.equals(other));
                    return result;
                }
                result = i0.compareNonValueParts(i1);
                if (result == 0) continue;
                assert (!this.equals(other));
                return result;
            }
            result = this.argumentMap.size() - other.argumentMap.size();
            if (result != 0) {
                assert (!this.equals(other));
                return result;
            }
            for (i = 0; i < this.argumentMap.size(); ++i) {
                result = this.argumentMap.get(i) - other.argumentMap.get(i);
                if (result == 0) continue;
                assert (!this.equals(other));
                return result;
            }
            assert (this.equals(other));
            return 0;
        }

        public String toString() {
            int outRegisterNumber = this.arguments.size();
            StringBuilder builder = new StringBuilder();
            builder.append(this.returnType);
            builder.append(" anOutline");
            StringUtils.append(builder, this.argumentTypes, ", ", StringUtils.BraceType.PARENS);
            builder.append("\n");
            int argumentMapIndex = 0;
            for (Instruction instruction : this.templateInstructions) {
                String name = instruction.getInstructionName();
                StringUtils.appendRightPadded(builder, name, 20);
                if (instruction.outValue() != null) {
                    builder.append("v" + outRegisterNumber);
                    builder.append(" <- ");
                }
                for (int i = 0; i < instruction.inValues().size(); ++i) {
                    builder.append(i > 0 ? ", " : "");
                    builder.append("v");
                    int index = this.argumentMap.get(argumentMapIndex++);
                    if (index >= 0) {
                        builder.append(index);
                        continue;
                    }
                    builder.append(outRegisterNumber);
                }
                if (instruction.isInvoke()) {
                    builder.append("; method: ");
                    builder.append(instruction.asInvokeMethod().getInvokedMethod().toSourceString());
                }
                if (instruction.isNewInstance()) {
                    builder.append(instruction.asNewInstance().clazz.toSourceString());
                }
                builder.append("\n");
            }
            if (this.returnType == ((Outliner)Outliner.this).dexItemFactory.voidType) {
                builder.append("Return-Void");
            } else {
                StringUtils.appendRightPadded(builder, "Return", 20);
                builder.append("v" + outRegisterNumber);
            }
            builder.append("\n");
            builder.append(this.argumentMap);
            return builder.toString();
        }
    }
}

