/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.Resource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.IOExceptionDiagnostic;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;

public interface DexFilePerClassFileConsumer
extends ProgramConsumer {
    public void accept(String var1, byte[] var2, Set<String> var3, DiagnosticsHandler var4);

    public static DexFilePerClassFileConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements InternalProgramOutputPathConsumer {
        private final Path directory;

        public DirectoryConsumer(Path directory) {
            this(directory, null);
        }

        public DirectoryConsumer(Path directory, DexFilePerClassFileConsumer consumer) {
            super(consumer);
            this.directory = directory;
        }

        @Override
        public void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(primaryClassDescriptor, data, descriptors, handler);
            Path target = DirectoryConsumer.getTargetDexFile(this.directory, primaryClassDescriptor);
            try {
                DirectoryConsumer.writeFile(data, target);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, new PathOrigin(target)));
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.directory;
        }

        public static void writeResources(Path directory, List<ProgramResource> resources, Map<Resource, String> primaryClassDescriptors) throws IOException, ResourceException {
            try (Closer closer = Closer.create();){
                for (ProgramResource resource : resources) {
                    String primaryClassDescriptor = primaryClassDescriptors.get(resource);
                    Path target = DirectoryConsumer.getTargetDexFile(directory, primaryClassDescriptor);
                    DirectoryConsumer.writeFile(ByteStreams.toByteArray(closer.register(resource.getByteStream())), target);
                }
            }
        }

        private static Path getTargetDexFile(Path directory, String primaryClassDescriptor) {
            return directory.resolve(ArchiveConsumer.getDexFileName(primaryClassDescriptor));
        }

        private static void writeFile(byte[] contents, Path target) throws IOException {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            FileUtils.writeToFile(target, null, contents);
        }
    }

    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements InternalProgramOutputPathConsumer {
        private final Path archive;
        private final Origin origin;
        private ZipOutputStream stream = null;
        private boolean closed = false;

        private static String getDexFileName(String classDescriptor) {
            assert (classDescriptor != null && DescriptorUtils.isClassDescriptor(classDescriptor));
            return DescriptorUtils.getClassBinaryNameFromDescriptor(classDescriptor) + ".dex";
        }

        public ArchiveConsumer(Path archive) {
            this(archive, null);
        }

        public ArchiveConsumer(Path archive, DexFilePerClassFileConsumer consumer) {
            super(consumer);
            this.archive = archive;
            this.origin = new PathOrigin(archive);
        }

        @Override
        public void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(primaryClassDescriptor, data, descriptors, handler);
            this.synchronizedWrite(ArchiveConsumer.getDexFileName(primaryClassDescriptor), data, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            assert (!this.closed);
            this.closed = true;
            try {
                if (this.stream != null) {
                    this.stream.close();
                    this.stream = null;
                }
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }

        @Override
        public Path internalGetOutputPath() {
            return this.archive;
        }

        private ZipOutputStream getStream(DiagnosticsHandler handler) {
            assert (!this.closed);
            if (this.stream == null) {
                try {
                    this.stream = new ZipOutputStream(Files.newOutputStream(this.archive, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
                }
                catch (IOException e) {
                    handler.error(new IOExceptionDiagnostic(e, this.origin));
                }
            }
            return this.stream;
        }

        private synchronized void synchronizedWrite(String entry, byte[] content, DiagnosticsHandler handler) {
            try {
                ZipUtils.writeToZipStream(this.getStream(handler), entry, content, 0);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }

        public static void writeResources(Path archive, List<ProgramResource> resources, Map<Resource, String> primaryClassDescriptors) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            try (Closer closer = Closer.create();
                 ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(archive, options));){
                for (ProgramResource resource : resources) {
                    String primaryClassDescriptor = primaryClassDescriptors.get(resource);
                    String entryName = ArchiveConsumer.getDexFileName(primaryClassDescriptor);
                    byte[] bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
                    ZipUtils.writeToZipStream(out, entryName, bytes, 0);
                }
            }
        }
    }

    public static class ForwardingConsumer
    implements DexFilePerClassFileConsumer {
        private static final DexFilePerClassFileConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final DexFilePerClassFileConsumer consumer;

        public ForwardingConsumer(DexFilePerClassFileConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(String primaryClassDescriptor, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(primaryClassDescriptor, data, descriptors, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

