/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda.kotlin;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.optimize.lambda.CaptureSignature;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupId;
import com.android.tools.r8.ir.optimize.lambda.kotlin.JStyleLambdaGroupIdFactory;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KStyleLambdaGroupIdFactory;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaConstants;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.utils.InternalOptions;
import java.util.List;

public abstract class KotlinLambdaGroupIdFactory
implements KotlinLambdaConstants {
    KotlinLambdaGroupIdFactory() {
    }

    public static LambdaGroupId create(Kotlin kotlin, DexClass lambda2, InternalOptions options) throws LambdaGroup.LambdaStructureError {
        assert (lambda2.hasKotlinInfo() && lambda2.getKotlinInfo().isSyntheticClass());
        if (lambda2.getKotlinInfo().asSyntheticClass().isKotlinStyleLambda()) {
            return KStyleLambdaGroupIdFactory.INSTANCE.validateAndCreate(kotlin, lambda2, options);
        }
        assert (lambda2.getKotlinInfo().asSyntheticClass().isJavaStyleLambda());
        return JStyleLambdaGroupIdFactory.INSTANCE.validateAndCreate(kotlin, lambda2, options);
    }

    abstract LambdaGroupId validateAndCreate(Kotlin var1, DexClass var2, InternalOptions var3) throws LambdaGroup.LambdaStructureError;

    abstract void validateSuperclass(Kotlin var1, DexClass var2) throws LambdaGroup.LambdaStructureError;

    abstract DexType validateInterfaces(Kotlin var1, DexClass var2) throws LambdaGroup.LambdaStructureError;

    DexEncodedMethod validateVirtualMethods(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        DexEncodedMethod mainMethod = null;
        for (DexEncodedMethod method : lambda2.virtualMethods()) {
            if (method.accessFlags.equals(MAIN_METHOD_FLAGS)) {
                if (mainMethod != null) {
                    throw new LambdaGroup.LambdaStructureError("more than one main method found");
                }
                mainMethod = method;
                continue;
            }
            KotlinLambdaGroupIdFactory.checkAccessFlags((String)"unexpected virtual method access flags", (AccessFlags)method.accessFlags, (AccessFlags[])new MethodAccessFlags[]{BRIDGE_METHOD_FLAGS, BRIDGE_METHOD_FLAGS_FIXED});
            this.checkDirectMethodAnnotations(method);
        }
        if (mainMethod == null) {
            throw new LambdaGroup.LambdaStructureError("no main method found", false);
        }
        return mainMethod;
    }

    InnerClassAttribute validateInnerClasses(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        List<InnerClassAttribute> innerClasses = lambda2.getInnerClasses();
        if (innerClasses != null) {
            for (InnerClassAttribute inner : innerClasses) {
                if (inner.getInner() != lambda2.type) continue;
                if (!inner.isAnonymous()) {
                    throw new LambdaGroup.LambdaStructureError("is not anonymous");
                }
                return inner;
            }
        }
        return null;
    }

    String validateAnnotations(Kotlin kotlin, DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        String signature = null;
        if (!lambda2.annotations.isEmpty()) {
            for (DexAnnotation annotation : lambda2.annotations.annotations) {
                if (DexAnnotation.isSignatureAnnotation(annotation, kotlin.factory)) {
                    signature = DexAnnotation.getSignature(annotation);
                    continue;
                }
                if (annotation.annotation.type == kotlin.metadata.kotlinMetadataType) continue;
                throw new LambdaGroup.LambdaStructureError("unexpected annotation: " + annotation.annotation.type.toSourceString());
            }
        }
        return signature;
    }

    void validateStaticFields(Kotlin kotlin, DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        DexEncodedField[] staticFields = lambda2.staticFields();
        if (staticFields.length == 1) {
            DexEncodedField field = staticFields[0];
            if (!(field.field.name == kotlin.functional.kotlinStyleLambdaInstanceName && field.field.type == lambda2.type && field.accessFlags.isPublic() && field.accessFlags.isFinal() && field.accessFlags.isStatic())) {
                throw new LambdaGroup.LambdaStructureError("unexpected static field " + field.toSourceString());
            }
            if (lambda2.instanceFields().length > 0) {
                throw new LambdaGroup.LambdaStructureError("has instance fields along with INSTANCE");
            }
            KotlinLambdaGroupIdFactory.checkAccessFlags((String)"static field access flags", (AccessFlags)field.accessFlags, (AccessFlags[])new FieldAccessFlags[]{SINGLETON_FIELD_FLAGS});
            KotlinLambdaGroupIdFactory.checkFieldAnnotations(field);
        } else if (staticFields.length > 1) {
            throw new LambdaGroup.LambdaStructureError("only one static field max expected, found " + staticFields.length);
        }
    }

    String validateInstanceFields(DexClass lambda2, boolean accessRelaxed) throws LambdaGroup.LambdaStructureError {
        DexEncodedField[] instanceFields;
        for (DexEncodedField field : instanceFields = lambda2.instanceFields()) {
            KotlinLambdaGroupIdFactory.checkAccessFlags((String)"capture field access flags", (AccessFlags)field.accessFlags, (AccessFlags[])new FieldAccessFlags[]{accessRelaxed ? CAPTURE_FIELD_FLAGS_RELAXED : CAPTURE_FIELD_FLAGS});
            KotlinLambdaGroupIdFactory.checkFieldAnnotations(field);
        }
        return CaptureSignature.getCaptureSignature(instanceFields);
    }

    void validateDirectMethods(DexClass lambda2) throws LambdaGroup.LambdaStructureError {
        DexEncodedMethod[] directMethods;
        for (DexEncodedMethod method : directMethods = lambda2.directMethods()) {
            if (method.isClassInitializer()) {
                if (lambda2.staticFields().length != 1) {
                    throw new LambdaGroup.LambdaStructureError("has static initializer, but no singleton field");
                }
                KotlinLambdaGroupIdFactory.checkAccessFlags((String)"unexpected static initializer access flags", (AccessFlags)method.accessFlags, (AccessFlags[])new MethodAccessFlags[]{CLASS_INITIALIZER_FLAGS});
                this.checkDirectMethodAnnotations(method);
                continue;
            }
            if (method.isStaticMethod()) {
                throw new LambdaGroup.LambdaStructureError("unexpected static method: " + method.method.toSourceString());
            }
            if (method.isInstanceInitializer()) {
                DexType[] parameters = method.method.proto.parameters.values;
                DexEncodedField[] instanceFields = lambda2.instanceFields();
                if (parameters.length != instanceFields.length) {
                    throw new LambdaGroup.LambdaStructureError("constructor parameters don't match captured values.");
                }
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i] == instanceFields[i].field.type) continue;
                    throw new LambdaGroup.LambdaStructureError("constructor parameters don't match captured values.", false);
                }
                KotlinLambdaGroupIdFactory.checkAccessFlags((String)"unexpected constructor access flags", (AccessFlags)method.accessFlags, (AccessFlags[])new MethodAccessFlags[]{CONSTRUCTOR_FLAGS, CONSTRUCTOR_FLAGS_RELAXED});
                this.checkDirectMethodAnnotations(method);
                continue;
            }
            throw new Unreachable();
        }
    }

    void checkDirectMethodAnnotations(DexEncodedMethod method) throws LambdaGroup.LambdaStructureError {
        if (!method.annotations.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected method annotations [" + method.annotations.toSmaliString() + "] on " + method.method.toSourceString());
        }
        if (!method.parameterAnnotations.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected method parameters annotations [" + method.annotations.toSmaliString() + "] on " + method.method.toSourceString());
        }
    }

    private static void checkFieldAnnotations(DexEncodedField field) throws LambdaGroup.LambdaStructureError {
        if (!field.annotations.isEmpty()) {
            throw new LambdaGroup.LambdaStructureError("unexpected field annotations [" + field.annotations.toSmaliString() + "] on " + field.field.toSourceString());
        }
    }

    @SafeVarargs
    static <T extends AccessFlags> void checkAccessFlags(String message, T actual, T ... expected) throws LambdaGroup.LambdaStructureError {
        for (T flag : expected) {
            if (!((AccessFlags)flag).equals(actual)) continue;
            return;
        }
        throw new LambdaGroup.LambdaStructureError(message);
    }
}

