/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.cf.code;

import com.android.tools.r8.cf.CfPrinter;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfStackInstruction
extends CfInstruction {
    private final Opcode opcode;

    public static CfStackInstruction fromAsm(int opcode) {
        switch (opcode) {
            case 87: {
                return new CfStackInstruction(Opcode.Pop);
            }
            case 88: {
                return new CfStackInstruction(Opcode.Pop2);
            }
            case 89: {
                return new CfStackInstruction(Opcode.Dup);
            }
            case 90: {
                return new CfStackInstruction(Opcode.DupX1);
            }
            case 91: {
                return new CfStackInstruction(Opcode.DupX2);
            }
            case 92: {
                return new CfStackInstruction(Opcode.Dup2);
            }
            case 93: {
                return new CfStackInstruction(Opcode.Dup2X1);
            }
            case 94: {
                return new CfStackInstruction(Opcode.Dup2X2);
            }
            case 95: {
                return new CfStackInstruction(Opcode.Swap);
            }
        }
        throw new Unreachable("Invalid opcode for CfStackInstruction");
    }

    public static CfStackInstruction popType(ValueType type) {
        return new CfStackInstruction(type.isWide() ? Opcode.Pop2 : Opcode.Pop);
    }

    public CfStackInstruction(Opcode opcode) {
        this.opcode = opcode;
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitInsn(this.opcode.opcode);
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    public Opcode getOpcode() {
        return this.opcode;
    }

    public static enum Opcode {
        Pop(87),
        Pop2(88),
        Dup(89),
        DupX1(90),
        DupX2(91),
        Dup2(92),
        Dup2X1(93),
        Dup2X2(94),
        Swap(95);

        private final int opcode;

        private Opcode(int opcode) {
            this.opcode = opcode;
        }
    }
}

