/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.errors;

import com.android.tools.r8.errors.DexOverflowException;

public class MainDexOverflowException
extends DexOverflowException {
    private final boolean hasMainDexList;
    private final long numOfMethods;
    private final long numOfFields;
    private final long maxNumOfEntries;

    public MainDexOverflowException(boolean hasMainDexList, long numOfMethods, long numOfFields, long maxNumOfEntries) {
        this.hasMainDexList = hasMainDexList;
        this.numOfMethods = numOfMethods;
        this.numOfFields = numOfFields;
        this.maxNumOfEntries = maxNumOfEntries;
    }

    private StringBuilder getGeneralMessage() {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Cannot fit requested classes in ");
        messageBuilder.append(this.hasMainDexList ? "the main-" : "a single ");
        messageBuilder.append("dex file");
        return messageBuilder;
    }

    private String getNumberRelatedMessage() {
        StringBuilder messageBuilder = new StringBuilder();
        if (this.numOfMethods > this.maxNumOfEntries) {
            messageBuilder.append("# methods: ");
            messageBuilder.append(this.numOfMethods);
            messageBuilder.append(" > ").append(this.maxNumOfEntries);
            if (this.numOfFields > this.maxNumOfEntries) {
                messageBuilder.append(" ; ");
            }
        }
        if (this.numOfFields > this.maxNumOfEntries) {
            messageBuilder.append("# fields: ");
            messageBuilder.append(this.numOfFields);
            messageBuilder.append(" > ").append(this.maxNumOfEntries);
        }
        return messageBuilder.toString();
    }

    @Override
    public String getMessage() {
        return this.getGeneralMessage().append(" (").append(this.getNumberRelatedMessage()).append(")").toString();
    }

    @Override
    public String getMessageForD8() {
        StringBuilder messageBuilder = this.getGeneralMessage();
        if (!this.hasMainDexList) {
            messageBuilder.append(". ");
            messageBuilder.append("Try supplying a main-dex list");
        }
        messageBuilder.append(".").append(System.getProperty("line.separator"));
        messageBuilder.append(this.getNumberRelatedMessage());
        return messageBuilder.toString();
    }

    @Override
    public String getMessageForR8() {
        StringBuilder messageBuilder = this.getGeneralMessage();
        if (!this.hasMainDexList) {
            messageBuilder.append(". ");
            messageBuilder.append("Try supplying a main-dex list or main dex rules");
        }
        messageBuilder.append(".").append(System.getProperty("line.separator"));
        messageBuilder.append(this.getNumberRelatedMessage());
        return messageBuilder.toString();
    }
}

