/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.dex.VirtualFile;
import com.android.tools.r8.errors.DexOverflowException;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class InheritanceClassInDexDistributor {
    private static final Comparator<DexProgramClass> DEX_PROGRAM_CLASS_COMPARATOR = Comparator.comparing(clazz -> clazz.type.descriptor);
    private static final int DEX_FULL_ENOUGH_THRESHOLD = 65436;
    private final ExecutorService executorService;
    private final VirtualFile mainDex;
    private final List<VirtualFile> dexes;
    private final BitSet fullDex = new BitSet();
    private final Set<DexProgramClass> classes;
    private final DexApplication app;
    private int dexIndexOffset;
    private final NamingLens namingLens;
    private final DirectSubClassesInfo directSubClasses;

    public InheritanceClassInDexDistributor(VirtualFile mainDex, List<VirtualFile> dexes, Set<DexProgramClass> classes, Map<DexProgramClass, String> originalNames, int dexIndexOffset, NamingLens namingLens, DexApplication app, ExecutorService executorService) {
        this.mainDex = mainDex;
        this.dexes = dexes;
        this.classes = classes;
        this.dexIndexOffset = dexIndexOffset;
        this.namingLens = namingLens;
        this.app = app;
        this.executorService = executorService;
        this.directSubClasses = new DirectSubClassesInfo(app, classes);
    }

    public void distribute() throws DexOverflowException {
        List<ClassGroup> remainingInheritanceGroups = this.collectInheritanceGroups();
        remainingInheritanceGroups.sort(null);
        Collections.reverse(remainingInheritanceGroups);
        Iterator<ClassGroup> iter = remainingInheritanceGroups.iterator();
        while (iter.hasNext()) {
            ClassGroup group = iter.next();
            if (!group.dependsOnMainDexClasses) continue;
            iter.remove();
            if (group.canFitInOneDex() && !this.isDexFull(this.mainDex) && this.assignAll(this.mainDex, group.members)) continue;
            CategorizedInheritanceGroupWithMainDexDependency groupSplit = new CategorizedInheritanceGroupWithMainDexDependency(group);
            Set<DexProgramClass> classesMissingMainDex = this.assignFromRoot(this.mainDex, groupSplit.independentsFromMainDexIndependents);
            ClassGroup mainDexIndependentGroup = new ClassGroup(groupSplit.mainDexIndependents);
            Collection<VirtualFile> mainDexInpendentsDexes = this.assignGroup(mainDexIndependentGroup, Collections.singletonList(this.mainDex));
            HashSet<DexProgramClass> classesWithLinkingError = new HashSet<DexProgramClass>(groupSplit.dependentsOfMainDexIndependents);
            classesWithLinkingError.addAll(classesMissingMainDex);
            this.assignClassesWithLinkingError(classesWithLinkingError, mainDexInpendentsDexes);
        }
        for (ClassGroup group : remainingInheritanceGroups) {
            if (group.dependsOnMainDexClasses) continue;
            this.assignGroup(group, Collections.emptyList());
        }
    }

    private static int getTotalClassNumber(List<ClassGroup> groups) {
        int groupClassNumber = 0;
        for (ClassGroup group : groups) {
            groupClassNumber += group.members.size();
        }
        return groupClassNumber;
    }

    private Collection<VirtualFile> assignGroup(ClassGroup group, List<VirtualFile> dexBlackList) throws DexOverflowException {
        VirtualFile.VirtualFileCycler cycler = new VirtualFile.VirtualFileCycler(this.dexes, this.namingLens, this.dexIndexOffset);
        if (group.members.isEmpty()) {
            return Collections.emptyList();
        }
        if (group.canFitInOneDex()) {
            VirtualFile currentDex;
            while (!this.assignAll(currentDex = cycler.nextOrCreate(dex -> !dexBlackList.contains(dex) && !this.isDexFull((VirtualFile)dex)), group.members)) {
            }
            return Collections.singletonList(currentDex);
        }
        VirtualFile dexForLinkingClasses = cycler.nextOrCreate(dex -> dex.isEmpty() && !dexBlackList.contains(dex) && !this.isDexFull((VirtualFile)dex));
        Set<DexProgramClass> remaining = this.assignFromRoot(dexForLinkingClasses, group.members);
        HashSet<VirtualFile> blackList = new HashSet<VirtualFile>(dexBlackList);
        blackList.add(dexForLinkingClasses);
        Collection<VirtualFile> usedDex = this.assignClassesWithLinkingError(remaining, blackList);
        usedDex.add(dexForLinkingClasses);
        return usedDex;
    }

    private Collection<VirtualFile> assignClassesWithLinkingError(Set<DexProgramClass> classes, Collection<VirtualFile> dexBlackList) throws DexOverflowException {
        List<ClassGroup> layers = this.collectNoDirectInheritanceGroups(classes);
        Collections.sort(layers);
        ArrayList<VirtualFile> usedDex = new ArrayList<VirtualFile>();
        VirtualFile.VirtualFileCycler cycler = new VirtualFile.VirtualFileCycler(this.dexes, this.namingLens, this.dexIndexOffset);
        HashSet<VirtualFile> currentBlackList = new HashSet<VirtualFile>(dexBlackList);
        currentBlackList.add(this.mainDex);
        for (ClassGroup group : layers) {
            cycler.reset();
            VirtualFile dexForLayer = cycler.nextOrCreate(dex -> !currentBlackList.contains(dex) && !this.isDexFull((VirtualFile)dex));
            currentBlackList.add(dexForLayer);
            usedDex.add(dexForLayer);
            for (DexProgramClass dexProgramClass : InheritanceClassInDexDistributor.getSortedCopy(group.members)) {
                while (true) {
                    dexForLayer.addClass(dexProgramClass);
                    if (!dexForLayer.isFull()) break;
                    dexForLayer.abortTransaction();
                    if (dexForLayer.isEmpty()) {
                        throw new DexOverflowException("Class '" + dexProgramClass.toSourceString() + "' from " + dexProgramClass.getOrigin().toString() + " is too big to fit in a dex.");
                    }
                    if (dexForLayer.isFull(65436)) {
                        this.markDexFull(dexForLayer);
                    }
                    dexForLayer = cycler.nextOrCreate(dex -> !currentBlackList.contains(dex) && !this.isDexFull((VirtualFile)dex));
                    currentBlackList.add(dexForLayer);
                    usedDex.add(dexForLayer);
                }
                dexForLayer.commitTransaction();
            }
        }
        return usedDex;
    }

    private List<ClassGroup> collectNoDirectInheritanceGroups(Set<DexProgramClass> classes) {
        int totalClassNumber = classes.size();
        List<DexProgramClass> sortedClasses = this.getTopologicalOrder(classes);
        assert (sortedClasses.size() == totalClassNumber);
        ArrayList<ClassGroup> layers = new ArrayList<ClassGroup>();
        HashMap<DexProgramClass, Integer> assignedLayer = Maps.newHashMapWithExpectedSize(classes.size());
        for (int i = sortedClasses.size() - 1; i >= 0; --i) {
            DexProgramClass toAssign = sortedClasses.get(i);
            Collection<DexProgramClass> subClasses = this.directSubClasses.getDirectSubClasses(toAssign);
            BitSet used = new BitSet();
            for (DexProgramClass subclass : subClasses) {
                used.set((Integer)assignedLayer.get(subclass));
            }
            int layer = used.nextClearBit(0);
            assignedLayer.put(toAssign, layer);
            if (layers.size() == layer) {
                layers.add(new ClassGroup());
            }
            layers.get((int)layer).members.add(toAssign);
        }
        this.updateGroupsNumberOfIds(layers);
        assert (totalClassNumber == InheritanceClassInDexDistributor.getTotalClassNumber(layers));
        return layers;
    }

    private List<ClassGroup> collectInheritanceGroups() {
        HashSet<DexProgramClass> remainingClasses = new HashSet<DexProgramClass>(this.classes);
        LinkedList<ClassGroup> groups = new LinkedList<ClassGroup>();
        while (!remainingClasses.isEmpty()) {
            DexProgramClass clazz = (DexProgramClass)remainingClasses.iterator().next();
            ClassGroup group = new ClassGroup();
            groups.add(group);
            this.collectGroup(remainingClasses, group, clazz);
            assert (!group.members.isEmpty());
        }
        this.updateGroupsNumberOfIds(groups);
        assert (this.classes.size() == InheritanceClassInDexDistributor.getTotalClassNumber(groups));
        return groups;
    }

    private void updateGroupsNumberOfIds(List<ClassGroup> groups) {
        ArrayList updateIdsTasks = new ArrayList(groups.size());
        for (ClassGroup group : groups) {
            updateIdsTasks.add(this.executorService.submit(() -> group.updateNumbersOfIds()));
        }
        try {
            ThreadUtils.awaitFutures(updateIdsTasks);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((Object)e);
        }
    }

    private void collectGroup(Collection<DexProgramClass> classes, ClassGroup group, DexProgramClass clazz) {
        if (clazz == null) {
            return;
        }
        if (!classes.remove(clazz)) {
            if (!group.dependsOnMainDexClasses) {
                group.dependsOnMainDexClasses = this.mainDex.classes().contains(clazz);
            }
            return;
        }
        group.members.add(clazz);
        this.collectGroup(classes, group, this.app.programDefinitionFor(clazz.superType));
        for (DexType interfaze : clazz.interfaces.values) {
            this.collectGroup(classes, group, this.app.programDefinitionFor(interfaze));
        }
        for (DexProgramClass directSubClass : this.directSubClasses.getDirectSubClasses(clazz)) {
            this.collectGroup(classes, group, directSubClass);
        }
    }

    private boolean assignAll(VirtualFile dex, Collection<DexProgramClass> classes) {
        int totalClasses = classes.size();
        int assignedClasses = 0;
        int dexInitialSize = dex.classes().size();
        for (DexProgramClass clazz : classes) {
            dex.addClass(clazz);
            ++assignedClasses;
            if (!dex.isFull()) continue;
            dex.abortTransaction();
            if (dex.isFull(65436)) {
                this.markDexFull(dex);
            }
            assert (dexInitialSize == dex.classes().size());
            return false;
        }
        dex.commitTransaction();
        assert (totalClasses == assignedClasses && dexInitialSize + assignedClasses == dex.classes().size());
        return true;
    }

    private Set<DexProgramClass> assignFromRoot(VirtualFile dex, Collection<DexProgramClass> classes) throws DexOverflowException {
        int totalClasses = classes.size();
        int assignedClasses = 0;
        int dexInitialSize = dex.classes().size();
        boolean isLayerFullyAssigned = true;
        HashSet<DexProgramClass> remaining = new HashSet<DexProgramClass>(classes);
        while (isLayerFullyAssigned && !remaining.isEmpty()) {
            HashSet<DexProgramClass> toProcess = remaining;
            remaining = new HashSet();
            boolean currentDexIsTooFull = false;
            for (DexProgramClass clazz : InheritanceClassInDexDistributor.getSortedCopy(toProcess)) {
                if (currentDexIsTooFull || this.hasDirectInheritanceInCollection(clazz, toProcess)) {
                    remaining.add(clazz);
                    continue;
                }
                dex.addClass(clazz);
                if (dex.isFull()) {
                    dex.abortTransaction();
                    if (dex.isEmpty()) {
                        throw new DexOverflowException("Class '" + clazz.toSourceString() + "' from " + clazz.getOrigin().toString() + " is too big to fit in a dex.");
                    }
                    isLayerFullyAssigned = false;
                    remaining.add(clazz);
                    if (!dex.isFull(65436)) continue;
                    this.markDexFull(dex);
                    currentDexIsTooFull = true;
                    continue;
                }
                ++assignedClasses;
                dex.commitTransaction();
            }
        }
        assert (totalClasses == assignedClasses + remaining.size() && dexInitialSize + assignedClasses == dex.classes().size());
        return remaining;
    }

    private boolean hasDirectInheritanceInCollection(DexProgramClass clazz, Set<DexProgramClass> collection) {
        if (collection.contains(this.app.programDefinitionFor(clazz.superType))) {
            return true;
        }
        for (DexType interfaze : clazz.interfaces.values) {
            if (!collection.contains(this.app.programDefinitionFor(interfaze))) continue;
            return true;
        }
        return false;
    }

    private boolean hasDirectSubclassInCollection(DexProgramClass clazz, Set<DexProgramClass> collection) {
        for (DexProgramClass subClass : this.directSubClasses.getDirectSubClasses(clazz)) {
            if (!collection.contains(subClass)) continue;
            return true;
        }
        return false;
    }

    private static List<DexProgramClass> getSortedCopy(Collection<DexProgramClass> collection) {
        ArrayList<DexProgramClass> sorted = new ArrayList<DexProgramClass>(collection);
        Collections.sort(sorted, DEX_PROGRAM_CLASS_COMPARATOR);
        return sorted;
    }

    private List<DexProgramClass> getTopologicalOrder(Set<DexProgramClass> classes) {
        ArrayList<DexProgramClass> result = new ArrayList<DexProgramClass>();
        while (!classes.isEmpty()) {
            DexProgramClass root = this.findOneRootInSetFrom(classes.iterator().next(), classes);
            classes.remove(root);
            result.add(root);
        }
        return result;
    }

    private DexProgramClass findOneRootInSetFrom(DexProgramClass searchFrom, Set<DexProgramClass> classSet) {
        DexProgramClass zuper = this.app.programDefinitionFor(searchFrom.superType);
        if (classSet.contains(zuper)) {
            return this.findOneRootInSetFrom(zuper, classSet);
        }
        for (DexType interfaceType : searchFrom.interfaces.values) {
            DexClass interfaceClass = this.app.definitionFor(interfaceType);
            if (!classSet.contains(interfaceClass)) continue;
            return this.findOneRootInSetFrom((DexProgramClass)interfaceClass, classSet);
        }
        return searchFrom;
    }

    private void markDexFull(VirtualFile dex) {
        this.fullDex.set(dex.getId());
    }

    private boolean isDexFull(VirtualFile dex) {
        return this.fullDex.get(dex.getId());
    }

    private static class DirectSubClassesInfo {
        private final Map<DexProgramClass, Collection<DexProgramClass>> directSubClasses;
        private final Set<DexProgramClass> classes;

        DirectSubClassesInfo(DexApplication app, Set<DexProgramClass> classes) {
            HashMap<DexProgramClass, Collection<DexProgramClass>> directSubClasses = new HashMap<DexProgramClass, Collection<DexProgramClass>>();
            for (DexProgramClass clazz : classes) {
                DirectSubClassesInfo.addDirectSubClass(app, classes, directSubClasses, clazz.superType, clazz);
                for (DexType interfaze : clazz.interfaces.values) {
                    DirectSubClassesInfo.addDirectSubClass(app, classes, directSubClasses, interfaze, clazz);
                }
            }
            this.classes = classes;
            this.directSubClasses = directSubClasses;
        }

        Collection<DexProgramClass> getDirectSubClasses(DexProgramClass clazz) {
            assert (this.classes.contains(clazz));
            return this.directSubClasses.getOrDefault(clazz, Collections.emptyList());
        }

        private static void addDirectSubClass(DexApplication app, Set<DexProgramClass> classes, Map<DexProgramClass, Collection<DexProgramClass>> directSubClasses, DexType superType, DexProgramClass clazz) {
            DexProgramClass zuper = app.programDefinitionFor(superType);
            if (zuper != null && classes.contains(zuper)) {
                Collection subClasses = directSubClasses.computeIfAbsent(zuper, unused -> new ArrayList());
                subClasses.add(clazz);
            }
        }
    }

    private class CategorizedInheritanceGroupWithMainDexDependency {
        final Set<DexProgramClass> mainDexIndependents = new HashSet<DexProgramClass>();
        final Set<DexProgramClass> independentsFromMainDexIndependents = new HashSet<DexProgramClass>();
        final Set<DexProgramClass> dependentsOfMainDexIndependents = new HashSet<DexProgramClass>();

        CategorizedInheritanceGroupWithMainDexDependency(ClassGroup group) {
            int totalClassNumber = group.members.size();
            HashSet<DexProgramClass> mainDexDependents = new HashSet<DexProgramClass>();
            for (DexProgramClass candidate : group.members) {
                this.isDependingOnMainDexClass(mainDexDependents, candidate);
            }
            for (DexProgramClass candidate : mainDexDependents) {
                this.isDependingOnMainDexIndependents(candidate);
            }
            assert (totalClassNumber == this.mainDexIndependents.size() + this.dependentsOfMainDexIndependents.size() + this.independentsFromMainDexIndependents.size());
        }

        private boolean isDependingOnMainDexClass(Set<DexProgramClass> mainDexDependents, DexProgramClass dexProgramClass) {
            if (dexProgramClass == null) {
                return false;
            }
            if (this.mainDexIndependents.contains(dexProgramClass)) {
                return false;
            }
            if (mainDexDependents.contains(dexProgramClass)) {
                return true;
            }
            if (InheritanceClassInDexDistributor.this.mainDex.classes().contains(dexProgramClass)) {
                return true;
            }
            boolean isDependent = false;
            if (this.isDependingOnMainDexClass(mainDexDependents, InheritanceClassInDexDistributor.this.app.programDefinitionFor(dexProgramClass.superType))) {
                isDependent = true;
            } else {
                for (DexType interfaze : dexProgramClass.interfaces.values) {
                    if (!this.isDependingOnMainDexClass(mainDexDependents, InheritanceClassInDexDistributor.this.app.programDefinitionFor(interfaze))) continue;
                    isDependent = true;
                    break;
                }
            }
            if (isDependent) {
                mainDexDependents.add(dexProgramClass);
            } else {
                this.mainDexIndependents.add(dexProgramClass);
            }
            return isDependent;
        }

        private boolean isDependingOnMainDexIndependents(DexProgramClass dexProgramClass) {
            if (dexProgramClass == null) {
                return false;
            }
            if (this.independentsFromMainDexIndependents.contains(dexProgramClass)) {
                return false;
            }
            if (this.dependentsOfMainDexIndependents.contains(dexProgramClass)) {
                return true;
            }
            if (InheritanceClassInDexDistributor.this.mainDex.classes().contains(dexProgramClass)) {
                return false;
            }
            if (this.mainDexIndependents.contains(dexProgramClass)) {
                return true;
            }
            boolean isDependent = false;
            if (this.isDependingOnMainDexIndependents(InheritanceClassInDexDistributor.this.app.programDefinitionFor(dexProgramClass.superType))) {
                isDependent = true;
            } else {
                for (DexType interfaze : dexProgramClass.interfaces.values) {
                    if (!this.isDependingOnMainDexIndependents(InheritanceClassInDexDistributor.this.app.programDefinitionFor(interfaze))) continue;
                    isDependent = true;
                    break;
                }
            }
            if (isDependent) {
                this.dependentsOfMainDexIndependents.add(dexProgramClass);
            } else {
                this.independentsFromMainDexIndependents.add(dexProgramClass);
            }
            return isDependent;
        }
    }

    private class ClassGroup
    implements Comparable<ClassGroup> {
        public final Set<DexProgramClass> members;
        public int numberOfFieldIds = -1;
        public int numberOfMethodIds = -1;
        public boolean dependsOnMainDexClasses = false;

        public ClassGroup() {
            this.members = new HashSet<DexProgramClass>();
        }

        public ClassGroup(Set<DexProgramClass> members) {
            this.members = members;
            this.updateNumbersOfIds();
        }

        public void updateNumbersOfIds() {
            VirtualFile virtualFile = new VirtualFile(0, InheritanceClassInDexDistributor.this.namingLens);
            for (DexProgramClass clazz : this.members) {
                virtualFile.addClass(clazz);
            }
            this.numberOfFieldIds = virtualFile.getNumberOfFields();
            this.numberOfMethodIds = virtualFile.getNumberOfMethods();
        }

        public boolean canFitInOneDex() {
            return this.numberOfFieldIds < 65536 && this.numberOfMethodIds < 65536;
        }

        @Override
        public int compareTo(ClassGroup other) {
            assert (!this.members.isEmpty() && !other.members.isEmpty() && this.numberOfFieldIds != -1 && this.numberOfMethodIds != -1);
            if (this == other) {
                return 0;
            }
            if (this.numberOfMethodIds != other.numberOfMethodIds) {
                return this.numberOfMethodIds - other.numberOfMethodIds;
            }
            if (this.numberOfFieldIds != other.numberOfFieldIds) {
                return this.numberOfFieldIds - other.numberOfFieldIds;
            }
            if (this.members.size() != other.members.size()) {
                return this.members.size() - other.members.size();
            }
            int result = DEX_PROGRAM_CLASS_COMPARATOR.compare((DexProgramClass)InheritanceClassInDexDistributor.getSortedCopy(this.members).iterator().next(), (DexProgramClass)InheritanceClassInDexDistributor.getSortedCopy(other.members).iterator().next());
            assert (result != 0);
            return result;
        }
    }
}

