/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.ArchiveBuilder;
import com.android.tools.r8.utils.DirectoryBuilder;
import com.android.tools.r8.utils.ExceptionDiagnostic;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.OutputBuilder;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;

public interface DexIndexedConsumer
extends ProgramConsumer {
    public void accept(int var1, byte[] var2, Set<String> var3, DiagnosticsHandler var4);

    public static DexIndexedConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        private final Path directory;
        private boolean preparedDirectory = false;
        private final OutputBuilder outputBuilder;
        protected final boolean consumeDataResouces;

        public DirectoryConsumer(Path directory) {
            this(directory, null, false);
        }

        public DirectoryConsumer(Path directory, boolean consumeDataResouces) {
            this(directory, null, consumeDataResouces);
        }

        public DirectoryConsumer(Path directory, DexIndexedConsumer consumer) {
            this(directory, consumer, false);
        }

        public DirectoryConsumer(Path directory, DexIndexedConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.directory = directory;
            this.outputBuilder = new DirectoryBuilder(directory);
            this.consumeDataResouces = consumeDataResouces;
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResouces ? this : null;
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(fileIndex, data, descriptors, handler);
            try {
                this.prepareDirectory();
            }
            catch (IOException e) {
                handler.error(new ExceptionDiagnostic(e, new PathOrigin(this.directory)));
            }
            this.outputBuilder.addFile(this.getDexFileName(fileIndex), data, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            this.outputBuilder.close(handler);
        }

        private synchronized void prepareDirectory() throws IOException {
            if (this.preparedDirectory) {
                return;
            }
            this.preparedDirectory = true;
            DirectoryConsumer.deleteClassesDexFiles(this.directory);
        }

        static void deleteClassesDexFiles(Path directory) throws IOException {
            try (Stream<Path> filesInDir = Files.list(directory);){
                for (Path path : filesInDir.collect(Collectors.toList())) {
                    if (!FileUtils.isClassesDexFile(path)) continue;
                    Files.delete(path);
                }
            }
        }

        public static void writeResources(Path directory, List<ProgramResource> resources) throws IOException, ResourceException {
            DirectoryConsumer.deleteClassesDexFiles(directory);
            try (Closer closer = Closer.create();){
                for (int i = 0; i < resources.size(); ++i) {
                    ProgramResource resource = resources.get(i);
                    Path target = DirectoryConsumer.getTargetDexFile(directory, i);
                    DirectoryConsumer.writeFile(ByteStreams.toByteArray(closer.register(resource.getByteStream())), target);
                }
            }
        }

        private static Path getTargetDexFile(Path directory, int fileIndex) {
            return directory.resolve(ForwardingConsumer.getDefaultDexFileName(fileIndex));
        }

        private static void writeFile(byte[] contents, Path target) throws IOException {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            FileUtils.writeToFile(target, null, contents);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements DataResourceConsumer,
    InternalProgramOutputPathConsumer {
        protected final OutputBuilder outputBuilder;
        protected final boolean consumeDataResources;

        public ArchiveConsumer(Path archive) {
            this(archive, null, false);
        }

        public ArchiveConsumer(Path archive, boolean consumeDataResouces) {
            this(archive, null, consumeDataResouces);
        }

        public ArchiveConsumer(Path archive, DexIndexedConsumer consumer) {
            this(archive, consumer, false);
        }

        public ArchiveConsumer(Path archive, DexIndexedConsumer consumer, boolean consumeDataResouces) {
            super(consumer);
            this.outputBuilder = new ArchiveBuilder(archive);
            this.consumeDataResources = consumeDataResouces;
            this.outputBuilder.open();
            if (this.getDataResourceConsumer() != null) {
                this.outputBuilder.open();
            }
        }

        public Origin getOrigin() {
            return this.outputBuilder.getOrigin();
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumeDataResources ? this : null;
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(fileIndex, data, descriptors, handler);
            this.outputBuilder.addFile(this.getDexFileName(fileIndex), data, handler);
        }

        @Override
        public void accept(DataDirectoryResource directory, DiagnosticsHandler handler) {
            this.outputBuilder.addDirectory(directory.getName(), handler);
        }

        @Override
        public void accept(DataEntryResource file, DiagnosticsHandler handler) {
            this.outputBuilder.addFile(file.getName(), file, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            this.outputBuilder.close(handler);
        }

        public static void writeResources(Path archive, List<ProgramResource> resources) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            try (Closer closer = Closer.create();
                 ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(archive, options));){
                for (int i = 0; i < resources.size(); ++i) {
                    ProgramResource resource = resources.get(i);
                    String entryName = ArchiveConsumer.getDefaultDexFileName(i);
                    byte[] bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
                    ZipUtils.writeToZipStream(out, entryName, bytes, 0);
                }
            }
        }

        @Override
        public Path internalGetOutputPath() {
            return this.outputBuilder.getPath();
        }
    }

    public static class ForwardingConsumer
    implements DexIndexedConsumer {
        private static final DexIndexedConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final DexIndexedConsumer consumer;

        public ForwardingConsumer(DexIndexedConsumer consumer) {
            this.consumer = consumer;
        }

        protected static String getDefaultDexFileName(int fileIndex) {
            return fileIndex == 0 ? "classes.dex" : "classes" + (fileIndex + 1) + ".dex";
        }

        protected String getDexFileName(int fileIndex) {
            return ForwardingConsumer.getDefaultDexFileName(fileIndex);
        }

        @Override
        public DataResourceConsumer getDataResourceConsumer() {
            return this.consumer != null ? this.consumer.getDataResourceConsumer() : null;
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(fileIndex, data, descriptors, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

