/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.utils.PathUtils;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class RuntimeAnnotatedClassCollector {
    private final ForkJoinPool forkJoinPool;
    private final Predicate<byte[]> keepClassPredicate;

    public RuntimeAnnotatedClassCollector(Predicate<byte[]> keepClassPredicate) throws InterruptedException {
        this.keepClassPredicate = keepClassPredicate;
        this.forkJoinPool = ForkJoinPool.commonPool();
    }

    private static List<String> kept(Path input, Predicate<byte[]> keepClassPredicate) throws IOException {
        if (Files.isDirectory(input, new LinkOption[0])) {
            return RuntimeAnnotatedClassCollector.keptFromDir(input, keepClassPredicate);
        }
        if (Files.isRegularFile(input, new LinkOption[0])) {
            return RuntimeAnnotatedClassCollector.keptFromJar(input, keepClassPredicate);
        }
        throw new IOException("Could not open input file or dir: " + input);
    }

    private static List<String> keptFromDir(final Path inputDir, final Predicate<byte[]> keepClassPredicate) throws IOException {
        final ArrayList<String> classes = new ArrayList<String>();
        Files.walkFileTree(inputDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!RuntimeAnnotatedClassCollector.isClass(file.getFileName().toString())) {
                    return FileVisitResult.CONTINUE;
                }
                if (!keepClassPredicate.test(Files.readAllBytes(file))) {
                    return FileVisitResult.CONTINUE;
                }
                classes.add(PathUtils.toSystemIndependentPath((Path)inputDir.relativize(file)));
                return FileVisitResult.CONTINUE;
            }
        });
        return classes;
    }

    private static List<String> keptFromJar(Path inputJar, Predicate<byte[]> keepClassPredicate) throws IOException {
        ArrayList<String> classes = new ArrayList<String>();
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(inputJar, new OpenOption[0]));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String name = entry.getName();
                if (!RuntimeAnnotatedClassCollector.isClass(name) || !keepClassPredicate.test(ByteStreams.toByteArray((InputStream)zipInputStream))) continue;
                classes.add(name);
            }
        }
        return classes;
    }

    private static boolean isClass(String name) {
        return com.google.common.io.Files.getFileExtension((String)name).equalsIgnoreCase("class");
    }

    public Set<String> collectClasses(Collection<Path> inputs) throws InterruptedException {
        ArrayList<Future> subTasks = new ArrayList<Future>();
        for (Path input : inputs) {
            subTasks.add(this.forkJoinPool.submit(() -> RuntimeAnnotatedClassCollector.kept(input, this.keepClassPredicate)));
        }
        try {
            return subTasks.stream().map(ForkJoinTask::join).flatMap(Collection::stream).collect(Collectors.toSet());
        }
        catch (RuntimeException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw e;
        }
    }
}

