/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.BaseCompilerCommandParser;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.CompilationMode;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.OutputMode;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.FlagFile;
import com.android.tools.r8.utils.StringDiagnostic;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;

public class D8CommandParser
extends BaseCompilerCommandParser {
    static final String USAGE_MESSAGE = String.join((CharSequence)"\n", Arrays.asList("Usage: d8 [options] <input-files>", " where <input-files> are any combination of dex, class, zip, jar, or apk files", " and options are:", "  --debug                 # Compile with debugging information (default).", "  --release               # Compile without debugging information.", "  --output <file>         # Output result in <outfile>.", "                          # <file> must be an existing directory or a zip file.", "  --lib <file>            # Add <file> as a library resource.", "  --classpath <file>      # Add <file> as a classpath resource.", "  --min-api               # Minimum Android API level compatibility", "  --intermediate          # Compile an intermediate result intended for later", "                          # merging.", "  --file-per-class        # Produce a separate dex file per input class", "  --no-desugaring         # Force disable desugaring.", "  --main-dex-list <file>  # List of classes to place in the primary dex file.", "  --version               # Print the version of d8.", "  --help                  # Print this message."));

    public static void main(String[] args) throws CompilationFailedException {
        D8Command command = (D8Command)D8CommandParser.parse(args, Origin.root()).build();
        if (command.isPrintHelp()) {
            System.out.println(USAGE_MESSAGE);
            System.exit(1);
        }
        D8.run(command);
    }

    public static D8Command.Builder parse(String[] args, Origin origin) {
        return D8CommandParser.parse(args, origin, D8Command.builder());
    }

    public static D8Command.Builder parse(String[] args, Origin origin, DiagnosticsHandler handler) {
        return D8CommandParser.parse(args, origin, D8Command.builder(handler));
    }

    private static D8Command.Builder parse(String[] args, Origin origin, D8Command.Builder builder) {
        CompilationMode compilationMode = null;
        Path outputPath = null;
        OutputMode outputMode = null;
        boolean hasDefinedApiLevel = false;
        String[] expandedArgs = FlagFile.expandFlagFiles(args, builder);
        try {
            for (int i = 0; i < expandedArgs.length; ++i) {
                String arg = expandedArgs[i].trim();
                if (arg.length() == 0) continue;
                if (arg.equals("--help")) {
                    builder.setPrintHelp(true);
                    continue;
                }
                if (arg.equals("--version")) {
                    builder.setPrintVersion(true);
                    continue;
                }
                if (arg.equals("--debug")) {
                    if (compilationMode == CompilationMode.RELEASE) {
                        builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                        continue;
                    }
                    compilationMode = CompilationMode.DEBUG;
                    continue;
                }
                if (arg.equals("--release")) {
                    if (compilationMode == CompilationMode.DEBUG) {
                        builder.error(new StringDiagnostic("Cannot compile in both --debug and --release mode.", origin));
                        continue;
                    }
                    compilationMode = CompilationMode.RELEASE;
                    continue;
                }
                if (arg.equals("--file-per-class")) {
                    outputMode = OutputMode.DexFilePerClassFile;
                    continue;
                }
                if (arg.equals("--output")) {
                    String output = expandedArgs[++i];
                    if (outputPath != null) {
                        builder.error(new StringDiagnostic("Cannot output both to '" + outputPath.toString() + "' and '" + output + "'", origin));
                        continue;
                    }
                    outputPath = Paths.get(output, new String[0]);
                    continue;
                }
                if (arg.equals("--lib")) {
                    builder.addLibraryFiles(Paths.get(expandedArgs[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--classpath")) {
                    builder.addClasspathFiles(Paths.get(expandedArgs[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--main-dex-list")) {
                    builder.addMainDexListFiles(Paths.get(expandedArgs[++i], new String[0]));
                    continue;
                }
                if (arg.equals("--optimize-multidex-for-linearalloc")) {
                    builder.setOptimizeMultidexForLinearAlloc(true);
                    continue;
                }
                if (arg.equals("--min-api")) {
                    String minApiString = expandedArgs[++i];
                    if (hasDefinedApiLevel) {
                        builder.error(new StringDiagnostic("Cannot set multiple --min-api options", origin));
                        continue;
                    }
                    D8CommandParser.parseMinApi(builder, minApiString, origin);
                    hasDefinedApiLevel = true;
                    continue;
                }
                if (arg.equals("--intermediate")) {
                    builder.setIntermediate(true);
                    continue;
                }
                if (arg.equals("--no-desugaring")) {
                    builder.setDisableDesugaring(true);
                    continue;
                }
                if (arg.startsWith("--")) {
                    builder.error(new StringDiagnostic("Unknown option: " + arg, origin));
                    continue;
                }
                builder.addProgramFiles(Paths.get(arg, new String[0]));
            }
            if (compilationMode != null) {
                builder.setMode(compilationMode);
            }
            if (outputMode == null) {
                outputMode = OutputMode.DexIndexed;
            }
            if (outputPath == null) {
                outputPath = Paths.get(".", new String[0]);
            }
            return (D8Command.Builder)builder.setOutput(outputPath, outputMode);
        }
        catch (CompilationError e) {
            throw builder.fatalError(e);
        }
    }
}

