/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.ArchiveClassFileProvider;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarClassFileReader;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.InternalOptions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class JarDiff {
    private static final String USAGE = "Arguments: <input1.jar> <input2.jar>\n\nJarDiff computes the difference between two JAR files that contain Java classes.\n\nOnly method codes are compared. Fields, parameters, annotations, generic\nsignatures etc. are ignored.\n\nNote: Jump targets are ignored, so if two methods differ only in what label an\nIF or GOTO instruction jumps to, no difference is output.";
    private final Path path1;
    private final Path path2;
    private final int before;
    private final int after;
    private final JarApplicationReader applicationReader;
    private ArchiveClassFileProvider archive1;
    private ArchiveClassFileProvider archive2;

    public static void main(String[] args) throws Exception {
        JarDiff jarDiff = JarDiff.parse(args);
        if (jarDiff == null) {
            System.out.println(USAGE);
        } else {
            jarDiff.run();
        }
    }

    public static JarDiff parse(String[] args) {
        int arg = 0;
        int before = 3;
        int after = 3;
        while (arg + 1 < args.length) {
            if (args[arg].equals("-B")) {
                before = Integer.parseInt(args[arg + 1]);
                arg += 2;
                continue;
            }
            if (!args[arg].equals("-A")) break;
            after = Integer.parseInt(args[arg + 1]);
            arg += 2;
        }
        if (args.length != arg + 2) {
            return null;
        }
        return new JarDiff(Paths.get(args[arg], new String[0]), Paths.get(args[arg + 1], new String[0]), before, after);
    }

    public JarDiff(Path path1, Path path2, int before, int after) {
        this.path1 = path1;
        this.path2 = path2;
        this.before = before;
        this.after = after;
        InternalOptions options = new InternalOptions();
        options.enableCfFrontend = true;
        this.applicationReader = new JarApplicationReader(options);
    }

    public void run() throws Exception {
        this.archive1 = new ArchiveClassFileProvider(this.path1);
        this.archive2 = new ArchiveClassFileProvider(this.path2);
        for (String descriptor : this.getCommonDescriptors()) {
            byte[] bytes2;
            byte[] bytes1 = this.getClassAsBytes(this.archive1, descriptor);
            if (Arrays.equals(bytes1, bytes2 = this.getClassAsBytes(this.archive2, descriptor))) continue;
            DexProgramClass class1 = this.getDexProgramClass(this.path1, bytes1);
            DexProgramClass class2 = this.getDexProgramClass(this.path2, bytes2);
            this.compareMethods(class1, class2);
        }
    }

    private List<String> getCommonDescriptors() {
        List<String> descriptors2;
        List<String> descriptors1 = this.getSortedDescriptorList(this.archive1);
        if (descriptors1.equals(descriptors2 = this.getSortedDescriptorList(this.archive2))) {
            return descriptors1;
        }
        List<String> only1 = JarDiff.setMinus(descriptors1, descriptors2);
        List<String> only2 = JarDiff.setMinus(descriptors2, descriptors1);
        if (!only1.isEmpty()) {
            System.out.println("Only in " + this.path1 + ": " + only1);
        }
        if (!only2.isEmpty()) {
            System.out.println("Only in " + this.path2 + ": " + only2);
        }
        return JarDiff.setIntersection(descriptors1, descriptors2);
    }

    private List<String> getSortedDescriptorList(ArchiveClassFileProvider inputJar) {
        ArrayList<String> descriptorList = new ArrayList<String>(inputJar.getClassDescriptors());
        Collections.sort(descriptorList);
        return descriptorList;
    }

    private byte[] getClassAsBytes(ArchiveClassFileProvider inputJar, String descriptor) throws Exception {
        return ByteStreams.toByteArray(inputJar.getProgramResource(descriptor).getByteStream());
    }

    private DexProgramClass getDexProgramClass(Path path, byte[] bytes) throws IOException {
        class Collector
        implements Consumer<DexClass> {
            private DexClass dexClass;

            Collector() {
            }

            @Override
            public void accept(DexClass dexClass) {
                this.dexClass = dexClass;
            }

            public DexClass get() {
                assert (this.dexClass != null);
                return this.dexClass;
            }
        }
        Collector collector = new Collector();
        JarClassFileReader reader = new JarClassFileReader(this.applicationReader, collector);
        reader.read(new PathOrigin(path), ClassKind.PROGRAM, new ByteArrayInputStream(bytes));
        return collector.get().asProgramClass();
    }

    private void compareMethods(DexProgramClass class1, DexProgramClass class2) {
        class1.forEachMethod(method1 -> {
            DexEncodedMethod method2 = class2.lookupMethod(method1.method);
            if (method2 == null) {
                this.compareMethods((DexEncodedMethod)method1, method2);
            }
        });
        class2.forEachMethod(method2 -> {
            DexEncodedMethod method1 = class1.lookupMethod(method2.method);
            this.compareMethods(method1, (DexEncodedMethod)method2);
        });
    }

    private void compareMethods(DexEncodedMethod m1, DexEncodedMethod m2) {
        int k;
        List<String> code2;
        if (m1 == null) {
            System.out.println("Only in " + this.path2 + ": " + m2.method.toSourceString());
            return;
        }
        if (m2 == null) {
            System.out.println("Only in " + this.path1 + ": " + m1.method.toSourceString());
            return;
        }
        List<String> code1 = JarDiff.getInstructionStrings(m1);
        if (code1.equals(code2 = JarDiff.getInstructionStrings(m2))) {
            return;
        }
        int i = JarDiff.getCommonPrefix(code1, code2);
        int j = JarDiff.getCommonSuffix(code1, code2);
        int length1 = code1.size() - i - j;
        int length2 = code2.size() - i - j;
        int before = Math.min(i, this.before);
        int after = Math.min(j, this.after);
        int context = before + after;
        System.out.println("--- " + this.path1 + "/" + m1.method.toSmaliString());
        System.out.println("+++ " + this.path2 + "/" + m2.method.toSmaliString());
        System.out.println("@@ -" + (i - before) + "," + (length1 + context) + " +" + (i - before) + "," + (length2 + context) + " @@ " + m1.method.toSourceString());
        for (k = 0; k < before; ++k) {
            System.out.println(" " + code1.get(i - before + k));
        }
        for (k = 0; k < length1; ++k) {
            System.out.println("-" + code1.get(i + k));
        }
        for (k = 0; k < length2; ++k) {
            System.out.println("+" + code2.get(i + k));
        }
        for (k = 0; k < after; ++k) {
            System.out.println(" " + code1.get(i + length1 + k));
        }
    }

    private static List<String> getInstructionStrings(DexEncodedMethod method) {
        List<CfInstruction> instructions = method.getCode().asCfCode().getInstructions();
        return instructions.stream().map(CfInstruction::toString).collect(Collectors.toList());
    }

    private static List<String> setIntersection(List<String> set1, List<String> set2) {
        ArrayList<String> result = new ArrayList<String>(set1);
        result.retainAll(new HashSet<String>(set2));
        return result;
    }

    private static List<String> setMinus(List<String> set, List<String> toRemove) {
        ArrayList<String> result = new ArrayList<String>(set);
        result.removeAll(new HashSet<String>(toRemove));
        return result;
    }

    private static int getCommonPrefix(List<String> code1, List<String> code2) {
        int i;
        for (i = 0; i < code1.size() && i < code2.size() && code1.get(i).equals(code2.get(i)); ++i) {
        }
        return i;
    }

    private static int getCommonSuffix(List<String> code1, List<String> code2) {
        int j;
        for (j = 0; j < code1.size() && j < code2.size() && code1.get(code1.size() - j - 1).equals(code2.get(code2.size() - j - 1)); ++j) {
        }
        return j;
    }
}

