/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import java.nio.ShortBuffer;
import java.util.function.BiPredicate;

public abstract class Format3rc
extends Base3Format {
    public final short AA;
    public final char CCCC;
    public IndexedDexItem BBBB;

    Format3rc(int high, BytecodeStream stream, IndexedDexItem[] map) {
        super(stream);
        this.AA = (short)high;
        this.BBBB = map[Format3rc.read16BitValue(stream)];
        this.CCCC = Format3rc.read16BitValue(stream);
    }

    Format3rc(int firstArgumentRegister, int argumentCount, IndexedDexItem dexItem) {
        assert (0 <= firstArgumentRegister && firstArgumentRegister <= 65535);
        assert (0 <= argumentCount && argumentCount <= 255);
        this.CCCC = (char)firstArgumentRegister;
        this.AA = (short)argumentCount;
        this.BBBB = dexItem;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.writeFirst(this.AA, dest);
        this.write16BitReference(this.BBBB, dest, mapping);
        this.write16BitValue(this.CCCC, dest);
    }

    @Override
    public final int hashCode() {
        return (this.CCCC << 24 | this.BBBB.hashCode() << 4 | this.AA) ^ this.getClass().hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format3rc o = (Format3rc)other;
        return o.AA == this.AA && o.CCCC == this.CCCC && o.BBBB.equals(this.BBBB);
    }

    private void appendRegisterRange(StringBuilder builder) {
        char firstRegister = this.CCCC;
        builder.append("{ ");
        builder.append("v").append((int)firstRegister);
        if (this.AA != 1) {
            builder.append(" .. v").append(firstRegister + this.AA - 1);
        }
        builder.append(" }");
    }

    @Override
    public String toString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterRange(builder);
        builder.append(" ");
        if (naming == null) {
            builder.append(this.BBBB.toSmaliString());
        } else {
            builder.append(naming.originalNameOf(this.BBBB));
        }
        return this.formatString(builder.toString());
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        StringBuilder builder = new StringBuilder();
        this.appendRegisterRange(builder);
        builder.append(", ");
        builder.append(this.BBBB.toSmaliString());
        return this.formatSmaliString(builder.toString());
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems, DexMethod method, int instructionOffset) {
        this.BBBB.collectIndexedItems(indexedItems, method, instructionOffset);
    }

    @Override
    public boolean equals(Instruction other, BiPredicate<IndexedDexItem, IndexedDexItem> equality) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format3rc o = (Format3rc)other;
        return o.AA == this.AA && o.CCCC == this.CCCC && equality.test(this.BBBB, o.BBBB);
    }
}

