/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.lambda.kotlin;

import com.android.tools.r8.code.Const16;
import com.android.tools.r8.code.Const4;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeDirect;
import com.android.tools.r8.code.InvokeDirectRange;
import com.android.tools.r8.code.ReturnVoid;
import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.LambdaGroupClassBuilder;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinInstanceInitializerSourceCode;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaClassValidator;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroup;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupClassBuilder;
import com.android.tools.r8.ir.optimize.lambda.kotlin.KotlinLambdaGroupId;
import com.android.tools.r8.ir.synthetic.SyntheticSourceCode;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.util.function.IntFunction;

final class KStyleLambdaGroup
extends KotlinLambdaGroup {
    private KStyleLambdaGroup(GroupId id) {
        super(id);
    }

    @Override
    protected LambdaGroupClassBuilder getBuilder(DexItemFactory factory) {
        return new ClassBuilder(factory, "kotlin-style lambda group");
    }

    @Override
    public ThrowingConsumer<DexClass, LambdaGroup.LambdaStructureError> lambdaClassValidator(Kotlin kotlin, AppInfoWithSubtyping appInfo) {
        return new ClassValidator(kotlin, appInfo);
    }

    @Override
    protected String getGroupSuffix() {
        return "ks$";
    }

    private static final class InstanceInitializerSourceCode
    extends KotlinInstanceInitializerSourceCode {
        private final int arity;
        private final DexMethod lambdaInitializer;

        InstanceInitializerSourceCode(DexItemFactory factory, DexType lambdaGroupType, DexField idField, IntFunction<DexField> fieldGenerator, DexProto proto, int arity) {
            super(lambdaGroupType, idField, fieldGenerator, proto);
            this.arity = arity;
            this.lambdaInitializer = factory.createMethod(factory.kotlin.functional.lambdaType, factory.createProto(factory.voidType, factory.intType), factory.constructorMethodName);
        }

        @Override
        void prepareSuperConstructorCall(int receiverRegister) {
            int arityRegister = this.nextRegister(ValueType.INT);
            this.add(builder -> builder.addConst(ValueType.INT, arityRegister, this.arity));
            this.add(builder -> builder.addInvoke(Invoke.Type.DIRECT, (DexItem)this.lambdaInitializer, this.lambdaInitializer.proto, Lists.newArrayList(ValueType.OBJECT, ValueType.INT), Lists.newArrayList(receiverRegister, arityRegister)));
        }
    }

    private final class ClassBuilder
    extends KotlinLambdaGroupClassBuilder<KStyleLambdaGroup> {
        ClassBuilder(DexItemFactory factory, String origin) {
            super(KStyleLambdaGroup.this, factory, origin);
        }

        @Override
        protected DexType getSuperClassType() {
            return this.factory.kotlin.functional.lambdaType;
        }

        @Override
        SyntheticSourceCode createInstanceInitializerSourceCode(DexType groupClassType, DexProto initializerProto) {
            return new InstanceInitializerSourceCode(this.factory, groupClassType, ((KStyleLambdaGroup)this.group).getLambdaIdField(this.factory), id -> ((KStyleLambdaGroup)this.group).getCaptureField(this.factory, id), initializerProto, this.id.mainMethodProto.parameters.size());
        }
    }

    private final class ClassValidator
    extends KotlinLambdaClassValidator {
        ClassValidator(Kotlin kotlin, AppInfoWithSubtyping appInfo) {
            super(kotlin, KStyleLambdaGroup.this, appInfo);
        }

        @Override
        int getInstanceInitializerSize(DexEncodedField[] captures) {
            return captures.length + 3;
        }

        @Override
        int validateInstanceInitializerEpilogue(Instruction[] instructions, int index) throws LambdaGroup.LambdaStructureError {
            if (!(instructions[index] instanceof Const4) && !(instructions[index] instanceof Const16)) {
                throw this.structureError("instance initializer code verification failed");
            }
            if (!(instructions[++index] instanceof InvokeDirect) && !(instructions[index] instanceof InvokeDirectRange) || instructions[index].getMethod() != this.kotlin.functional.lambdaInitializerMethod) {
                throw this.structureError("instance initializer code verification failed");
            }
            if (!(instructions[++index] instanceof ReturnVoid)) {
                throw this.structureError("instance initializer code verification failed");
            }
            return index + 1;
        }
    }

    static final class GroupId
    extends KotlinLambdaGroupId {
        GroupId(String capture, DexType iface, String pkg, String signature, DexEncodedMethod mainMethod, InnerClassAttribute inner, EnclosingMethodAttribute enclosing) {
            super(capture, iface, pkg, signature, mainMethod, inner, enclosing);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof GroupId && this.computeEquals((KotlinLambdaGroupId)obj);
        }

        @Override
        String getLambdaKindDescriptor() {
            return "Kotlin k-style lambda group";
        }

        @Override
        public LambdaGroup createGroup() {
            return new KStyleLambdaGroup(this);
        }
    }
}

