/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar;

import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.desugar.AccessorMethodSourceCode;
import com.android.tools.r8.ir.desugar.LambdaBridgeMethodSourceCode;
import com.android.tools.r8.ir.desugar.LambdaClassConstructorSourceCode;
import com.android.tools.r8.ir.desugar.LambdaConstructorSourceCode;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.ir.desugar.LambdaMainMethodSourceCode;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.ir.synthetic.SynthesizedCode;
import com.android.tools.r8.origin.SynthesizedOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class LambdaClass {
    final LambdaRewriter rewriter;
    final DexType type;
    final LambdaDescriptor descriptor;
    final DexMethod constructor;
    final DexMethod classConstructor;
    final DexField instanceField;
    final Target target;
    final AtomicBoolean addToMainDexList = new AtomicBoolean(false);
    private final Collection<DexProgramClass> synthesizedFrom = new ArrayList<DexProgramClass>(1);

    LambdaClass(LambdaRewriter rewriter, DexType accessedFrom, DexType lambdaClassType, LambdaDescriptor descriptor) {
        assert (rewriter != null);
        assert (lambdaClassType != null);
        assert (descriptor != null);
        this.rewriter = rewriter;
        this.type = lambdaClassType;
        this.descriptor = descriptor;
        DexItemFactory factory = rewriter.factory;
        DexProto constructorProto = factory.createProto(factory.voidType, descriptor.captures.values);
        this.constructor = factory.createMethod(lambdaClassType, constructorProto, rewriter.constructorName);
        this.target = this.createTarget(accessedFrom);
        boolean stateless = this.isStateless();
        this.classConstructor = !stateless ? null : factory.createMethod(lambdaClassType, constructorProto, rewriter.classConstructorName);
        this.instanceField = !stateless ? null : factory.createField(lambdaClassType, lambdaClassType, rewriter.instanceFieldName);
        rewriter.appInfo.registerNewType(this.type, factory.objectType);
    }

    static DexType createLambdaClassType(LambdaRewriter rewriter, DexType accessedFrom, LambdaDescriptor match) {
        StringBuilder lambdaClassDescriptor = new StringBuilder("L");
        String packageDescriptor = accessedFrom.getPackageDescriptor();
        if (!packageDescriptor.isEmpty()) {
            lambdaClassDescriptor.append(packageDescriptor).append('/');
        }
        lambdaClassDescriptor.append("-$$Lambda$");
        if (match.delegatesToLambdaImplMethod() || match.needsAccessor(accessedFrom)) {
            lambdaClassDescriptor.append(accessedFrom.getName()).append('$');
        }
        lambdaClassDescriptor.append(match.uniqueId).append(';');
        return rewriter.factory.createType(lambdaClassDescriptor.toString());
    }

    final DexProgramClass synthesizeLambdaClass() {
        return new DexProgramClass(this.type, null, new SynthesizedOrigin("lambda desugaring", this.getClass()), ClassAccessFlags.fromDexAccessFlags(4113), this.rewriter.factory.objectType, this.buildInterfaces(), this.rewriter.factory.createString("lambda"), null, Collections.emptyList(), DexAnnotationSet.empty(), this.synthesizeStaticFields(), this.synthesizeInstanceFields(), this.synthesizeDirectMethods(), this.synthesizeVirtualMethods(), this.rewriter.factory.getSkipNameValidationForTesting(), this.synthesizedFrom);
    }

    final DexField getCaptureField(int index) {
        return this.rewriter.factory.createField(this.type, this.descriptor.captures.values[index], this.rewriter.factory.createString("f$" + index));
    }

    final boolean isStateless() {
        return this.descriptor.isStateless();
    }

    synchronized void addSynthesizedFrom(DexProgramClass synthesizedFrom) {
        assert (synthesizedFrom != null);
        this.synthesizedFrom.add(synthesizedFrom);
    }

    private DexEncodedMethod[] synthesizeVirtualMethods() {
        DexEncodedMethod[] methods = new DexEncodedMethod[1 + this.descriptor.bridges.size()];
        int index = 0;
        DexMethod mainMethod = this.rewriter.factory.createMethod(this.type, this.descriptor.erasedProto, this.descriptor.name);
        methods[index++] = new DexEncodedMethod(mainMethod, MethodAccessFlags.fromSharedAccessFlags(17, false), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(new LambdaMainMethodSourceCode(this, mainMethod)));
        for (DexProto bridgeProto : this.descriptor.bridges) {
            DexMethod bridgeMethod = this.rewriter.factory.createMethod(this.type, bridgeProto, this.descriptor.name);
            methods[index++] = new DexEncodedMethod(bridgeMethod, MethodAccessFlags.fromSharedAccessFlags(4177, false), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(new LambdaBridgeMethodSourceCode(this, mainMethod, bridgeMethod)));
        }
        return methods;
    }

    private DexEncodedMethod[] synthesizeDirectMethods() {
        boolean stateless = this.isStateless();
        DexEncodedMethod[] methods = new DexEncodedMethod[stateless ? 2 : 1];
        methods[0] = new DexEncodedMethod(this.constructor, MethodAccessFlags.fromSharedAccessFlags((stateless ? 2 : 1) | 0x1000, true), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(new LambdaConstructorSourceCode(this)));
        if (stateless) {
            methods[1] = new DexEncodedMethod(this.classConstructor, MethodAccessFlags.fromSharedAccessFlags(4104, true), DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(new LambdaClassConstructorSourceCode(this)));
        }
        return methods;
    }

    private DexEncodedField[] synthesizeInstanceFields() {
        DexType[] fieldTypes = this.descriptor.captures.values;
        int fieldCount = fieldTypes.length;
        DexEncodedField[] fields = new DexEncodedField[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            FieldAccessFlags accessFlags = FieldAccessFlags.fromSharedAccessFlags(4114);
            fields[i] = new DexEncodedField(this.getCaptureField(i), accessFlags, DexAnnotationSet.empty(), null);
        }
        return fields;
    }

    private DexEncodedField[] synthesizeStaticFields() {
        if (!this.isStateless()) {
            return DexEncodedField.EMPTY_ARRAY;
        }
        assert (this.instanceField != null);
        DexEncodedField[] fields = new DexEncodedField[]{new DexEncodedField(this.instanceField, FieldAccessFlags.fromSharedAccessFlags(4121), DexAnnotationSet.empty(), DexValue.DexValueNull.NULL)};
        return fields;
    }

    private DexTypeList buildInterfaces() {
        List<DexType> interfaces = this.descriptor.interfaces;
        return interfaces.isEmpty() ? DexTypeList.empty() : new DexTypeList(interfaces.toArray(new DexType[interfaces.size()]));
    }

    private Target createTarget(DexType accessedFrom) {
        if (this.descriptor.delegatesToLambdaImplMethod()) {
            return this.createLambdaImplMethodTarget(accessedFrom);
        }
        switch (this.descriptor.implHandle.type) {
            case INVOKE_SUPER: {
                throw new Unimplemented("Method references to super methods are not yet supported");
            }
            case INVOKE_INTERFACE: {
                return this.createInterfaceMethodTarget(accessedFrom);
            }
            case INVOKE_CONSTRUCTOR: {
                return this.createConstructorTarget(accessedFrom);
            }
            case INVOKE_STATIC: {
                return this.createStaticMethodTarget(accessedFrom);
            }
            case INVOKE_DIRECT: 
            case INVOKE_INSTANCE: {
                return this.createInstanceMethodTarget(accessedFrom);
            }
        }
        throw new Unreachable("Unexpected method handle type in " + this.descriptor.implHandle);
    }

    private Target createLambdaImplMethodTarget(DexType accessedFrom) {
        DexMethodHandle implHandle = this.descriptor.implHandle;
        assert (implHandle != null);
        DexMethod implMethod = implHandle.asMethod();
        assert (implMethod.holder == accessedFrom);
        assert (this.descriptor.targetFoundInClass(accessedFrom));
        assert (this.descriptor.getAccessibility() != null);
        assert (this.descriptor.getAccessibility().isSynthetic());
        if (implHandle.type.isInvokeStatic()) {
            return new StaticLambdaImplTarget();
        }
        assert (implHandle.type.isInvokeInstance() || implHandle.type.isInvokeDirect());
        DexProto implProto = implMethod.proto;
        DexType[] implParams = implProto.parameters.values;
        DexType[] newParams = new DexType[implParams.length + 1];
        newParams[0] = implMethod.holder;
        System.arraycopy(implParams, 0, newParams, 1, implParams.length);
        DexProto newProto = this.rewriter.factory.createProto(implProto.returnType, newParams);
        return new InstanceLambdaImplTarget(this.rewriter.factory.createMethod(implMethod.holder, newProto, implMethod.name));
    }

    private Target createInstanceMethodTarget(DexType accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeInstance() || this.descriptor.implHandle.type.isInvokeDirect());
        if (!this.descriptor.needsAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(Invoke.Type.VIRTUAL);
        }
        DexMethod implMethod = this.descriptor.implHandle.asMethod();
        DexProto implProto = implMethod.proto;
        DexType[] implParams = implProto.parameters.values;
        DexType[] accessorParams = new DexType[1 + implParams.length];
        accessorParams[0] = this.descriptor.getImplReceiverType();
        System.arraycopy(implParams, 0, accessorParams, 1, implParams.length);
        DexProto accessorProto = this.rewriter.factory.createProto(implProto.returnType, accessorParams);
        DexMethod accessorMethod = this.rewriter.factory.createMethod(accessedFrom, accessorProto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(accessorMethod);
    }

    private Target createStaticMethodTarget(DexType accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeStatic());
        if (!this.descriptor.needsAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(Invoke.Type.STATIC);
        }
        DexMethod accessorMethod = this.rewriter.factory.createMethod(accessedFrom, this.descriptor.implHandle.asMethod().proto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(accessorMethod);
    }

    private Target createConstructorTarget(DexType accessedFrom) {
        DexMethodHandle implHandle = this.descriptor.implHandle;
        assert (implHandle != null);
        assert (implHandle.type.isInvokeConstructor());
        if (!this.descriptor.needsAccessor(accessedFrom)) {
            return new NoAccessorMethodTarget(Invoke.Type.DIRECT);
        }
        DexMethod implMethod = implHandle.asMethod();
        DexType returnType = implMethod.holder;
        DexProto accessorProto = this.rewriter.factory.createProto(returnType, implMethod.proto.parameters.values);
        DexMethod accessorMethod = this.rewriter.factory.createMethod(accessedFrom, accessorProto, this.generateUniqueLambdaMethodName());
        return new ClassMethodWithAccessorTarget(accessorMethod);
    }

    private Target createInterfaceMethodTarget(DexType accessedFrom) {
        assert (this.descriptor.implHandle.type.isInvokeInterface());
        assert (!this.descriptor.needsAccessor(accessedFrom));
        return new NoAccessorMethodTarget(Invoke.Type.INTERFACE);
    }

    private DexString generateUniqueLambdaMethodName() {
        return this.rewriter.factory.createString("lambda$" + this.descriptor.uniqueId);
    }

    private class ClassMethodWithAccessorTarget
    extends Target {
        ClassMethodWithAccessorTarget(DexMethod accessorMethod) {
            super(accessorMethod, Invoke.Type.STATIC);
        }

        @Override
        boolean ensureAccessibility() {
            DexProgramClass accessorClass = this.programDefinitionFor(this.callTarget.holder);
            assert (accessorClass != null);
            MethodAccessFlags accessorFlags = MethodAccessFlags.fromSharedAccessFlags(4105, false);
            DexEncodedMethod accessorEncodedMethod = new DexEncodedMethod(this.callTarget, accessorFlags, DexAnnotationSet.empty(), ParameterAnnotationsList.empty(), new SynthesizedCode(new AccessorMethodSourceCode(LambdaClass.this)));
            accessorClass.setDirectMethods(this.appendMethod(accessorClass.directMethods(), accessorEncodedMethod));
            LambdaClass.this.rewriter.converter.optimizeSynthesizedMethod(accessorEncodedMethod);
            return true;
        }

        private DexEncodedMethod[] appendMethod(DexEncodedMethod[] methods, DexEncodedMethod method) {
            int size = methods.length;
            DexEncodedMethod[] newMethods = new DexEncodedMethod[size + 1];
            System.arraycopy(methods, 0, newMethods, 0, size);
            newMethods[size] = method;
            return newMethods;
        }
    }

    private class InstanceLambdaImplTarget
    extends Target {
        InstanceLambdaImplTarget(DexMethod staticMethod) {
            super(staticMethod, Invoke.Type.STATIC);
        }

        @Override
        boolean ensureAccessibility() {
            DexMethod implMethod = LambdaClass.this.descriptor.implHandle.asMethod();
            DexClass implMethodHolder = this.definitionFor(implMethod.holder);
            DexEncodedMethod[] directMethods = implMethodHolder.directMethods();
            for (int i = 0; i < directMethods.length; ++i) {
                DexEncodedMethod encodedMethod = directMethods[i];
                if (!implMethod.match(encodedMethod)) continue;
                DexEncodedMethod newMethod = new DexEncodedMethod(this.callTarget, encodedMethod.accessFlags, encodedMethod.annotations, encodedMethod.parameterAnnotationsList, encodedMethod.getCode());
                encodedMethod.accessFlags.setStatic();
                encodedMethod.accessFlags.unsetPrivate();
                encodedMethod.accessFlags.setPublic();
                DexCode dexCode = newMethod.getCode().asDexCode();
                dexCode.setDebugInfo(dexCode.debugInfoWithAdditionalFirstParameter(null));
                assert (dexCode.getDebugInfo() == null || this.callTarget.getArity() == dexCode.getDebugInfo().parameters.length);
                directMethods[i] = newMethod;
                return true;
            }
            return false;
        }
    }

    private final class StaticLambdaImplTarget
    extends Target {
        StaticLambdaImplTarget() {
            super(LambdaClass.this.descriptor.implHandle.asMethod(), Invoke.Type.STATIC);
        }

        @Override
        boolean ensureAccessibility() {
            assert (LambdaClass.this.descriptor.getAccessibility() != null);
            LambdaClass.this.descriptor.getAccessibility().unsetPrivate();
            DexClass implMethodHolder = this.definitionFor(LambdaClass.this.descriptor.implHandle.asMethod().holder);
            if (implMethodHolder.isInterface()) {
                LambdaClass.this.descriptor.getAccessibility().setPublic();
            }
            return true;
        }
    }

    private final class NoAccessorMethodTarget
    extends Target {
        NoAccessorMethodTarget(Invoke.Type invokeType) {
            super(LambdaClass.this.descriptor.implHandle.asMethod(), invokeType);
        }

        @Override
        boolean ensureAccessibility() {
            return true;
        }
    }

    abstract class Target {
        final DexMethod callTarget;
        final Invoke.Type invokeType;

        Target(DexMethod callTarget, Invoke.Type invokeType) {
            assert (callTarget != null);
            assert (invokeType != null);
            this.callTarget = callTarget;
            this.invokeType = invokeType;
        }

        abstract boolean ensureAccessibility();

        DexClass definitionFor(DexType type) {
            return LambdaClass.this.rewriter.converter.appInfo.app.definitionFor(type);
        }

        DexProgramClass programDefinitionFor(DexType type) {
            return LambdaClass.this.rewriter.converter.appInfo.app.programDefinitionFor(type);
        }
    }
}

