/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.conversion;

import com.android.tools.r8.com.google.common.collect.ArrayListMultimap;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithSubtyping;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.analysis.constant.SparseConditionalConstantPropagation;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeEnvironment;
import com.android.tools.r8.ir.code.AlwaysMaterializingDefinition;
import com.android.tools.r8.ir.code.AlwaysMaterializingUser;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.CallGraph;
import com.android.tools.r8.ir.conversion.CallSiteInformation;
import com.android.tools.r8.ir.conversion.CfBuilder;
import com.android.tools.r8.ir.conversion.LensCodeRewriter;
import com.android.tools.r8.ir.conversion.OptimizationFeedback;
import com.android.tools.r8.ir.conversion.OptimizationFeedbackDirect;
import com.android.tools.r8.ir.conversion.OptimizationFeedbackIgnore;
import com.android.tools.r8.ir.conversion.OptimizationFeedbackSimple;
import com.android.tools.r8.ir.desugar.CovariantReturnTypeAnnotationTransformer;
import com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import com.android.tools.r8.ir.desugar.LambdaRewriter;
import com.android.tools.r8.ir.desugar.StringConcatRewriter;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.ConstantCanonicalizer;
import com.android.tools.r8.ir.optimize.DeadCodeRemover;
import com.android.tools.r8.ir.optimize.Devirtualizer;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.MemberValuePropagation;
import com.android.tools.r8.ir.optimize.NonNullTracker;
import com.android.tools.r8.ir.optimize.Outliner;
import com.android.tools.r8.ir.optimize.PeepholeOptimizer;
import com.android.tools.r8.ir.optimize.classinliner.ClassInliner;
import com.android.tools.r8.ir.optimize.lambda.LambdaMerger;
import com.android.tools.r8.ir.regalloc.LinearScanRegisterAllocator;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import com.android.tools.r8.naming.IdentifierNameStringMarker;
import com.android.tools.r8.shaking.protolite.ProtoLitePruner;
import com.android.tools.r8.utils.CfgPrinter;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IRConverter {
    private static final int PEEPHOLE_OPTIMIZATION_PASSES = 2;
    private final Timing timing;
    public final AppInfo appInfo;
    private final Outliner outliner;
    private final StringConcatRewriter stringConcatRewriter;
    private final LambdaRewriter lambdaRewriter;
    private final InterfaceMethodRewriter interfaceMethodRewriter;
    private final LambdaMerger lambdaMerger;
    private final ClassInliner classInliner;
    private final InternalOptions options;
    private final CfgPrinter printer;
    private final GraphLense graphLense;
    private final CodeRewriter codeRewriter;
    private final MemberValuePropagation memberValuePropagation;
    private final LensCodeRewriter lensCodeRewriter;
    private final NonNullTracker nonNullTracker;
    private final Inliner inliner;
    private final ProtoLitePruner protoLiteRewriter;
    private final IdentifierNameStringMarker identifierNameStringMarker;
    private final Devirtualizer devirtualizer;
    private final CovariantReturnTypeAnnotationTransformer covariantReturnTypeAnnotationTransformer;
    private final OptimizationFeedback ignoreOptimizationFeedback = new OptimizationFeedbackIgnore();
    private final OptimizationFeedback simpleOptimizationFeedback = new OptimizationFeedbackSimple();
    private DexString highestSortingString;

    private IRConverter(AppInfo appInfo, InternalOptions options, Timing timing, CfgPrinter printer, GraphLense graphLense, boolean enableWholeProgramOptimizations) {
        assert (appInfo != null);
        assert (options != null);
        assert (options.programConsumer != null);
        this.timing = timing != null ? timing : new Timing("internal");
        this.appInfo = appInfo;
        this.graphLense = graphLense != null ? graphLense : GraphLense.getIdentityLense();
        this.options = options;
        this.printer = printer;
        this.codeRewriter = new CodeRewriter(appInfo, this.libraryMethodsReturningReceiver(), options);
        this.stringConcatRewriter = new StringConcatRewriter(options.itemFactory);
        this.lambdaRewriter = options.enableDesugaring ? new LambdaRewriter(this) : null;
        this.interfaceMethodRewriter = options.enableDesugaring && this.enableInterfaceMethodDesugaring() ? new InterfaceMethodRewriter(this, options) : null;
        this.lambdaMerger = options.enableLambdaMerging ? new LambdaMerger(appInfo.dexItemFactory, options.reporter) : null;
        CovariantReturnTypeAnnotationTransformer covariantReturnTypeAnnotationTransformer = this.covariantReturnTypeAnnotationTransformer = options.processCovariantReturnTypeAnnotations ? new CovariantReturnTypeAnnotationTransformer(this, appInfo.dexItemFactory) : null;
        if (enableWholeProgramOptimizations) {
            assert (appInfo.hasLiveness());
            this.nonNullTracker = new NonNullTracker();
            this.inliner = new Inliner(appInfo.withLiveness(), graphLense, options);
            this.outliner = new Outliner(appInfo.withLiveness(), options);
            this.memberValuePropagation = options.enableValuePropagation ? new MemberValuePropagation(appInfo.withLiveness()) : null;
            this.lensCodeRewriter = new LensCodeRewriter(graphLense, appInfo.withSubtyping(), options);
            if (appInfo.hasLiveness()) {
                this.protoLiteRewriter = options.forceProguardCompatibility ? null : new ProtoLitePruner(appInfo.withLiveness());
                this.identifierNameStringMarker = !appInfo.withLiveness().identifierNameStrings.isEmpty() && options.enableMinification ? new IdentifierNameStringMarker(appInfo.withLiveness()) : null;
                this.devirtualizer = options.enableDevirtualization ? new Devirtualizer(appInfo.withLiveness()) : null;
            } else {
                this.protoLiteRewriter = null;
                this.identifierNameStringMarker = null;
                this.devirtualizer = null;
            }
        } else {
            this.nonNullTracker = null;
            this.inliner = null;
            this.outliner = null;
            this.memberValuePropagation = null;
            this.lensCodeRewriter = null;
            this.protoLiteRewriter = null;
            this.identifierNameStringMarker = null;
            this.devirtualizer = null;
        }
        this.classInliner = options.enableClassInlining && options.enableInlining && this.inliner != null ? new ClassInliner(appInfo.dexItemFactory, options.classInliningInstructionLimit) : null;
    }

    public IRConverter(AppInfo appInfo, InternalOptions options) {
        this(appInfo, options, null, null, null, false);
    }

    public IRConverter(AppInfo appInfo, InternalOptions options, Timing timing, CfgPrinter printer) {
        this(appInfo, options, timing, printer, null, false);
    }

    public IRConverter(AppInfoWithSubtyping appInfo, InternalOptions options, Timing timing, CfgPrinter printer, GraphLense graphLense) {
        this(appInfo, options, timing, printer, graphLense, true);
    }

    private boolean enableInterfaceMethodDesugaring() {
        switch (this.options.interfaceMethodDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return !this.options.canUseDefaultAndStaticInterfaceMethods();
            }
        }
        throw new Unreachable();
    }

    private boolean enableTryWithResourcesDesugaring() {
        switch (this.options.tryWithResourcesDesugaring) {
            case Off: {
                return false;
            }
            case Auto: {
                return !this.options.canUseSuppressedExceptions();
            }
        }
        throw new Unreachable();
    }

    private Set<DexMethod> libraryMethodsReturningReceiver() {
        HashSet<DexMethod> methods = new HashSet<DexMethod>();
        DexItemFactory dexItemFactory = this.appInfo.dexItemFactory;
        dexItemFactory.stringBufferMethods.forEachAppendMethod(methods::add);
        dexItemFactory.stringBuilderMethods.forEachAppendMethod(methods::add);
        return methods;
    }

    private void removeLambdaDeserializationMethods() {
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.removeLambdaDeserializationMethods(this.appInfo.classes());
        }
    }

    private void synthesizeLambdaClasses(DexApplication.Builder<?> builder) {
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.adjustAccessibility();
            this.lambdaRewriter.synthesizeLambdaClasses(builder);
        }
    }

    private void desugarInterfaceMethods(DexApplication.Builder<?> builder, InterfaceMethodRewriter.Flavor includeAllResources) {
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.desugarInterfaceMethods(builder, includeAllResources);
        }
    }

    private void processCovariantReturnTypeAnnotations(DexApplication.Builder<?> builder) {
        if (this.covariantReturnTypeAnnotationTransformer != null) {
            this.covariantReturnTypeAnnotationTransformer.process(builder);
        }
    }

    public DexApplication convertToDex(DexApplication application, ExecutorService executor) throws ExecutionException {
        this.removeLambdaDeserializationMethods();
        this.timing.begin("IR conversion");
        this.convertClassesToDex(application.classes(), executor);
        DexApplication.Builder<?> builder = application.builder();
        builder.setHighestSortingString(this.highestSortingString);
        this.synthesizeLambdaClasses(builder);
        this.desugarInterfaceMethods(builder, InterfaceMethodRewriter.Flavor.ExcludeDexResources);
        this.processCovariantReturnTypeAnnotations(builder);
        this.handleSynthesizedClassMapping(builder);
        this.timing.end();
        return builder.build();
    }

    private void handleSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        if (this.options.intermediate) {
            this.updateSynthesizedClassMapping(builder);
        }
        this.updateMainDexListWithSynthesizedClassMap(builder);
        if (!this.options.intermediate) {
            this.clearSynthesizedClassMapping(builder);
        }
    }

    private void updateMainDexListWithSynthesizedClassMap(DexApplication.Builder<?> builder) {
        Set<DexType> inputMainDexList = builder.getMainDexList();
        if (!inputMainDexList.isEmpty()) {
            Map programClasses = builder.getProgramClasses().stream().collect(Collectors.toMap(programClass -> programClass.type, Function.identity()));
            ArrayList<DexType> synthesized = new ArrayList<DexType>();
            for (DexType dexType : inputMainDexList) {
                DexProgramClass programClass2 = (DexProgramClass)programClasses.get(dexType);
                if (programClass2 == null) continue;
                synthesized.addAll(DexAnnotation.readAnnotationSynthesizedClassMap(programClass2, builder.dexItemFactory));
            }
            builder.addToMainDexList(synthesized);
        }
    }

    private void clearSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        for (DexProgramClass programClass : builder.getProgramClasses()) {
            programClass.annotations = programClass.annotations.getWithout(builder.dexItemFactory.annotationSynthesizedClassMap);
        }
    }

    private void updateSynthesizedClassMapping(DexApplication.Builder<?> builder) {
        ArrayListMultimap<DexProgramClass, DexProgramClass> originalToSynthesized = ArrayListMultimap.create();
        for (DexProgramClass dexProgramClass2 : builder.getSynthesizedClasses()) {
            for (DexProgramClass original : dexProgramClass2.getSynthesizedFrom()) {
                originalToSynthesized.put(original, dexProgramClass2);
            }
        }
        for (Map.Entry entry : originalToSynthesized.asMap().entrySet()) {
            DexProgramClass original = (DexProgramClass)entry.getKey();
            HashSet<DexType> synthesized = new HashSet<DexType>();
            ((Collection)entry.getValue()).stream().map(dexProgramClass -> dexProgramClass.type).forEach(synthesized::add);
            synthesized.addAll(DexAnnotation.readAnnotationSynthesizedClassMap(original, builder.dexItemFactory));
            DexAnnotation updatedAnnotation = DexAnnotation.createAnnotationSynthesizedClassMap(synthesized, builder.dexItemFactory);
            original.annotations = original.annotations.getWithAddedOrReplaced(updatedAnnotation);
        }
    }

    private void convertClassesToDex(Iterable<DexProgramClass> classes, ExecutorService executor) throws ExecutionException {
        ArrayList futures = new ArrayList();
        for (DexProgramClass clazz : classes) {
            futures.add(executor.submit(() -> this.convertMethodsToDex(clazz)));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private void convertMethodsToDex(DexProgramClass clazz) {
        for (DexEncodedMethod method2 : clazz.directMethods()) {
            if (!method2.isClassInitializer()) continue;
            this.convertMethodToDex(method2);
            break;
        }
        clazz.forEachMethod(method -> {
            if (!method.isClassInitializer()) {
                this.convertMethodToDex((DexEncodedMethod)method);
            }
        });
    }

    private void convertMethodToDex(DexEncodedMethod method) {
        boolean matchesMethodFilter;
        assert (this.options.isGeneratingDex());
        if (method.getCode() != null && (matchesMethodFilter = this.options.methodMatchesFilter(method))) {
            if (!this.options.passthroughDexCode || !method.getCode().isDexCode()) {
                this.rewriteCode(method, this.simpleOptimizationFeedback, x -> true, CallSiteInformation.empty(), Outliner::noProcessing);
            }
            this.updateHighestSortingStrings(method);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexApplication optimize(DexApplication application) throws ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            DexApplication dexApplication = this.optimize(application, executor);
            return dexApplication;
        }
        finally {
            executor.shutdown();
        }
    }

    public DexApplication optimize(DexApplication application, ExecutorService executorService) throws ExecutionException {
        this.removeLambdaDeserializationMethods();
        this.collectLambdaMergingCandidates(application);
        OptimizationFeedbackDirect directFeedback = new OptimizationFeedbackDirect();
        this.timing.begin("Build call graph");
        CallGraph callGraph = CallGraph.build(application, this.appInfo.withLiveness(), this.graphLense, this.options);
        this.timing.end();
        this.timing.begin("IR conversion phase 1");
        BiConsumer<IRCode, DexEncodedMethod> outlineHandler = this.outliner == null ? Outliner::noProcessing : this.outliner.identifyCandidateMethods();
        callGraph.forEachMethod((method, isProcessedConcurrently) -> this.processMethod((DexEncodedMethod)method, directFeedback, (Predicate<DexEncodedMethod>)isProcessedConcurrently, callGraph, outlineHandler), executorService);
        this.timing.end();
        DexApplication.Builder<?> builder = application.builder();
        builder.setHighestSortingString(this.highestSortingString);
        if (this.inliner != null) {
            this.inliner.processDoubleInlineCallers(this, directFeedback);
        }
        this.synthesizeLambdaClasses(builder);
        this.desugarInterfaceMethods(builder, InterfaceMethodRewriter.Flavor.IncludeAllResources);
        this.handleSynthesizedClassMapping(builder);
        this.finalizeLambdaMerging(application, directFeedback, builder, executorService);
        if (this.outliner != null) {
            this.timing.begin("IR conversion phase 2");
            if (this.outliner.selectMethodsForOutlining()) {
                this.forEachSelectedOutliningMethod(executorService, (code, method) -> {
                    this.printMethod((IRCode)code, "IR before outlining (SSA)");
                    this.outliner.identifyOutlineSites((IRCode)code, (DexEncodedMethod)method);
                });
                DexProgramClass outlineClass = this.outliner.buildOutlinerClass(this.computeOutlineClassType());
                this.optimizeSynthesizedClass(outlineClass);
                this.forEachSelectedOutliningMethod(executorService, (code, method) -> {
                    this.outliner.applyOutliningCandidate((IRCode)code, (DexEncodedMethod)method);
                    this.printMethod((IRCode)code, "IR after outlining (SSA)");
                    this.finalizeIR((DexEncodedMethod)method, (IRCode)code, this.ignoreOptimizationFeedback);
                });
                assert (this.outliner.checkAllOutlineSitesFoundAgain());
                builder.addSynthesizedClass(outlineClass, true);
                this.clearDexMethodCompilationState(outlineClass);
            }
            this.timing.end();
        }
        this.clearDexMethodCompilationState();
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInFields();
        }
        return builder.build();
    }

    private void forEachSelectedOutliningMethod(ExecutorService executorService, BiConsumer<IRCode, DexEncodedMethod> consumer) throws ExecutionException {
        assert (!this.options.skipIR);
        Set<DexEncodedMethod> methods = this.outliner.getMethodsSelectedForOutlining();
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        for (DexEncodedMethod method : methods) {
            futures.add(executorService.submit(() -> {
                IRCode code = method.buildIR(this.appInfo, this.options, this.appInfo.originFor(method.method.holder));
                assert (code != null);
                assert (!method.getCode().isOutlineCode());
                this.codeRewriter.rewriteMoveResult(code);
                DeadCodeRemover.removeDeadCode(code, this.codeRewriter, this.graphLense, this.options);
                consumer.accept(code, method);
                return null;
            }));
        }
        ThreadUtils.awaitFutures(futures);
    }

    private void collectLambdaMergingCandidates(DexApplication application) {
        if (this.lambdaMerger != null) {
            this.lambdaMerger.collectGroupCandidates(application, this.appInfo.withLiveness(), this.options);
        }
    }

    private void finalizeLambdaMerging(DexApplication application, OptimizationFeedback directFeedback, DexApplication.Builder<?> builder, ExecutorService executorService) throws ExecutionException {
        if (this.lambdaMerger != null) {
            this.lambdaMerger.applyLambdaClassMapping(application, this, directFeedback, builder, executorService);
        }
    }

    private void clearDexMethodCompilationState() {
        this.appInfo.classes().forEach(this::clearDexMethodCompilationState);
    }

    private void clearDexMethodCompilationState(DexProgramClass clazz) {
        clazz.forEachMethod(DexEncodedMethod::markNotProcessed);
    }

    public void replaceCodeForTesting(DexEncodedMethod method, IRCode code) {
        assert (code.isConsistentSSA());
        code.traceBlocks();
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.options);
    }

    private DexType computeOutlineClassType() {
        String name;
        DexType result;
        int count = 0;
        do {
            name = "r8.GeneratedOutlineSupport" + (count == 0 ? "" : Integer.toString(count));
            ++count;
        } while (this.appInfo.definitionFor(result = this.appInfo.dexItemFactory.createType(DescriptorUtils.javaTypeToDescriptor(name))) != null);
        this.appInfo.registerNewType(result, this.appInfo.dexItemFactory.objectType);
        return result;
    }

    public void optimizeSynthesizedClass(DexProgramClass clazz) {
        try {
            this.codeRewriter.enterCachedClass(clazz);
            clazz.forEachMethodThrowing(this::optimizeSynthesizedMethod);
        }
        finally {
            this.codeRewriter.leaveCachedClass(clazz);
        }
    }

    public void optimizeSynthesizedMethod(DexEncodedMethod method) {
        this.processMethod(method, this.ignoreOptimizationFeedback, x -> false, CallSiteInformation.empty(), Outliner::noProcessing);
    }

    private String logCode(InternalOptions options, DexEncodedMethod method) {
        return options.useSmaliSyntax ? method.toSmaliString(null) : method.codeToString();
    }

    public void processMethod(DexEncodedMethod method, OptimizationFeedback feedback, Predicate<DexEncodedMethod> isProcessedConcurrently, CallSiteInformation callSiteInformation, BiConsumer<IRCode, DexEncodedMethod> outlineHandler) {
        Code code = method.getCode();
        boolean matchesMethodFilter = this.options.methodMatchesFilter(method);
        if (code != null && matchesMethodFilter) {
            this.rewriteCode(method, feedback, isProcessedConcurrently, callSiteInformation, outlineHandler);
        } else {
            method.markProcessed(Inliner.Constraint.NEVER);
        }
    }

    private static void invertConditionalsForTesting(IRCode code) {
        for (BasicBlock block : code.blocks) {
            if (!block.exit().isIf()) continue;
            block.exit().asIf().invert();
        }
    }

    private void rewriteCode(DexEncodedMethod method, OptimizationFeedback feedback, Predicate<DexEncodedMethod> isProcessedConcurrently, CallSiteInformation callSiteInformation, BiConsumer<IRCode, DexEncodedMethod> outlineHandler) {
        if (this.options.verbose) {
            this.options.reporter.info(new StringDiagnostic("Processing: " + method.toSourceString()));
        }
        if (this.options.skipIR) {
            feedback.markProcessed(method, Inliner.Constraint.NEVER);
            return;
        }
        IRCode code = method.buildIR(this.appInfo, this.options, this.appInfo.originFor(method.method.holder));
        if (code == null) {
            feedback.markProcessed(method, Inliner.Constraint.NEVER);
            return;
        }
        this.printC1VisualizerHeader(method);
        this.printMethod(code, "Initial IR (SSA)");
        if (this.options.canHaveArtStringNewInitBug()) {
            CodeRewriter.ensureDirectStringNewToInit(code);
        }
        if (this.options.debug) {
            this.codeRewriter.simplifyDebugLocals(code);
        }
        if (!method.isProcessed()) {
            if (this.protoLiteRewriter != null && this.protoLiteRewriter.appliesTo(method)) {
                this.protoLiteRewriter.rewriteProtoLiteSpecialMethod(code, method);
            }
            if (this.lensCodeRewriter != null) {
                this.lensCodeRewriter.rewrite(code, method);
            } else assert (this.graphLense.isIdentityLense());
        }
        if (this.identifierNameStringMarker != null) {
            this.identifierNameStringMarker.decoupleIdentifierNameStringsInMethod(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.memberValuePropagation != null) {
            this.memberValuePropagation.rewriteWithConstantValues(code, method.method.holder);
        }
        if (this.options.enableSwitchMapRemoval && this.appInfo.hasLiveness()) {
            this.codeRewriter.removeSwitchMaps(code);
        }
        if (this.options.disableAssertions) {
            this.codeRewriter.disableAssertions(this.appInfo, method, code, feedback);
        }
        if (this.options.enableNonNullTracking && this.nonNullTracker != null) {
            this.nonNullTracker.addNonNull(code);
            assert (code.isConsistentSSA());
        }
        TypeEnvironment typeEnvironment = TypeAnalysis.getDefaultTypeEnvironment();
        if (this.options.enableInlining && this.inliner != null) {
            typeEnvironment = new TypeAnalysis(this.appInfo, method, code);
            assert (!this.options.debug);
            this.inliner.performInlining(method, code, typeEnvironment, isProcessedConcurrently, callSiteInformation);
        }
        if (this.devirtualizer != null) {
            this.devirtualizer.devirtualizeInvokeInterface(code, typeEnvironment, method.method.getHolder());
        }
        this.codeRewriter.removeCasts(code, typeEnvironment);
        this.codeRewriter.rewriteLongCompareAndRequireNonNull(code, this.options);
        this.codeRewriter.commonSubexpressionElimination(code);
        this.codeRewriter.simplifyArrayConstruction(code);
        this.codeRewriter.rewriteMoveResult(code);
        this.codeRewriter.splitRangeInvokeConstants(code);
        new SparseConditionalConstantPropagation(code).run();
        this.codeRewriter.rewriteSwitch(code);
        this.codeRewriter.processMethodsNeverReturningNormally(code);
        this.codeRewriter.simplifyIf(code, typeEnvironment);
        if (this.options.testing.invertConditionals) {
            IRConverter.invertConditionalsForTesting(code);
        }
        if (this.options.enableNonNullTracking && this.nonNullTracker != null) {
            this.nonNullTracker.cleanupNonNull(code);
            assert (code.isConsistentSSA());
        }
        if (!this.options.debug) {
            this.codeRewriter.collectClassInitializerDefaults(method, code);
        }
        DeadCodeRemover.removeDeadCode(code, this.codeRewriter, this.graphLense, this.options);
        assert (code.isConsistentSSA());
        if (this.options.enableDesugaring && this.enableTryWithResourcesDesugaring()) {
            this.codeRewriter.rewriteThrowableAddAndGetSuppressed(code);
        }
        this.stringConcatRewriter.desugarStringConcats(method.method, code);
        if (this.lambdaRewriter != null) {
            this.lambdaRewriter.desugarLambdas(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.interfaceMethodRewriter != null) {
            this.interfaceMethodRewriter.rewriteMethodReferences(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.lambdaMerger != null) {
            this.lambdaMerger.processMethodCode(method, code);
            assert (code.isConsistentSSA());
        }
        if (this.classInliner != null) {
            assert (this.options.enableInlining && this.inliner != null);
            this.classInliner.processMethodCode(this.appInfo.withSubtyping(), method, code, isProcessedConcurrently, methodsToInline -> this.inliner.performForcedInlining(method, code, methodsToInline));
            assert (code.isConsistentSSA());
        }
        if (this.options.outline.enabled) {
            outlineHandler.accept(code, method);
            assert (code.isConsistentSSA());
        }
        ConstantCanonicalizer.canonicalize(code);
        this.codeRewriter.useDedicatedConstantForLitInstruction(code);
        this.codeRewriter.shortenLiveRanges(code);
        this.codeRewriter.identifyReturnsArgument(method, code, feedback);
        if (this.options.enableInlining && this.inliner != null) {
            this.codeRewriter.identifyInvokeSemanticsForInlining(method, code, feedback);
        }
        if (this.options.methodMatchesLogArgumentsFilter(method)) {
            this.codeRewriter.logArgumentTypes(method, code);
            assert (code.isConsistentSSA());
        }
        this.codeRewriter.identifyClassInlinerEligibility(method, code, feedback);
        if (this.options.canHaveNumberConversionRegisterAllocationBug()) {
            this.codeRewriter.workaroundNumberConversionRegisterAllocationBug(code);
        }
        this.printMethod(code, "Optimized IR (SSA)");
        this.finalizeIR(method, code, feedback);
    }

    private void finalizeIR(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        code.traceBlocks();
        if (this.options.isGeneratingClassFiles()) {
            this.finalizeToCf(method, code, feedback);
        } else {
            assert (this.options.isGeneratingDex());
            this.finalizeToDex(method, code, feedback);
        }
    }

    private void finalizeToCf(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        assert (!method.getCode().isDexCode());
        CfBuilder builder = new CfBuilder(method, code, this.options.itemFactory);
        CfCode result = builder.build(this.codeRewriter, this.graphLense, this.options, this.appInfo.withSubtyping());
        method.setCode(result);
        this.markProcessed(method, code, feedback);
    }

    private void finalizeToDex(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        RegisterAllocator registerAllocator = this.performRegisterAllocation(code, method);
        method.setCode(code, registerAllocator, this.options);
        this.updateHighestSortingStrings(method);
        this.printMethod(code, "Final IR (non-SSA)");
        this.markProcessed(method, code, feedback);
    }

    private void markProcessed(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback) {
        Inliner.Constraint state = !this.options.enableInlining || this.inliner == null ? Inliner.Constraint.NEVER : this.inliner.computeInliningConstraint(code, method);
        feedback.markProcessed(method, state);
    }

    private synchronized void updateHighestSortingStrings(DexEncodedMethod method) {
        DexString highestSortingReferencedString = method.getCode().asDexCode().highestSortingString;
        if (highestSortingReferencedString != null && (this.highestSortingString == null || highestSortingReferencedString.slowCompareTo(this.highestSortingString) > 0)) {
            this.highestSortingString = highestSortingReferencedString;
        }
    }

    private RegisterAllocator performRegisterAllocation(IRCode code, DexEncodedMethod method) {
        DeadCodeRemover.removeDeadCode(code, this.codeRewriter, this.graphLense, this.options);
        IRConverter.materializeInstructionBeforeLongOperationsWorkaround(code, this.options);
        LinearScanRegisterAllocator registerAllocator = new LinearScanRegisterAllocator(code, this.options);
        registerAllocator.allocateRegisters(this.options.debug);
        this.printMethod(code, "After register allocation (non-SSA)");
        for (int i = 0; i < 2; ++i) {
            CodeRewriter.collapsTrivialGotos(method, code);
            PeepholeOptimizer.optimize(code, registerAllocator);
        }
        CodeRewriter.collapsTrivialGotos(method, code);
        return registerAllocator;
    }

    private static void materializeInstructionBeforeLongOperationsWorkaround(IRCode code, InternalOptions options) {
        if (!options.canHaveDex2OatLinkedListBug()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator();
            Object firstMaterializing = it.nextUntil(IRConverter::isMaterializingInstructionOnArtArmVersionM);
            if (!IRConverter.needsInstructionBeforeLongOperation((Instruction)firstMaterializing)) continue;
            IRConverter.ensureInstructionBeforeLongOperation(code, block, (Instruction)firstMaterializing, it);
        }
    }

    private static void ensureInstructionBeforeLongOperation(IRCode code, BasicBlock block, Instruction firstMaterializing, InstructionListIterator it) {
        Instruction check = (Instruction)it.previous();
        assert (firstMaterializing == check);
        Value fixitValue = code.createValue(ValueType.INT);
        AlwaysMaterializingDefinition fixitDefinition = new AlwaysMaterializingDefinition(fixitValue);
        fixitDefinition.setBlock(block);
        fixitDefinition.setPosition(firstMaterializing.getPosition());
        it.add(fixitDefinition);
        AlwaysMaterializingUser fixitUser = new AlwaysMaterializingUser(fixitValue);
        fixitUser.setBlock(block);
        it.add(fixitUser);
    }

    private static boolean needsInstructionBeforeLongOperation(Instruction instruction) {
        if (!instruction.isAdd() && !instruction.isSub() || !instruction.outType().isWide()) {
            return false;
        }
        BasicBlock block = instruction.getBlock();
        for (BasicBlock pred : block.getPredecessors()) {
            if (pred.exit().fallthroughBlock() != block) continue;
            return false;
        }
        return true;
    }

    private static boolean isMaterializingInstructionOnArtArmVersionM(Instruction instruction) {
        return !instruction.isDebugInstruction() && !instruction.isMove() && !IRConverter.isPossiblyNonMaterializingLongOperationOnArtArmVersionM(instruction);
    }

    private static boolean isPossiblyNonMaterializingLongOperationOnArtArmVersionM(Instruction instruction) {
        return (instruction.isMul() || instruction.isDiv()) && instruction.outType().isWide();
    }

    private void printC1VisualizerHeader(DexEncodedMethod method) {
        if (this.printer != null) {
            this.printer.begin("compilation");
            this.printer.print("name \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("method \"").append(method.toSourceString()).append("\"").ln();
            this.printer.print("date 0").ln();
            this.printer.end("compilation");
        }
    }

    private void printMethod(IRCode code, String title) {
        if (this.printer != null) {
            this.printer.resetUnusedValue();
            this.printer.begin("cfg");
            this.printer.print("name \"").append(title).append("\"\n");
            code.print(this.printer);
            this.printer.end("cfg");
        }
    }
}

