/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.signature;

import com.android.tools.r8.naming.signature.GenericSignatureAction;
import java.lang.reflect.GenericSignatureFormatError;
import java.nio.CharBuffer;

public class GenericSignatureParser<T> {
    private final GenericSignatureAction<T> actions;
    private char symbol;
    private String identifier;
    private boolean eof;
    private char[] buffer;
    private int pos;

    public GenericSignatureParser(GenericSignatureAction<T> actions) {
        this.actions = actions;
    }

    public void parseClassSignature(String signature) {
        try {
            this.actions.start();
            this.setInput(signature);
            this.parseClassSignature();
            this.actions.stop();
        }
        catch (GenericSignatureFormatError e) {
            throw e;
        }
        catch (Throwable t) {
            GenericSignatureFormatError e = new GenericSignatureFormatError("Unknown error parsing generic signature: " + t.getMessage());
            e.addSuppressed(t);
            throw e;
        }
    }

    public void parseMethodSignature(String signature) {
        try {
            this.actions.start();
            this.setInput(signature);
            this.parseMethodTypeSignature();
            this.actions.stop();
        }
        catch (GenericSignatureFormatError e) {
            throw e;
        }
        catch (Throwable t) {
            GenericSignatureFormatError e = new GenericSignatureFormatError("Unknown error parsing generic signature: " + t.getMessage());
            e.addSuppressed(t);
            throw e;
        }
    }

    public void parseFieldSignature(String signature) {
        try {
            this.actions.start();
            this.setInput(signature);
            this.parseFieldTypeSignature();
            this.actions.stop();
        }
        catch (GenericSignatureFormatError e) {
            throw e;
        }
        catch (Throwable t) {
            GenericSignatureFormatError e = new GenericSignatureFormatError("Unknown error parsing generic signature: " + t.getMessage());
            e.addSuppressed(t);
            throw e;
        }
    }

    private void setInput(String input) {
        this.buffer = input.toCharArray();
        this.eof = false;
        this.pos = 0;
        this.symbol = '\u0000';
        this.identifier = null;
        this.scanSymbol();
    }

    void parseClassSignature() {
        this.parseOptFormalTypeParameters();
        this.parseClassTypeSignature();
        while (this.symbol > '\u0000') {
            this.parseClassTypeSignature();
        }
    }

    void parseOptFormalTypeParameters() {
        if (this.symbol == '<') {
            this.actions.parsedSymbol(this.symbol);
            this.scanSymbol();
            this.updateFormalTypeParameter();
            while (this.symbol != '>' && this.symbol > '\u0000') {
                this.updateFormalTypeParameter();
            }
            this.actions.parsedSymbol(this.symbol);
            this.expect('>');
        }
    }

    void updateFormalTypeParameter() {
        this.scanIdentifier();
        assert (this.identifier != null);
        this.actions.parsedIdentifier(this.identifier);
        this.actions.parsedSymbol(this.symbol);
        this.expect(':');
        if (this.symbol == 'L' || this.symbol == '[' || this.symbol == 'T') {
            this.parseFieldTypeSignature();
        }
        while (this.symbol == ':') {
            this.actions.parsedSymbol(this.symbol);
            this.scanSymbol();
            this.parseFieldTypeSignature();
        }
    }

    private void parseFieldTypeSignature() {
        switch (this.symbol) {
            case 'L': {
                this.parseClassTypeSignature();
                break;
            }
            case '[': {
                this.actions.parsedSymbol(this.symbol);
                this.scanSymbol();
                this.updateTypeSignature();
                break;
            }
            case 'T': {
                this.updateTypeVariableSignature();
                break;
            }
            default: {
                this.parseError("Expected L, [ or T", this.pos);
            }
        }
    }

    private void parseClassTypeSignature() {
        this.actions.parsedSymbol(this.symbol);
        this.expect('L');
        StringBuilder qualIdent = new StringBuilder();
        this.scanIdentifier();
        assert (this.identifier != null);
        while (this.symbol == '/') {
            qualIdent.append(this.identifier).append(this.symbol);
            this.scanSymbol();
            this.scanIdentifier();
            assert (this.identifier != null);
        }
        qualIdent.append(this.identifier);
        T parsedEnclosingType = this.actions.parsedTypeName(qualIdent.toString());
        this.updateOptTypeArguments();
        while (this.symbol == '.') {
            this.actions.parsedSymbol(this.symbol);
            this.scanSymbol();
            this.scanIdentifier();
            assert (this.identifier != null);
            parsedEnclosingType = this.actions.parsedInnerTypeName(parsedEnclosingType, this.identifier);
            this.updateOptTypeArguments();
        }
        this.actions.parsedSymbol(this.symbol);
        this.expect(';');
    }

    private void updateOptTypeArguments() {
        if (this.symbol == '<') {
            this.actions.parsedSymbol(this.symbol);
            this.scanSymbol();
            this.updateTypeArgument();
            while (this.symbol != '>' && this.symbol > '\u0000') {
                this.updateTypeArgument();
            }
            this.actions.parsedSymbol(this.symbol);
            this.expect('>');
        }
    }

    private void updateTypeArgument() {
        if (this.symbol == '*') {
            this.actions.parsedSymbol(this.symbol);
            this.scanSymbol();
        } else if (this.symbol == '+') {
            this.actions.parsedSymbol(this.symbol);
            this.scanSymbol();
            this.parseFieldTypeSignature();
        } else if (this.symbol == '-') {
            this.actions.parsedSymbol(this.symbol);
            this.scanSymbol();
            this.parseFieldTypeSignature();
        } else {
            this.parseFieldTypeSignature();
        }
    }

    private void updateTypeVariableSignature() {
        this.actions.parsedSymbol(this.symbol);
        this.expect('T');
        this.scanIdentifier();
        assert (this.identifier != null);
        this.actions.parsedIdentifier(this.identifier);
        this.actions.parsedSymbol(this.symbol);
        this.expect(';');
    }

    private void updateTypeSignature() {
        switch (this.symbol) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                this.actions.parsedSymbol(this.symbol);
                this.scanSymbol();
                break;
            }
            default: {
                this.parseFieldTypeSignature();
            }
        }
    }

    private void parseMethodTypeSignature() {
        this.parseOptFormalTypeParameters();
        this.actions.parsedSymbol(this.symbol);
        this.expect('(');
        while (this.symbol != ')' && this.symbol > '\u0000') {
            this.updateTypeSignature();
        }
        this.actions.parsedSymbol(this.symbol);
        this.expect(')');
        this.updateReturnType();
        if (this.symbol == '^') {
            do {
                this.actions.parsedSymbol(this.symbol);
                this.scanSymbol();
                if (this.symbol == 'T') {
                    this.updateTypeVariableSignature();
                    continue;
                }
                this.parseClassTypeSignature();
            } while (this.symbol == '^');
        }
    }

    private void updateReturnType() {
        if (this.symbol != 'V') {
            this.updateTypeSignature();
        } else {
            this.actions.parsedSymbol(this.symbol);
            this.scanSymbol();
        }
    }

    private void scanSymbol() {
        if (!this.eof) {
            assert (this.buffer != null);
            if (this.pos < this.buffer.length) {
                this.symbol = this.buffer[this.pos];
                ++this.pos;
            } else {
                this.symbol = '\u0000';
                this.eof = true;
            }
        } else {
            this.parseError("Unexpected end of signature", this.pos);
        }
    }

    private void expect(char c) {
        if (this.eof) {
            this.parseError("Unexpected end of signature", this.pos);
        }
        if (this.symbol == c) {
            this.scanSymbol();
        } else {
            this.parseError("Expected " + c, this.pos - 1);
        }
    }

    private boolean isStopSymbol(char ch) {
        switch (ch) {
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': {
                return true;
            }
        }
        return false;
    }

    private void scanIdentifier() {
        if (!this.eof && this.pos < this.buffer.length) {
            StringBuilder identBuf = new StringBuilder(32);
            if (!this.isStopSymbol(this.symbol)) {
                identBuf.append(this.symbol);
                char[] bufferLocal = this.buffer;
                assert (bufferLocal != null);
                do {
                    char ch;
                    if ((ch = bufferLocal[this.pos]) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || !this.isStopSymbol(ch)) {
                        identBuf.append(bufferLocal[this.pos]);
                        ++this.pos;
                        continue;
                    }
                    this.identifier = identBuf.toString();
                    this.scanSymbol();
                    return;
                } while (this.pos != bufferLocal.length);
                this.identifier = identBuf.toString();
                this.symbol = '\u0000';
                this.eof = true;
            } else {
                this.symbol = '\u0000';
                this.eof = true;
                this.parseError();
            }
        } else {
            this.parseError("Unexpected end of signature", this.pos);
        }
    }

    private void parseError() {
        this.parseError("Unexpected", this.pos);
    }

    private void parseError(String message, int pos) {
        String arrow = CharBuffer.allocate(pos).toString().replace('\u0000', ' ') + '^';
        throw new GenericSignatureFormatError(message + " at position " + (pos + 1) + "\n" + String.valueOf(this.buffer) + "\n" + arrow);
    }
}

