/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Streams;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.classinliner.InlineCandidateProcessor;
import com.android.tools.r8.shaking.Enqueuer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ClassInliner {
    private final DexItemFactory factory;
    private final int totalMethodInstructionLimit;
    private final ConcurrentHashMap<DexType, Boolean> knownClasses = new ConcurrentHashMap();

    public ClassInliner(DexItemFactory factory, int totalMethodInstructionLimit) {
        this.factory = factory;
        this.totalMethodInstructionLimit = totalMethodInstructionLimit;
    }

    public final void processMethodCode(Enqueuer.AppInfoWithLiveness appInfo, DexEncodedMethod method, IRCode code, Predicate<DexEncodedMethod> isProcessedConcurrently, InlinerAction inliner, Supplier<InliningOracle> defaultOracle) {
        List roots = Streams.stream(code.instructionIterator()).filter(insn -> insn.isNewInstance() || insn.isStaticGet()).collect(Collectors.toList());
        for (Instruction root : roots) {
            InlineCandidateProcessor processor = new InlineCandidateProcessor(this.factory, appInfo, type -> this.isClassEligible(appInfo, (DexType)type), isProcessedConcurrently, method, root);
            if (!processor.isInstanceEligible() || !processor.isClassAndUsageEligible() || !processor.areInstanceUsersEligible(defaultOracle) || processor.getEstimatedCombinedSizeForInlining() >= this.totalMethodInstructionLimit) continue;
            processor.processInlining(code, inliner);
            code.removeAllTrivialPhis();
            assert (code.isConsistentSSA());
        }
    }

    private boolean isClassEligible(AppInfo appInfo, DexType clazz) {
        Boolean eligible = this.knownClasses.get(clazz);
        if (eligible == null) {
            Boolean computed = this.computeClassEligible(appInfo, clazz);
            Boolean existing = this.knownClasses.putIfAbsent(clazz, computed);
            assert (existing == null || existing == computed);
            eligible = existing == null ? computed : existing;
        }
        return eligible;
    }

    private boolean computeClassEligible(AppInfo appInfo, DexType clazz) {
        DexClass definition = appInfo.definitionFor(clazz);
        if (definition == null || definition.isLibraryClass() || definition.accessFlags.isAbstract() || definition.accessFlags.isInterface()) {
            return false;
        }
        if (definition.superType != this.factory.objectType) {
            return false;
        }
        for (DexEncodedMethod method : definition.virtualMethods()) {
            if (method.method.name != this.factory.finalizeMethodName || method.method.proto != this.factory.objectMethods.finalize.proto) continue;
            return false;
        }
        return !appInfo.canTriggerStaticInitializer(clazz, true);
    }

    public static interface InlinerAction {
        public void inline(Map<InvokeMethod, Inliner.InliningInfo> var1);
    }
}

