/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.it.unimi.dsi.fastutil.ints;

import com.android.tools.r8.it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.chars.CharCollection;
import com.android.tools.r8.it.unimi.dsi.fastutil.chars.CharIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.AbstractInt2CharFunction;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.AbstractIntSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2CharMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectIterator;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractInt2CharMap
extends AbstractInt2CharFunction
implements Int2CharMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractInt2CharMap() {
    }

    @Override
    public boolean containsValue(char v) {
        return this.values().contains(v);
    }

    @Override
    @Deprecated
    public boolean containsValue(Object ov) {
        if (ov == null) {
            return false;
        }
        return this.containsValue(((Character)ov).charValue());
    }

    @Override
    public boolean containsKey(int k) {
        ObjectIterator<Int2CharMap.Entry> i = this.int2CharEntrySet().iterator();
        while (i.hasNext()) {
            if (((Int2CharMap.Entry)i.next()).getIntKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Character> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Integer, ? extends Character>> i = m.entrySet().iterator();
        if (m instanceof Int2CharMap) {
            while (n-- != 0) {
                Int2CharMap.Entry e = (Int2CharMap.Entry)i.next();
                this.put(e.getIntKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Integer, ? extends Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public IntSet keySet() {
        return new AbstractIntSet(){

            @Override
            public boolean contains(int k) {
                return AbstractInt2CharMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractInt2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2CharMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    final ObjectIterator<Map.Entry<Integer, Character>> i;
                    {
                        this.i = AbstractInt2CharMap.this.entrySet().iterator();
                    }

                    @Override
                    public int nextInt() {
                        return ((Int2CharMap.Entry)this.i.next()).getIntKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            @Override
            public boolean contains(char k) {
                return AbstractInt2CharMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractInt2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractInt2CharMap.this.clear();
            }

            @Override
            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<Integer, Character>> i;
                    {
                        this.i = AbstractInt2CharMap.this.entrySet().iterator();
                    }

                    @Override
                    @Deprecated
                    public char nextChar() {
                        return ((Int2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    @Deprecated
    public ObjectSet<Map.Entry<Integer, Character>> entrySet() {
        return this.int2CharEntrySet();
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Map.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Int2CharMap.Entry e = (Int2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getIntKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Int2CharMap.Entry {
        protected int key;
        protected char value;

        public BasicEntry(Integer key, Character value) {
            this.key = key;
            this.value = value.charValue();
        }

        public BasicEntry(int key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @Deprecated
        public Integer getKey() {
            return this.key;
        }

        @Override
        public int getIntKey() {
            return this.key;
        }

        @Override
        @Deprecated
        public Character getValue() {
            return Character.valueOf(this.value);
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Character setValue(Character value) {
            return Character.valueOf(this.setValue(value.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (e.getKey() == null || !(e.getKey() instanceof Integer)) {
                return false;
            }
            if (e.getValue() == null || !(e.getValue() instanceof Character)) {
                return false;
            }
            return this.key == (Integer)e.getKey() && this.value == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

