/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLense;
import com.android.tools.r8.ir.code.Invoke;
import java.util.Set;

final class PublicizerLense
extends GraphLense.NestedGraphLense {
    private final AppInfo appInfo;
    private final Set<DexMethod> publicizedMethods;

    PublicizerLense(AppInfo appInfo, GraphLense previousLense, Set<DexMethod> publicizedMethods) {
        super(ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), previousLense, appInfo.dexItemFactory);
        this.appInfo = appInfo;
        this.publicizedMethods = publicizedMethods;
    }

    @Override
    public GraphLense.GraphLenseLookupResult lookupMethod(DexMethod method, DexEncodedMethod context, Invoke.Type type) {
        DexEncodedMethod actualEncodedTarget;
        DexClass holderClass;
        GraphLense.GraphLenseLookupResult previous = this.previousLense.lookupMethod(method, context, type);
        method = previous.getMethod();
        type = previous.getType();
        if (type == Invoke.Type.DIRECT && this.publicizedMethods.contains(method) && (holderClass = this.appInfo.definitionFor(method.holder)) != null && (actualEncodedTarget = holderClass.lookupVirtualMethod(method)) != null && actualEncodedTarget.isPublicized()) {
            return new GraphLense.GraphLenseLookupResult(method, Invoke.Type.VIRTUAL);
        }
        return super.lookupMethod(method, context, type);
    }

    static PublicizedLenseBuilder createBuilder() {
        return new PublicizedLenseBuilder();
    }

    static class PublicizedLenseBuilder {
        private final ImmutableSet.Builder<DexMethod> methodSetBuilder = ImmutableSet.builder();

        private PublicizedLenseBuilder() {
        }

        public GraphLense build(AppInfo appInfo, GraphLense previousLense) {
            return new PublicizerLense(appInfo, previousLense, (Set<DexMethod>)((Object)this.methodSetBuilder.build()));
        }

        public void add(DexMethod publicizedMethod) {
            this.methodSetBuilder.add((Object)publicizedMethod);
        }
    }
}

